/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchMetrics;
import oracle.classloader.SearchPolicy;

public class InterceptingBeforeDelegatingSearchPolicy
extends SearchPolicy {
    private ClassLoader delegate;
    private List<String> m_packagesToDelegate = new ArrayList<String>();

    public InterceptingBeforeDelegatingSearchPolicy(String string, ClassLoader classLoader) {
        super(string);
        this.delegate = classLoader;
    }

    @Override
    protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        if (this.isClassIncluded(className)) {
            try {
                return this.delegate.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChildr) {
        return this.delegate.getResource(resourceName);
    }

    @Override
    public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        try {
            Enumeration<URL> e = this.delegate.getResources(resourceName);
            while (e.hasMoreElements()) {
                resources.add(e.nextElement());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
        return true;
    }

    public void addPackagesToDelegate(List<String> pckgs) {
        this.m_packagesToDelegate.addAll(pckgs);
    }

    private boolean isClassIncluded(String clazz) {
        for (String s : this.m_packagesToDelegate) {
            if (!clazz.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

