/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedCodeSourceURL;
import oracle.classloader.util.ClassLoadLogger;
import oracle.ide.boot.JarDirs;

final class IdeSharedJar
extends SharedCodeSource {
    private static final int KEEP_OPEN_JARS;
    private static final int LRU_CACHE_SIZE;
    private static final int LRU_CACHE_PERCENT = 20;
    private static final boolean LEAKED_JAR_HANDLE_WARNING;
    private static final Map<IdeSharedJar, IdeSharedJar> lruCache;
    private static final AtomicInteger keepOpenCounter;
    private volatile boolean keepOpen = keepOpenCounter.decrementAndGet() >= 0;
    private JarFile jar;
    private Manifest manifest;
    private int refCount;
    private final File file;
    private final int[] hashes;

    IdeSharedJar(File existingCanonicalFile, URL location) {
        super(location, existingCanonicalFile.lastModified(), existingCanonicalFile.length());
        this.file = existingCanonicalFile;
        this.hashes = new JarDirs(existingCanonicalFile).getHashes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSubstituteFor(int equalityPolicy, File targetFile, PolicyClassLoader subscriber) {
        if (equalityPolicy == 0) {
            return true;
        }
        boolean result = false;
        if (targetFile.isFile() && this.file.length() == targetFile.length()) {
            JarFile ourJar = null;
            JarFile otherJar = null;
            try {
                ourJar = this.acquireJar();
                otherJar = new JarFile(targetFile);
                Manifest ourManifest = this.getManifest();
                Manifest otherManifest = otherJar.getManifest();
                if ((ourManifest == null && otherManifest == null || ourManifest.equals(otherManifest)) && ourJar.size() == otherJar.size()) {
                    result = equalityPolicy == 3 ? IdeSharedJar.entriesEqual(ourJar, otherJar) : equalityPolicy != 4;
                }
            }
            catch (IOException e) {
            }
            finally {
                this.releaseJar(ourJar);
                try {
                    if (otherJar != null) {
                        otherJar.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    private static boolean entriesEqual(ZipFile left, ZipFile right) {
        boolean result = true;
        try {
            Enumeration<? extends ZipEntry> enumL = left.entries();
            Enumeration<? extends ZipEntry> enumR = right.entries();
            while (enumL.hasMoreElements()) {
                ZipEntry el = enumL.nextElement();
                ZipEntry er = enumR.nextElement();
                if (!el.getName().equals(er.getName())) {
                    result = false;
                } else if (el.getSize() != er.getSize()) {
                    result = false;
                } else {
                    if (el.getCrc() == er.getCrc()) continue;
                    result = false;
                }
                break;
            }
        }
        catch (Throwable e) {
            result = false;
        }
        return result;
    }

    @Override
    protected void doOpen() throws IOException {
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file + " does not exist.");
        }
        if (this.keepOpen) {
            this.jar = new JarFile(this.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        this.manifest = null;
        Map<IdeSharedJar, IdeSharedJar> map = lruCache;
        synchronized (map) {
            this.closeJar();
            lruCache.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Manifest doGetManifest() throws IOException {
        if (this.manifest != null) return this.manifest;
        JarFile jar = null;
        try {
            jar = this.acquireJar();
            this.manifest = jar.getManifest();
            if (this.manifest == null) return this.manifest;
            if (this.manifest.getEntries().isEmpty()) return this.manifest;
            InputStream stream = null;
            try {
                JarEntry entry = jar.entries().nextElement();
                stream = jar.getInputStream(entry);
                if (!this.keepOpen && stream.getClass().getName().endsWith("VerifierStream")) {
                    this.keepOpen = true;
                    keepOpenCounter.decrementAndGet();
                    Map<IdeSharedJar, IdeSharedJar> map = lruCache;
                    synchronized (map) {
                        lruCache.remove(this);
                    }
                }
                if (stream == null) return this.manifest;
            }
            catch (Throwable t) {
                try {
                    ClassLoadLogger.log(Level.CONFIG, "Jar verifier pre-load: " + t);
                    return this.manifest;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            try {
                stream.close();
                return this.manifest;
            }
            catch (IOException e) {
                return this.manifest;
            }
        }
        finally {
            this.releaseJar(jar);
        }
    }

    @Override
    protected long doGetSize() throws IOException {
        return this.file.length();
    }

    @Override
    protected long doGetLastModifiedTime() throws IOException {
        return this.file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetLastModifiedTime(String relPath) throws IOException {
        JarFile jar = null;
        try {
            jar = this.acquireJar();
            JarEntry entry = jar.getJarEntry(relPath);
            long l = entry == null ? 0L : entry.getTime();
            return l;
        }
        finally {
            this.releaseJar(jar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetLength(String relPath) {
        JarFile jar = null;
        try {
            jar = this.acquireJar();
            JarEntry entry = jar.getJarEntry(relPath);
            if (entry != null) {
                long l = entry.getSize();
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (IOException e) {
            long l = -1L;
            return l;
        }
        finally {
            this.releaseJar(jar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUpdateDigest(MessageDigest digest) throws IOException {
        FileInputStream in = null;
        try {
            byte[] buffer = new byte[4096];
            in = new FileInputStream(this.file);
            int bytesRead = 0;
            while ((bytesRead = in.read(buffer)) > 0) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doContainsResource(String relPath) throws IOException {
        if (this.isPotentiallySelected(relPath)) {
            JarFile jar = null;
            try {
                jar = this.acquireJar();
                boolean bl = jar.getJarEntry(relPath) != null;
                return bl;
            }
            finally {
                this.releaseJar(jar);
            }
        }
        return false;
    }

    @Override
    protected File doGetFile(String relPath) {
        return relPath == null ? this.file : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected URL doGetResource(String relPath) {
        if (!this.isPotentiallySelected(relPath)) return null;
        try {
            JarFile jar = null;
            try {
                jar = this.acquireJar();
                JarEntry entry = jar.getJarEntry(relPath);
                if (entry == null) return null;
                URL uRL = SharedCodeSourceURL.create(this.getLocation(), relPath);
                return uRL;
            }
            finally {
                this.releaseJar(jar);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RecoverableByteBuffer doGetResourceBytes(int currentMaintenanceTick, String relPath, RecoverableByteBuffer buffer) throws IOException {
        if (this.isPotentiallySelected(relPath)) {
            JarFile jar = null;
            try {
                jar = this.acquireJar();
                JarEntry entry = jar.getJarEntry(relPath);
                if (entry != null) {
                    int size = (int)entry.getSize();
                    if (buffer == null) {
                        buffer = new RecoverableByteBuffer(size);
                    }
                    InputStream in = null;
                    try {
                        in = jar.getInputStream(entry);
                        buffer.read(this, currentMaintenanceTick, in, size);
                        buffer.setCertificates(entry.getCertificates());
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                    RecoverableByteBuffer recoverableByteBuffer = buffer;
                    return recoverableByteBuffer;
                }
                RecoverableByteBuffer recoverableByteBuffer = null;
                return recoverableByteBuffer;
            }
            finally {
                this.releaseJar(jar);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream doGetStream(String relPath) throws IOException {
        if (this.isPotentiallySelected(relPath)) {
            FilterInputStream is = null;
            JarFile jar = null;
            try {
                final JarFile localJar = jar = this.acquireJar();
                JarEntry entry = jar.getJarEntry(relPath);
                if (entry != null) {
                    is = new FilterInputStream(jar.getInputStream(entry)){
                        private final RuntimeException allocated;
                        private final AtomicBoolean released;
                        {
                            super(x0);
                            this.allocated = LEAKED_JAR_HANDLE_WARNING ? new RuntimeException() : null;
                            this.released = new AtomicBoolean();
                        }

                        @Override
                        public void close() throws IOException {
                            if (!this.released.getAndSet(true)) {
                                IdeSharedJar.this.releaseJar(localJar);
                            }
                            super.close();
                        }

                        protected void finalize() {
                            if (!this.released.get()) {
                                if (LEAKED_JAR_HANDLE_WARNING) {
                                    System.out.println("WARNING: Jar file handle leaked for " + localJar.getName());
                                    this.allocated.printStackTrace();
                                }
                                IdeSharedJar.this.releaseJar(localJar);
                            }
                        }
                    };
                }
            }
            finally {
                if (is != null) {
                    return is;
                }
                this.releaseJar(jar);
            }
        }
        throw new FileNotFoundException(relPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean addPaths(ArrayList list, boolean includeDirectoryPaths) {
        try {
            JarFile jar = null;
            try {
                jar = this.acquireJar();
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (includeDirectoryPaths) {
                        list.add(name);
                        continue;
                    }
                    if (entry.isDirectory()) continue;
                    list.add(name);
                }
            }
            finally {
                this.releaseJar(jar);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAddMetaInfPaths(List list) {
        try {
            JarFile jar = null;
            try {
                jar = this.acquireJar();
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || !name.startsWith("META-INF/")) continue;
                    list.add(name);
                }
            }
            finally {
                this.releaseJar(jar);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isPotentiallySelected(String relPath) {
        if (this.hashes != null && relPath != null) {
            int hash;
            int lastSlash = relPath.lastIndexOf(47);
            int n = hash = lastSlash > 0 ? relPath.substring(0, lastSlash).hashCode() : relPath.hashCode();
            if (hash == JarDirs.META_INF_HASHCODE && lastSlash == 8) {
                hash = relPath.hashCode();
            }
            return Arrays.binarySearch(this.hashes, hash) >= 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarFile acquireJar() throws IOException {
        if (!this.keepOpen) {
            Map<IdeSharedJar, IdeSharedJar> map = lruCache;
            synchronized (map) {
                if (this.jar == null) {
                    this.jar = new JarFile(this.file);
                }
                ++this.refCount;
                if (lruCache.get(this) == null) {
                    lruCache.put(this, this);
                }
            }
        }
        return this.jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseJar(JarFile jar) {
        if (!this.keepOpen && jar != null) {
            Map<IdeSharedJar, IdeSharedJar> map = lruCache;
            synchronized (map) {
                if (--this.refCount <= 0 && !lruCache.containsKey(this)) {
                    this.closeJar();
                }
            }
        }
    }

    private final void closeJar() {
        if (this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jar = null;
        }
    }

    static {
        int maxHandles = 500;
        String property = System.getProperty("ide.max.jar.handles");
        if (property != null) {
            try {
                maxHandles = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        LRU_CACHE_SIZE = maxHandles * 20 / 100;
        KEEP_OPEN_JARS = maxHandles - LRU_CACHE_SIZE;
        LEAKED_JAR_HANDLE_WARNING = Boolean.getBoolean("ide.leaked.jar.handle.warning");
        lruCache = new LinkedHashMap<IdeSharedJar, IdeSharedJar>(LRU_CACHE_SIZE, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<IdeSharedJar, IdeSharedJar> eldest) {
                if (this.size() > LRU_CACHE_SIZE) {
                    if (eldest.getValue().refCount <= 0) {
                        eldest.getValue().closeJar();
                    }
                    return true;
                }
                return false;
            }
        };
        keepOpenCounter = new AtomicInteger(KEEP_OPEN_JARS);
    }
}

