/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.CommitNotifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.BigWizardDialog;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMStateInfo;
import oracle.ide.wizard.FSMTransitionException;
import oracle.ide.wizard.FSMWizardListener;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WizardArb;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;

public class BigFSMWizard
extends Wizard
implements CommitNotifier {
    private final FSM _fsm;
    private final Namespace _data;
    private final WizardCallbacks _wc;
    private WizardDialog _dialog;
    private FSMStateInfo _curFsmStateInfo;
    private EventListenerList _commitListeners;
    private ArrayList<FSMWizardListener> _wizardListeners;
    private boolean _skipCurStep;
    private String _wizardTitle;
    private int _direction;
    private boolean _dontSelect = true;
    private Map _pagePool = new HashMap();
    private FSMStateInfo _gotoStateInfo;
    private boolean _disposed;
    private boolean _useBigSize;

    public BigFSMWizard(Step[] stepArray, Namespace namespace) {
        this(FSMBuilder.newFSM((Step[])stepArray), namespace);
    }

    public BigFSMWizard(FSM fSM, Namespace namespace) {
        if (fSM == null) {
            throw new IllegalArgumentException(WizardArb.getString((int)28));
        }
        if (namespace == null) {
            throw new IllegalArgumentException("BigFSMWizard data cannot be null.");
        }
        fSM.reset();
        this._fsm = fSM;
        this._data = namespace;
        this._wc = new WC();
        this._populatePages();
        fSM.reset();
        this.selectPage(this.getPageAt(0));
        this.setRoadmapVisible(true);
    }

    public void setUseBigSize(boolean bl) {
        this._useBigSize = bl;
    }

    private WizardDialog getDialogImpl(Frame frame, Dialog dialog) {
        if (this._dialog == null) {
            this._dialog = this._useBigSize ? (dialog != null ? new BigWizardDialog((BaseWizard)this, dialog) : (frame != null ? new BigWizardDialog((BaseWizard)this, frame) : new BigWizardDialog((BaseWizard)this))) : (dialog != null ? new WizardDialog((BaseWizard)this, dialog) : (frame != null ? new WizardDialog((BaseWizard)this, frame) : new WizardDialog((BaseWizard)this)));
        }
        this._dialog.setWizardTitle(this._wizardTitle);
        return this._dialog;
    }

    public void setWizardTitle(String string) {
        this._wizardTitle = string;
        if (this._dialog != null) {
            this._dialog.setWizardTitle(string);
        }
    }

    public void setShowStepNumber(boolean bl) {
    }

    public boolean getShowStepNumber() {
        return true;
    }

    public void setWelcomePageAdded(boolean bl) {
    }

    public void setFinishPageAdded(boolean bl) {
    }

    public void addCommitListener(CommitListener commitListener) {
        if (this._commitListeners == null) {
            this._commitListeners = new EventListenerList();
        }
        this._commitListeners.add(CommitListener.class, commitListener);
    }

    public void removeCommitListener(CommitListener commitListener) {
        if (this._commitListeners != null) {
            this._commitListeners.remove(CommitListener.class, commitListener);
        }
    }

    public void addFSMWizardListener(FSMWizardListener fSMWizardListener) {
        if (fSMWizardListener != null) {
            if (this._wizardListeners == null) {
                this._wizardListeners = new ArrayList();
            }
            this._wizardListeners.add(fSMWizardListener);
        }
    }

    public void removeFSMWizardListener(FSMWizardListener fSMWizardListener) {
        if (fSMWizardListener != null && this._wizardListeners != null) {
            this._wizardListeners.remove(fSMWizardListener);
        }
    }

    public void updateImage(Image image) {
    }

    public WizardDialog getDialog(Frame frame) {
        return this.getDialogImpl(frame, null);
    }

    public WizardDialog getDialog(Dialog dialog) {
        return this.getDialogImpl(null, dialog);
    }

    public void setDialog(WizardDialog wizardDialog) {
        this._dialog = wizardDialog;
    }

    public void dispose() {
        super.dispose();
        this._disposed = true;
    }

    public boolean isDisposed() {
        return this._disposed;
    }

    public void reset() {
        super.reset();
        this._fsm.reset();
        this._curFsmStateInfo = null;
    }

    protected void doPrevious() {
        WizardPage wizardPage = this.getPreviousPage(this.getSelectedPage());
        if (wizardPage != null) {
            this.selectPage(wizardPage, true);
        }
    }

    protected void doNext() {
        WizardPage wizardPage = this.getNextPage(this.getSelectedPage());
        if (wizardPage != null) {
            this.selectPage(wizardPage, true);
        }
    }

    protected void doFinish() {
        this._direction = 1;
        if (this._validateFSMState(true)) {
            super.doFinish();
        }
    }

    protected void doCancel() {
        if (this._commitListeners != null) {
            ApplyEvent applyEvent = null;
            EventListener[] eventListenerArray = this._commitListeners.getListeners(CommitListener.class);
            for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                if (applyEvent == null) {
                    TraversableContext traversableContext = new TraversableContext(this._data, 2);
                    traversableContext.setWizardCallbacks(this._wc);
                    applyEvent = new ApplyEvent(traversableContext);
                }
                try {
                    ((CommitListener)eventListenerArray[i]).cancel(applyEvent);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)runtimeException);
                }
            }
        }
        super.doCancel();
    }

    protected void selectPage(WizardPage wizardPage, boolean bl) {
        if (this._dontSelect) {
            return;
        }
        if (wizardPage == null) {
            super.selectPage(wizardPage, bl);
            return;
        }
        WizardPage wizardPage2 = this.getSelectedPage();
        if (wizardPage2 == null || wizardPage == this.getNextPage(wizardPage2)) {
            this._direction = 1;
        } else if (wizardPage == this.getPreviousPage(wizardPage2)) {
            this._direction = 2;
        } else {
            return;
        }
        this._gotoStateInfo = null;
        if (!this._validateFSMState(false)) {
            return;
        }
        if (wizardPage2 != null) {
            wizardPage = this._direction == 1 ? this.getNextPage(wizardPage2) : this.getPreviousPage(wizardPage2);
        }
        if (((FSMWizardPage)wizardPage).getStateInfo() != this._gotoStateInfo) {
            return;
        }
        super.selectPage(wizardPage, bl);
        this._checkSkipThisPage(this._direction);
    }

    protected void setSelectedPage(WizardPage wizardPage) {
        super.setSelectedPage(wizardPage);
        if (wizardPage != null) {
            TraversableContext traversableContext = new TraversableContext(this._data, this._direction);
            traversableContext.setWizardCallbacks(this._wc);
            this.gotoPanel(wizardPage, this._gotoStateInfo, traversableContext);
        }
    }

    private void _populatePages() {
        try {
            FSMStateInfo fSMStateInfo = null;
            Object object = null;
            while ((fSMStateInfo = this._fsm.nextState(object)) != null) {
                this._addPage(fSMStateInfo, null);
                if (!fSMStateInfo.isFinalState()) {
                    object = fSMStateInfo.getStep().getExpectedTransition();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._dontSelect = false;
    }

    private WizardPage _addPage(FSMStateInfo fSMStateInfo, WizardPage wizardPage) {
        FSMWizardPage fSMWizardPage;
        String string;
        Step step = fSMStateInfo.getStep();
        String string2 = step.getPageTitle();
        Traversable traversable = fSMStateInfo.getTraversable((CommitNotifier)this);
        if (string2 == null && traversable instanceof DefaultTraversablePanel) {
            string2 = ((DefaultTraversablePanel)traversable).getDefaultTitle();
        }
        if (string2 == null) {
            string2 = fSMStateInfo.getStateID().toString();
        }
        if ((string = step.getStepLabel()) == null || "".equals(string)) {
            string = string2;
        }
        if ((fSMWizardPage = (FSMWizardPage)((Object)this._pagePool.get(fSMStateInfo))) == null) {
            fSMWizardPage = new FSMWizardPage(fSMStateInfo, traversable.getComponent(), string, string2);
            this._pagePool.put(fSMStateInfo, fSMWizardPage);
        } else {
            fSMWizardPage.setLabel(string);
            fSMWizardPage.setPageTitle(string2);
        }
        try {
            Map map = FSM.getTransitionMap((Map)this._fsm.getStateNode(fSMStateInfo.getStateID()));
            fSMWizardPage.setBranching(map.size() > 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (fSMWizardPage.getParent() == this) {
            if (wizardPage != null && wizardPage.getParent() == this && wizardPage.getIndex() - fSMWizardPage.getIndex() == 1) {
                return fSMWizardPage;
            }
            this.removePage(fSMWizardPage);
        }
        return this.addPage(fSMWizardPage, wizardPage);
    }

    private boolean _validateFSMState(boolean bl) {
        boolean bl2;
        FSMWizardPage fSMWizardPage = (FSMWizardPage)this.getSelectedPage();
        TraversableContext traversableContext = this.exitCurrentPanel(this._direction);
        boolean bl3 = bl2 = traversableContext != null;
        if (bl2) {
            bl2 = bl ? this.finishImpl(traversableContext) : this._canTraverseFSM();
        }
        if (fSMWizardPage != null) {
            fSMWizardPage.setValid(bl2);
        }
        return bl2;
    }

    private TraversableContext exitCurrentPanel(int n) {
        TraversableContext traversableContext = new TraversableContext(this._data, n);
        traversableContext.setWizardCallbacks(this._wc);
        if (this._curFsmStateInfo != null) {
            try {
                Traversable traversable = this._curFsmStateInfo.getTraversable((CommitNotifier)this);
                traversable.onExit(traversableContext);
                if (this._wizardListeners != null) {
                    for (FSMWizardListener fSMWizardListener : this._wizardListeners) {
                        fSMWizardListener.wizardPanelExited(traversable, traversableContext);
                    }
                }
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)((Object)this));
                return null;
            }
        }
        return traversableContext;
    }

    private boolean _canTraverseFSM() {
        try {
            if (this._direction == 1) {
                Object object;
                if (this._curFsmStateInfo != null) {
                    Traversable traversable = this._curFsmStateInfo.getTraversable((CommitNotifier)this);
                    object = traversable.getExitTransition();
                    this.updateExpectedTransition(object);
                } else {
                    object = null;
                }
                this._gotoStateInfo = this._fsm.nextState(object);
            } else {
                this._gotoStateInfo = this._fsm.previousState();
            }
        }
        catch (FSMTransitionException fSMTransitionException) {
            this.handleFSMTransitionException(fSMTransitionException);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private void gotoPanel(WizardPage wizardPage, FSMStateInfo fSMStateInfo, TraversableContext traversableContext) {
        this.enableButtons(null, null, true);
        Traversable traversable = fSMStateInfo.getTraversable((CommitNotifier)this);
        this._skipCurStep = false;
        this._curFsmStateInfo = fSMStateInfo;
        this.updatePageTitle(wizardPage, fSMStateInfo);
        try {
            traversable.onEntry(traversableContext);
            if (this._wizardListeners != null) {
                for (FSMWizardListener fSMWizardListener : this._wizardListeners) {
                    fSMWizardListener.wizardPanelEntered(traversable, traversableContext);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Component component = traversable.getComponent();
        if (wizardPage.getContent() != component) {
            wizardPage.setContent(component);
        }
        this.updateHelpID(wizardPage, fSMStateInfo.getStep(), traversable);
    }

    private void _checkSkipThisPage(int n) {
        if (this._skipCurStep) {
            this._skipCurStep = false;
            WizardPage wizardPage = this.getSelectedPage();
            switch (n) {
                case 1: {
                    if (this._fsm.isHalted()) break;
                    if (this.getNextPage(wizardPage) == null) {
                        this.doPrevious();
                    } else {
                        this.doNext();
                    }
                    return;
                }
                case 2: {
                    if (this._fsm.isStarting()) break;
                    if (this.getPreviousPage(wizardPage) == null) {
                        this.doNext();
                    } else {
                        this.doPrevious();
                    }
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void enableButtons(Boolean bl, Boolean bl2, Boolean bl3) {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return;
        }
        boolean bl4 = bl == null ? this._fsm.getStepNumber() > 1 : bl;
        wizardPage.setCanGoBack(bl4);
        boolean bl5 = bl2 == null ? !this._fsm.inFinalState() : bl2;
        boolean bl6 = bl3 == null ? this._fsm.inFinalState() : bl3.booleanValue();
        wizardPage.setCanAdvance(bl5 || bl6);
        this.setMustFinish(!bl6);
    }

    private boolean finishImpl(TraversableContext traversableContext) {
        try {
            if (this._commitListeners != null) {
                int n;
                ApplyEvent applyEvent = null;
                EventListener[] eventListenerArray = this._commitListeners.getListeners(CommitListener.class);
                for (n = eventListenerArray.length - 1; n >= 0; --n) {
                    if (applyEvent == null) {
                        applyEvent = new ApplyEvent(traversableContext);
                    }
                    try {
                        ((CommitListener)eventListenerArray[n]).checkCommit(applyEvent);
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)runtimeException);
                    }
                }
                try {
                    for (n = eventListenerArray.length - 1; n >= 0; --n) {
                        try {
                            ((CommitListener)eventListenerArray[n]).commit(applyEvent);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)runtimeException);
                        }
                    }
                }
                catch (TraversalException traversalException) {
                    for (int i = n + 1; i < eventListenerArray.length; ++i) {
                        try {
                            ((CommitListener)eventListenerArray[i]).rollback(applyEvent);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)runtimeException);
                        }
                    }
                    throw traversalException;
                }
            }
            return true;
        }
        catch (TraversalException traversalException) {
            traversalException.showMessageDialog((Component)((Object)this));
            return false;
        }
    }

    private void updateHelpID(WizardPage wizardPage, Step step, Traversable traversable) {
        JComponent jComponent = (JComponent)wizardPage.getContent();
        HelpUtils.setHelpID((JComponent)jComponent, null);
        String string = MetaTraversable.findHelpID((MetaTraversable)step, (Traversable)traversable);
        HelpUtils.setHelpID((JComponent)jComponent, (String)string);
    }

    private void updateAccessibleDescription(String string) {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage != null) {
            wizardPage.setAccessibleDescription(string);
        }
    }

    private void updatePageTitle(WizardPage wizardPage, FSMStateInfo fSMStateInfo) {
        Object object;
        Step step = fSMStateInfo.getStep();
        String string = step.getPageTitle();
        if (!ModelUtil.hasLength((String)string)) {
            object = this._curFsmStateInfo.getTraversable((CommitNotifier)this);
            if (object instanceof DefaultTraversablePanel) {
                string = ((DefaultTraversablePanel)object).getDefaultTitle();
            }
            if (!ModelUtil.hasLength((String)string)) {
                // empty if block
            }
        }
        wizardPage.setPageTitle(string);
        object = step.getStepLabel();
        if (object == null || "".equals(object)) {
            wizardPage.setLabel(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateExpectedTransition(Object object) {
        if (object == this._curFsmStateInfo.getStep().getExpectedTransition()) {
            return;
        }
        this._curFsmStateInfo.getStep().setExpectedTransition(object);
        WizardPage wizardPage = this.getSelectedPage();
        try {
            Map map = FSM.getTransitionMap((Map)this._fsm.getStateNode(this._curFsmStateInfo.getStateID()));
            wizardPage.setBranching(map.size() > 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 0;
        FSMStateInfo fSMStateInfo = null;
        this.freezeRepaints();
        try {
            while (true) {
                fSMStateInfo = this._fsm.nextState(object);
                ++n;
                WizardPage wizardPage2 = this.getNextPage(wizardPage);
                boolean bl = false;
                if (wizardPage2 != null) {
                    if (fSMStateInfo != null && ((FSMWizardPage)wizardPage2).getStateInfo() == fSMStateInfo) {
                        return;
                    }
                    bl = true;
                }
                if (fSMStateInfo != null) {
                    wizardPage = this._addPage(fSMStateInfo, wizardPage2);
                }
                if (bl) {
                    this.removePage(wizardPage2);
                }
                if (fSMStateInfo == null || fSMStateInfo.isFinalState()) {
                    if (wizardPage == null) return;
                    while ((wizardPage2 = this.getNextPage(wizardPage)) != null) {
                        this.removePage(wizardPage2);
                    }
                    return;
                }
                object = fSMStateInfo.getStep().getExpectedTransition();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                Object var5_10 = null;
                while (true) {
                    if (n-- <= 0) {
                    }
                    fSMStateInfo = this._fsm.previousState();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.unfreezeRepaints();
                if (fSMStateInfo == this._curFsmStateInfo) return;
                throw new IllegalStateException("Invalid State");
            }
        }
    }

    private void updateInitialFocus(Component component) {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage != null) {
            wizardPage.setInitialFocus(component);
        }
    }

    private void handleFSMTransitionException(FSMTransitionException fSMTransitionException) {
        TraversalException traversalException = new TraversalException("Internal error in FSM: " + fSMTransitionException.getLocalizedMessage());
        BigFSMWizard bigFSMWizard = this._dialog != null ? this._dialog : this;
        ExceptionDialog.showExceptionDialog((Component)((Object)bigFSMWizard), (Throwable)traversalException);
        traversalException.printStackTrace();
    }

    private final class WC
    extends WizardCallbacks {
        private WC() {
        }

        public void addCommitListener(CommitListener commitListener) {
            BigFSMWizard.this.addCommitListener(commitListener);
        }

        public void removeCommitListener(CommitListener commitListener) {
            BigFSMWizard.this.removeCommitListener(commitListener);
        }

        public void wizardEnableButtons(Boolean bl, Boolean bl2, Boolean bl3) {
            BigFSMWizard.this.enableButtons(bl, bl2, bl3);
        }

        public void wizardSkipCurrentStep() {
            BigFSMWizard.this._skipCurStep = true;
        }

        public void wizardUpdateAccessibleDescription(String string) {
            BigFSMWizard.this.updateAccessibleDescription(string);
        }

        public void wizardUpdateImage(Image image) {
            BigFSMWizard.this.updateImage(image);
        }

        public void wizardUpdateTitle(String string, Boolean bl) {
            FSMWizardPage fSMWizardPage = (FSMWizardPage)BigFSMWizard.this.getSelectedPage();
            if (fSMWizardPage != null) {
                fSMWizardPage.setPageTitle(string);
                fSMWizardPage.setLabel(string);
            }
        }

        public void wizardUpdateExpectedTransition(Object object) {
            BigFSMWizard.this.updateExpectedTransition(object);
        }

        public void wizardSetInitialFocus(Component component) {
            BigFSMWizard.this.updateInitialFocus(component);
        }

        public void nextPage() {
            BigFSMWizard.this.doNext();
        }

        public void previousPage() {
            BigFSMWizard.this.doPrevious();
        }
    }

    private class FSMWizardPage
    extends WizardPage {
        private FSMStateInfo _stateInfo;

        public FSMWizardPage(FSMStateInfo fSMStateInfo, Component component, String string, String string2) {
            super(component, string, string2);
            this._stateInfo = fSMStateInfo;
        }

        public FSMStateInfo getStateInfo() {
            return this._stateInfo;
        }
    }
}

