/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.credential;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.PasswordActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.credential.CredentialArb;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.Version;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class CredentialCreateAction
extends ActionDialog {
    public static final String NAME = "name";
    public static final String COMMENTS = "comments";
    public static final String SCHEMA = "schema";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String DATABASE_ROLE = "database_role";
    public static final String WINDOWS_DOMAIN = "windows_domain";
    public static final String NAME_VALID_MSG = "namevalidmsg";
    public static final String COMMENTS_VALID_MSG = "commentsvalidmsg";
    public static final String USERNAME_VALID_MSG = "usernamevalidmsg";
    public static final String PASSWORD_VALID_MSG = "passwordvalidmsg";
    public static final String DATABASE_ROLE_VALID_MSG = "database_rolevalidmsg";
    public static final String WINDOWS_DOMAIN_VALID_MSG = "windows_domainvalidmsg";
    boolean showOwner = false;
    String owner = null;
    String credential_name = null;
    String database_role = null;
    String username = null;
    String password = null;
    String comments = null;
    String windows_domain = null;
    ActionControl ownerCtl = null;
    ActionControl nameCtl = null;
    ActionControl commentsCtl = null;
    ActionControl userNameCtl = null;
    PasswordActionControl passwordCtl = null;
    ActionControl databaseRoleCtl = null;
    ActionControl windowsDomainCtl = null;

    @Override
    public String getTitle() {
        return CredentialArb.getString("CREDENTIALCREATEDIALOG_TITLE");
    }

    @Override
    protected String getQuery(Connection connection, String string) {
        String string2 = Utils.getQuery(CredentialCreateAction.class, connection, string);
        return string2;
    }

    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListCredentialsTask();
    }

    protected String getObjectType() {
        return "SCHCREDENTIAL";
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected List<ActionControl> createControls(Connection var1_1) {
        var2_2 = this.getOperation();
        try {
            var3_3 = this.getObjectName();
        }
        catch (Exception var5_4) {
            var3_3 = "null";
        }
        try {
            var4_7 = this.getDBObjectSchemaName();
            if (var4_7 == null) {
                var4_7 = this.getDBObject().getSchemaName();
            }
        }
        catch (Exception var5_5) {
            var4_7 = "null";
        }
        if (var2_2 != Operation.CREATE_NEW) {
            if (Connections.getInstance().lock(var1_1)) {
                var5_6 = null;
                try {
                    var6_8 = new HashMap<String, String>();
                    var6_8.put("OBJECT_NAME", var3_3);
                    var6_8.put("OBJECT_OWNER", var4_7);
                    var7_10 = DBUtil.getInstance((Connection)var1_1);
                    var7_10.setRaiseError(true);
                    var5_6 = var7_10.executeOracleQuery(this.getQuery(var1_1, "CREDENTIAL_DATA"), var6_8);
                    if (var5_6 == null || !(var8_11 = var5_6.getResultSet()).next()) ** GOTO lbl45
                    this.owner = var8_11.getString("OWNER");
                    this.credential_name = var8_11.getString("CREDENTIAL_NAME");
                    this.database_role = var8_11.getString("DATABASE_ROLE");
                    this.username = var8_11.getString("USERNAME");
                    this.windows_domain = var8_11.getString("WINDOWS_DOMAIN");
                    this.password = null;
                    this.comments = var8_11.getString("COMMENTS");
                }
                catch (Exception var6_9) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var6_9.getStackTrace()[0].toString(), var6_9);
                }
                finally {
                    if (var5_6 != null) {
                        var5_6.close();
                    }
                    Connections.getInstance().unlock(var1_1);
                }
            }
        } else {
            this.owner = var4_7;
        }
lbl45:
        // 5 sources

        switch (1.$SwitchMap$oracle$dbtools$util$credential$CredentialCreateAction$Operation[var2_2.ordinal()]) {
            case 1: {
                this.ownerCtl = new TextBoxActionControl("schema", CredentialArb.getString("CREDENTIALPANEL_SCHEMA_LABEL"), this.owner);
                this.ownerCtl.setEditable(false);
                this.nameCtl = new TextBoxActionControl("name", CredentialArb.getString("CREDENTIALPANEL_NAME_LABEL"), this.credential_name);
                this.nameCtl.setEditable(false);
                this.commentsCtl = new TextBoxActionControl("comments", CredentialArb.getString("CREDENTIALPANEL_DESC_LABEL"), this.comments);
                this.userNameCtl = new TextBoxActionControl("username", CredentialArb.getString("CREDENTIALPANEL_USERNAME_LABEL"), this.username);
                this.passwordCtl = new PasswordActionControl("password", CredentialArb.getString("CREDENTIALPANEL_PASSWORD_LABEL"));
                this.passwordCtl.set(this.password);
                this.databaseRoleCtl = new ComboBoxActionControl("database_role", CredentialArb.getString("CREDENTIALPANEL_DATABASE_ROLE_LABEL"), new String[]{null, "SYSDBA", "SYSOPER"}, this.database_role);
                this.windowsDomainCtl = new TextBoxActionControl("windows_domain", CredentialArb.getString("CREDENTIALPANEL_WINDOWS_DOMAIN_LABEL"), this.windows_domain);
                break;
            }
            case 2: {
                this.ownerCtl = new SqlComboBoxActionControl("schema", CredentialArb.getString("CREDENTIALPANEL_SCHEMA_LABEL"), var1_1, this.getQuery(var1_1, "getCredentialUsers"), null, this.owner);
                this.nameCtl = new TextBoxActionControl("name", CredentialArb.getString("CREDENTIALPANEL_NAME_LABEL"), "");
                this.commentsCtl = new TextBoxActionControl("comments", CredentialArb.getString("CREDENTIALPANEL_DESC_LABEL"), this.comments);
                this.userNameCtl = new TextBoxActionControl("username", CredentialArb.getString("CREDENTIALPANEL_USERNAME_LABEL"), this.username);
                this.passwordCtl = new PasswordActionControl("password", CredentialArb.getString("CREDENTIALPANEL_PASSWORD_LABEL"));
                this.passwordCtl.set(this.password);
                this.databaseRoleCtl = new ComboBoxActionControl("database_role", CredentialArb.getString("CREDENTIALPANEL_DATABASE_ROLE_LABEL"), new String[]{null, "SYSDBA", "SYSOPER"}, this.database_role);
                this.windowsDomainCtl = new TextBoxActionControl("windows_domain", CredentialArb.getString("CREDENTIALPANEL_WINDOWS_DOMAIN_LABEL"), this.windows_domain);
                break;
            }
            case 3: {
                this.ownerCtl = new SqlComboBoxActionControl("schema", CredentialArb.getString("CREDENTIALPANEL_SCHEMA_LABEL"), var1_1, this.getQuery(var1_1, "getCredentialUsers"), null, this.owner);
                this.nameCtl = new TextBoxActionControl("name", CredentialArb.getString("CREDENTIALPANEL_NAME_LABEL"), this.credential_name);
                this.commentsCtl = new TextBoxActionControl("comments", CredentialArb.getString("CREDENTIALPANEL_DESC_LABEL"), this.comments);
                this.userNameCtl = new TextBoxActionControl("username", CredentialArb.getString("CREDENTIALPANEL_USERNAME_LABEL"), this.username);
                this.passwordCtl = new PasswordActionControl("password", CredentialArb.getString("CREDENTIALPANEL_PASSWORD_LABEL"));
                this.passwordCtl.set(this.password);
                this.databaseRoleCtl = new ComboBoxActionControl("database_role", CredentialArb.getString("CREDENTIALPANEL_DATABASE_ROLE_LABEL"), new String[]{null, "SYSDBA", "SYSOPER"}, this.database_role);
                this.windowsDomainCtl = new TextBoxActionControl("windows_domain", CredentialArb.getString("CREDENTIALPANEL_WINDOWS_DOMAIN_LABEL"), this.windows_domain);
            }
        }
        var5_6 = new ArrayList();
        if (this.showOwner) {
            var5_6.add(this.ownerCtl);
        } else {
            this.ownerCtl = new TextBoxActionControl("schema", CredentialArb.getString("CREDENTIALPANEL_NAME_LABEL"), this.owner);
        }
        var5_6.add(this.nameCtl);
        var5_6.add(this.commentsCtl);
        var5_6.add(this.userNameCtl);
        var5_6.add(this.passwordCtl);
        var5_6.add(this.databaseRoleCtl);
        var5_6.add(this.windowsDomainCtl);
        return var5_6;
    }

    @Override
    protected String getScript(ActionDialog.Values values) {
        Operation operation = this.getOperation();
        String string = this.ownerCtl.getValue().get();
        String string2 = values.get(NAME);
        String string3 = values.get(COMMENTS);
        String string4 = values.get(USERNAME);
        String string5 = values.get(PASSWORD);
        String string6 = values.get(DATABASE_ROLE);
        String string7 = values.get(WINDOWS_DOMAIN);
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string6 != null && string6.length() == 0) {
            string6 = null;
        }
        if (string7 != null && string7.length() == 0) {
            string7 = null;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(SCHEMA, string);
        treeMap.put(NAME, string2);
        treeMap.put(USERNAME, string4);
        treeMap.put(PASSWORD, string5);
        treeMap.put(DATABASE_ROLE, string6);
        treeMap.put(WINDOWS_DOMAIN, string7);
        treeMap.put(COMMENTS, string3);
        TreeMap<String, Boolean> treeMap2 = new TreeMap<String, Boolean>();
        treeMap2.put(SCHEMA, CredentialCreateAction.equals(string, this.owner) == false);
        treeMap2.put(NAME, CredentialCreateAction.equals(string2, this.credential_name) == false);
        treeMap2.put(USERNAME, CredentialCreateAction.equals(string4, this.username) == false);
        treeMap2.put(PASSWORD, CredentialCreateAction.equals(string5, this.password) == false);
        treeMap2.put(WINDOWS_DOMAIN, CredentialCreateAction.equals(string7, this.windows_domain) == false);
        treeMap2.put(DATABASE_ROLE, CredentialCreateAction.equals(string6, this.database_role) == false);
        treeMap2.put(COMMENTS, CredentialCreateAction.equals(string3, this.comments) == false);
        TreeMap<String, Object> treeMap3 = new TreeMap<String, Object>();
        treeMap3.put("model", treeMap);
        treeMap3.put("changes", treeMap2);
        String string8 = null;
        switch (operation) {
            case UPDATE: {
                string8 = this.generate("CREDENTIAL_UPDATE", treeMap3);
                break;
            }
            case CREATE_LIKE: {
                string8 = this.generate("CREDENTIAL_CREATE_LIKE", treeMap3);
                break;
            }
            case CREATE_NEW: {
                string8 = this.generate("CREDENTIAL_CREATE", treeMap3);
            }
        }
        return string8;
    }

    private String generate(String string, Map<String, Object> map) {
        String string2 = this.getDBObject().getDBVersion();
        String string3 = this.getQuery(this.getDBObject().getConnection(), string);
        StringTemplate stringTemplate = new StringTemplate(string3, AngleBracketTemplateLexer.class);
        stringTemplate.reset();
        if (map != null) {
            stringTemplate.setAttributes(map);
        }
        String string4 = stringTemplate.toDebugString();
        string4 = stringTemplate.toStructureString();
        string4 = stringTemplate.toString();
        if (string2.startsWith("10")) {
            string4 = string4.replaceAll("\r\n", "\n");
        }
        return string4;
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    @Override
    protected boolean isCloseOnError() {
        return false;
    }

    @Override
    public boolean isEnabled(Context context) {
        Version version = new Version("11");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    @Override
    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_newCredentialDialog_html");
    }

    private class ListCredentialsTask
    extends DatabaseQueryTask<List<String>> {
        public ListCredentialsTask() {
            super("ListCredentialsTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        @Override
        public String getConnectionName() {
            return CredentialCreateAction.this.getDBObject().getConnectionName();
        }

        @Override
        public String getQuery() {
            String string = CredentialCreateAction.this.getQuery(CredentialCreateAction.this.getDBObject().getConnection(), "getCredentialList");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = CredentialCreateAction.this.getDBObject().getConnection();
            DBUtil.getConnectionResolver().lock(connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                ResultSetWrapper resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string = resultSet.getString("OWNER") + "." + resultSet.getString("CREDENTIAL_NAME");
                        vector.add(string);
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    resultSetWrapper.close();
                }
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
            return vector;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        UPDATE;

    }
}

