/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Component;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.dialogs.conn.ConnectionPrompt;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;

public class RunPrivilegedScript {
    public static Connection getConnection(String string, String string2, String string3) {
        Properties properties = (Properties)Connections.getInstance().getConnectionInfo(string).clone();
        properties.put("user", string2);
        properties.remove("password");
        properties.put("role", string3);
        properties.put("SavePassword", "false");
        properties.remove("ConnName");
        properties.remove("UnsharedWorksheetOriginalConnectionName");
        properties.remove("IS_PROXY");
        properties.remove("PROXY_USER_PASSWORD");
        properties.remove("PROXY_TYPE");
        properties.remove("PROXY_USER_NAME");
        properties.put("OS_AUTHENTICATION", "false");
        properties.put("KERBEROS_AUTHENTICATION", "false");
        properties.put("NoPasswordConnection", "TRUE");
        DatabaseProvider databaseProvider = new DatabaseProvider(properties);
        Connection connection = null;
        try {
            connection = databaseProvider.getConnection();
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Throwable)sQLException);
        }
        ((ConnectionPrompt)DatabaseProviderHelper.getPasswordPrompter()).uncache(properties);
        return connection;
    }

    private static void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Throwable)sQLException);
        }
    }

    public static void run(InputStream inputStream, String string, String string2, String string3) {
        Connection connection = RunPrivilegedScript.getConnection(string, string2, string3);
        ScriptUtils.runInDialog(Messages.getString("RunPrivilegedScript.1"), inputStream, connection, true);
    }

    public static void run(String string, String string2, String string3, String string4) {
        Connection connection = RunPrivilegedScript.getConnection(string2, string3, string4);
        ScriptExecutor scriptExecutor = new ScriptExecutor(string, connection);
        scriptExecutor.run();
        RunPrivilegedScript.close(connection);
    }

    public static void run(String string, Connection connection) {
        ScriptExecutor scriptExecutor = new ScriptExecutor(string, connection);
        scriptExecutor.run();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean runWithPreview(String[] stringArray, String string, String string2, String string3) throws SQLException {
        Connection connection;
        block12: {
            Statement statement2;
            BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
            basicEditorPane.setDocument((Document)new BasicDocument("foo.plsql"));
            StringBuilder stringBuilder = new StringBuilder();
            for (String string4 : stringArray) {
                stringBuilder.append(string4).append(";").append(System.getProperty("line.separator"));
            }
            basicEditorPane.setText(stringBuilder.toString());
            basicEditorPane.setEditable(true);
            JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane, 22, 32);
            int n = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)jScrollPane, (String)Messages.getString("RunPrivilegedScript.5"), (String)"f1_confirmrunningsql_html") ? 1 : 0;
            if (n == 0) {
                return false;
            }
            connection = RunPrivilegedScript.getConnection(string, string2, string3);
            Statement statement = null;
            try {
                statement2 = connection.createStatement();
                for (String string5 : stringArray) {
                    statement2.execute(string5);
                }
                if (statement2 == null) break block12;
            }
            catch (SQLException sQLException) {
                try {
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException2) {
                            // empty catch block
                        }
                    }
                    RunPrivilegedScript.close(connection);
                    throw throwable;
                }
            }
            try {
                statement2.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        RunPrivilegedScript.close(connection);
        RunPrivilegedScript.close(connection);
        return true;
    }

    public static boolean runWithPreview(String[] stringArray, Connection connection) throws SQLException {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setDocument((Document)new BasicDocument("foo.plsql"));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(";").append(System.getProperty("line.separator"));
        }
        basicEditorPane.setText(stringBuilder.toString());
        basicEditorPane.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane, 22, 32);
        int n = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)jScrollPane, (String)Messages.getString("RunPrivilegedScript.5"), (String)"f1_confirmrunningsql_html") ? 1 : 0;
        if (n != 0) {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                for (String string : stringArray) {
                    statement.execute(string);
                }
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return true;
        }
        return false;
    }
}

