/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.controls.UIDBAccessSafe;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.ide.Ide;
import oracle.ide.dialogs.OptionSelectionDialog;
import oracle.ide.help.HelpSystem;

public class RaptorDbDisconnectListener
implements ConnectionDisconnectListener {
    public static final String OPTION_COMMIT = ConnectionArb.getString((String)"RDEP_COMMIT");
    public static final String OPTION_ROLLBACK = ConnectionArb.getString((String)"RDEP_ROLLBACK");
    public static final String OPTION_CANCEL_DISCONNECT = ConnectionArb.getString((String)"OPTION_CANCEL_DISCONNECT");
    public static final String[] OPTIONS = new String[]{OPTION_COMMIT, OPTION_ROLLBACK, OPTION_CANCEL_DISCONNECT};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @UIDBAccessSafe
    public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
        boolean bl;
        block14: {
            String string = connectionDetails.getQualifiedConnectionName();
            Connection connection2 = null;
            Connections connections = Connections.getInstance();
            Connection connection = connectionDetails.getConnection();
            if (connection == null) return;
            if (!connections.lock(connection, true)) {
                throw new DisconnectVetoException(connectionDetails, "Could not lock connection");
            }
            connection2 = connection;
            try {
                if (connection.isClosed()) {
                    if (connection2 == null) return;
                    connections.unlock(connection2);
                    return;
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "An attempt to determine pending transaction for the just closed connection failed.");
                if (connection2 == null) return;
                connections.unlock(connection2);
                return;
            }
            if (!RaptorExtensionConstants.isStandAlone()) return;
            if (!connections.isOracle(connection)) return;
            if (!DBUtil.isOracleConnectionAlive((Connection)connection)) return;
            if (!DBUtil.hasTransaction((Connection)connection)) return;
            bl = false;
            OptionSelectionDialog optionSelectionDialog = new OptionSelectionDialog();
            HelpSystem.getHelpSystem().registerTopic((JComponent)optionSelectionDialog, "f1_connection_has_pending_changes_html");
            boolean bl2 = optionSelectionDialog.showDialog((Component)Ide.getMainWindow(), MessageFormat.format(ConnectionArb.getString((String)"CONNECTION_HAS_TRANSACTIONS_MSG"), Connections.getDisplayName(string)), ConnectionArb.getString((String)"SELECT_ON_DISCONNECT_OPTIONS_MSG"), (Object[])OPTIONS, "f1_connection_has_pending_changes_html");
            if (bl2) {
                String string2 = optionSelectionDialog.getSelectedOption().toString();
                try {
                    if (string2.equals(OPTION_COMMIT)) {
                        connection.commit();
                        bl = true;
                        break block14;
                    }
                    if (string2.equals(OPTION_ROLLBACK)) {
                        connection.rollback();
                        bl = true;
                    }
                }
                catch (SQLException sQLException) {
                    SQLErrorDialog.showErrorDialog((String)string, null, (String)"Transaction Error", (SQLException)sQLException);
                }
            }
        }
        if (bl) return;
        throw new DisconnectVetoException(connectionDetails, null);
    }

    @Override
    public void connectionDisconnected(ConnectionDetails connectionDetails) {
    }
}

