/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.util.Resource;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;
import oracle.ide.util.IdeUtil;

public class FileUtils {
    public static List<URL> getFilesInPackage(String string, String string2) {
        return FileUtils.getFilesInPackage(string, string2, true);
    }

    public static List<URL> getFilesInPackage(String string, String string2, boolean bl) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URL[] uRLArray = Resource.getPath((String)(string = string.replaceAll("\\.", "\\/")));
        if (uRLArray != null) {
            PackageFilter packageFilter = new PackageFilter(bl, string2);
            for (URL uRL : uRLArray) {
                for (URL uRL2 : URLFileSystem.list((URL)uRL, (URLFilenameFilter)packageFilter)) {
                    if (!bl) {
                        String string3 = URLFileSystem.getFileName((URL)uRL2);
                        packageFilter.addName(string3);
                    }
                    arrayList.add(uRL2);
                }
            }
        }
        return arrayList;
    }

    public static Writer getEncodedFileWriter(String string, String string2) throws FileNotFoundException {
        OutputStreamWriter outputStreamWriter = null;
        if (string2 == null) {
            string2 = IdeUtil.getIdeEncoding();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        if (string2 != null) {
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            }
        }
        return outputStreamWriter;
    }

    public static String getLineTerminator() {
        String string = System.getProperty("line.separator");
        if (Ide.isRunning()) {
            IdeSettings ideSettings = Ide.getSettings();
            EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
            int n = environOptions.getLineTerminator();
            if (n == 1) {
                string = "\r\n";
            } else if (n == 3) {
                string = "\r";
            } else if (n == 2) {
                string = "\n";
            }
        }
        return string;
    }

    private static final class PackageFilter
    implements URLFilenameFilter {
        private final String m_ext;
        private boolean m_allowDuplicates;
        private Set<String> m_names;

        PackageFilter(boolean bl, String string) {
            this.m_allowDuplicates = bl;
            if (!bl) {
                this.m_names = new HashSet<String>();
            }
            this.m_ext = string;
        }

        public boolean accept(URL uRL, String string) {
            return string.endsWith(this.m_ext) && (this.m_allowDuplicates || !this.m_names.contains(string));
        }

        void addName(String string) {
            if (!this.m_allowDuplicates) {
                this.m_names.add(string);
            }
        }
    }
}

