/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;

public class SelectionActionControl
extends ActionControl
implements LayoutControl {
    private int _capabilities;
    private Shuttle _shuttle;
    private JList _lstFrom;
    private JList _lstTo;
    private DefaultListModel _mdlFrom;
    private DefaultListModel _mdlTo;
    private ListPicker _pckFrom;
    private ListPicker _pckTo;
    private JTextField _newValueField;
    private JButton _addNewButton;
    private JPanel _ui;
    private String _title;
    private List<String> _initialItems;
    public static final int AUGMENTABLE_LIST = 1;
    public static final int ORDERABLE_LIST = 2;
    public static final String SELECTED_ITEMS = "SELECTED_ITEMS";
    public static final String HIGHLIGHTED_ITEMS = "HIGHLIGHTED_ITEMS";
    public static final String ADDED_ITEMS = "ADDED_ITEMS";
    public static final String REMOVED_ITEMS = "REMOVED_ITEMS";

    public SelectionActionControl(String string, String string2, List<String> list) {
        this(string, string2, 0, list, null);
    }

    public SelectionActionControl(String string, String string2, List<String> list, List<String> list2) {
        this(string, string2, 0, list, list2);
    }

    public SelectionActionControl(String string, String string2, int n, List<String> list) {
        this(string, string2, n, list, null);
    }

    public SelectionActionControl(String string, String string2, int n, List<String> list, List<String> list2) {
        super(string, null, true);
        this._title = string2;
        this._capabilities = n;
        this._ui = this.createUI(list, list2);
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        value.addList(SELECTED_ITEMS, this.getSelectedItems());
        value.addList(HIGHLIGHTED_ITEMS, this.getHighlightedItems());
        value.addList(ADDED_ITEMS, this.getAddedItems());
        value.addList(REMOVED_ITEMS, this.getRemovedItems());
        return value;
    }

    @Override
    public Component getUI() {
        return this._ui;
    }

    @Override
    public void setEditable(boolean bl) {
        this.enableUI(bl);
    }

    @Override
    public void enableUI(boolean bl) {
        this._shuttle.setEnabled(bl);
        this._lstFrom.setEnabled(bl);
        this._lstTo.setEnabled(bl);
        if (this._newValueField != null) {
            this._newValueField.setEditable(bl);
        }
        if (this._addNewButton != null) {
            this._addNewButton.setEnabled(bl);
        }
    }

    private JPanel createUI(List<String> list, List<String> list2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (this._title != null) {
            jPanel.setBorder(new TitledBorder(this._title));
        }
        int n = 0;
        if (this.hasCapability(1)) {
            this._newValueField = new JTextField();
            this._newValueField.setName("newValueField");
            this._addNewButton = new JButton(UiResources.getString("ADD_BUTTON_LABEL"));
            this._addNewButton.setName("addNewButton");
            this._addNewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = SelectionActionControl.this._newValueField.getText();
                    if (string != null && !string.equals("") && !SelectionActionControl.this._mdlTo.contains(string)) {
                        SelectionActionControl.this._mdlTo.addElement(string);
                        SelectionActionControl.this._mdlFrom.removeElement(string);
                    }
                }
            });
            jPanel.add((Component)this._newValueField, LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
            jPanel.add((Component)this._addNewButton, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_END_CONTROL2BUTTON));
            ++n;
        }
        this._shuttle = new Shuttle();
        this._shuttle.setName("shuttle");
        if (list2 == null) {
            this._shuttle.add((Component)new JLabel(), (Object)"FromHeader");
            this._shuttle.add((Component)new JLabel(), (Object)"ToHeader");
        }
        this._lstTo = new JList();
        this._lstTo.setName("lstTo");
        this._mdlTo = new DefaultListModel();
        this._lstTo.setModel(this._mdlTo);
        this._pckTo = this.hasCapability(2) ? new ReorderableListPicker(this._lstTo) : new ListPicker(this._lstTo);
        this._shuttle.setToPicker((ItemPicker)this._pckTo);
        if (list2 != null) {
            this._lstFrom = new JList();
            this._lstFrom.setName("lstFrom");
            this._mdlFrom = new DefaultListModel();
            this._lstFrom.setModel(this._mdlFrom);
            this._pckFrom = new ListPicker(this._lstFrom);
            this._shuttle.setFromPicker((ItemPicker)this._pckFrom);
        } else {
            this._shuttle.setButtonsShown(0);
        }
        this._shuttle.setEnabled(true);
        this._shuttle.validate();
        jPanel.add((Component)this._shuttle, LayoutControl.GBC.gbc(0, n, 2, 1, n == 0 ? LayoutControl.GBC.Inset.CENTER_FULL : LayoutControl.GBC.Inset.PAGE_END_FULL, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        this.resetListContents(list, list2);
        return jPanel;
    }

    public void resetListContents(List<String> list) {
        this.resetListContents(list, null);
    }

    public void resetListContents(List<String> list, List<String> list2) {
        this._mdlTo.removeAllElements();
        for (String string : list) {
            this._mdlTo.addElement(string);
        }
        if (list2 != null && this._mdlFrom != null) {
            this._mdlFrom.removeAllElements();
            for (String string : list2) {
                this._mdlFrom.addElement(string);
            }
        }
        this._initialItems = list;
    }

    private List<String> getSelectedItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._mdlTo.size(); ++i) {
            arrayList.add((String)this._mdlTo.get(i));
        }
        return arrayList;
    }

    private List<String> getHighlightedItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = this._lstTo.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add((String)objectArray[i]);
        }
        return arrayList;
    }

    private List<String> getAddedItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>(this._initialItems);
        List<String> list = this.getSelectedItems();
        for (String string : list) {
            if (hashSet.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private List<String> getRemovedItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>(this.getSelectedItems());
        for (String string : this._initialItems) {
            if (hashSet.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean hasCapability(int n) {
        return (n & this._capabilities) == n;
    }
}

