/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import oracle.dbtools.raptor.ui.actions.ActionControl;

public class ListActionControl
extends ActionControl {
    private JList _list;
    private JScrollPane _listScroll;
    private String[] _defaultValue = null;
    private int _listSize = -1;

    public ListActionControl(String string, String string2, String[] stringArray) {
        this(string, string2, stringArray, null);
    }

    public ListActionControl(String string, String string2, String[] stringArray, String[] stringArray2) {
        this(string, string2, stringArray, stringArray2, 5);
    }

    public ListActionControl(String string, String string2, String[] stringArray, String[] stringArray2, int n) {
        super(string, string2);
        this._defaultValue = stringArray2;
        this._listSize = stringArray.length;
        this._list = new JList<String>(stringArray);
        this._list.setVisibleRowCount(n);
        this._listScroll = new JScrollPane(this._list);
        this._list.setName(string);
        this.reset();
        ListSelectionModel listSelectionModel = this._list.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectionHandler());
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        Object[] objectArray = this._list.getSelectedValues();
        List<Object> list = Arrays.asList(objectArray);
        value.addList("selected", objectArray != null ? list : null);
        return value;
    }

    @Override
    public Component getUI() {
        return this._listScroll;
    }

    public void set(String[] stringArray) {
        for (String string : stringArray) {
            this._list.setSelectedValue(string, true);
        }
    }

    @Override
    public void reset() {
        int[] nArray = new int[this._listSize];
        int n = 0;
        if (this._defaultValue != null) {
            for (String string : this._defaultValue) {
                int n2;
                nArray[n] = n2 = this._list.getNextMatch(string, 0, Position.Bias.Forward);
                ++n;
            }
            while (n < this._listSize) {
                nArray[n] = -1;
                ++n;
            }
            this._list.setSelectedIndices(nArray);
        } else if (this._listSize > 0) {
            this._list.setSelectedIndex(0);
        }
    }

    public int getNumItems() {
        return this._listSize;
    }

    public void reset(String[] stringArray) {
        int[] nArray = new int[this._listSize];
        int n = 0;
        this._list.clearSelection();
        if (stringArray != null) {
            for (String string : stringArray) {
                int n2;
                nArray[n] = n2 = this._list.getNextMatch(string, 0, Position.Bias.Forward);
                ++n;
            }
            while (n < this._listSize) {
                nArray[n] = -1;
                ++n;
            }
            this._list.setSelectedIndices(nArray);
        } else if (this._listSize > 0) {
            this._list.setSelectedIndex(0);
        }
    }

    @Override
    public void setEditable(boolean bl) {
        this._list.setEnabled(bl);
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ListActionControl.this.firePropertyChangeListeners();
            }
        }
    }
}

