/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.actions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.swing.text.Document;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;

public class SQLScriptProcessor
implements ScriptProcessor {
    private boolean _cancelled = false;

    @Override
    public BasicEditorPane getEditorPane() {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setDocument((Document)new BasicDocument("foo.plsql"));
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin();
        basicEditorPane.installPlugin((EditorPlugin)lineGutterPlugin);
        basicEditorPane.installPlugin((EditorPlugin)highlightEditorPlugin);
        return basicEditorPane;
    }

    @Override
    public String getScriptEditorTabName() {
        return UiResources.getString("SQL_TAB");
    }

    @Override
    public String getSuccessMessage() {
        return UiResources.getString("SQL_SUCCESS");
    }

    @Override
    public String getFailureMessage(Exception exception) {
        String string = UiResources.getString("SQL_FAILURE");
        String string2 = exception.getLocalizedMessage();
        if (string2 != null) {
            string = string + "\n- " + string2;
        }
        return string;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }

    @Override
    public void cancel() {
        if (this.isCancellable()) {
            this._cancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processScript(ScriptProcessorContext scriptProcessorContext) throws Exception {
        Connection connection = scriptProcessorContext.getConnection();
        ScriptParser scriptParser = new ScriptParser(scriptProcessorContext.getScript(), connection);
        scriptParser.parse();
        ISQLCommand[] iSQLCommandArray = scriptParser.getSqlStatements();
        if (Connections.getInstance().lock(connection)) {
            try {
                for (ISQLCommand iSQLCommand : iSQLCommandArray) {
                    if (this._cancelled) {
                        break;
                    }
                    String string = iSQLCommand.getSql().replace("\r", " ");
                    PreparedStatement preparedStatement = connection.prepareStatement(string);
                    try {
                        preparedStatement.execute();
                    }
                    finally {
                        preparedStatement.close();
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw sQLException;
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }
}

