/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.actions;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ActionControl {
    private String _name;
    private String _prompt;
    private boolean _fillVertical;
    private boolean _springVertical;
    private PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    protected ActionControl(String string, String string2) {
        this(string, string2, false);
    }

    protected ActionControl(String string, String string2, boolean bl) {
        this._name = string;
        this._prompt = string2;
        this._fillVertical = bl;
    }

    public abstract Value getValue();

    public abstract Component getUI();

    public void reset() {
    }

    public List<ActionControl> getChildControls() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Value> getNamedValue(Map<String, Value> map, StringBuilder stringBuilder, boolean bl) {
        Map<String, Value> map2 = map;
        int n = stringBuilder.length();
        try {
            String string = this.getName();
            if (string != null) {
                if (n > 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(string);
                map2.put(stringBuilder.toString(), this.getValue());
            }
            if (bl) {
                map2 = this.getChildrenNamedValues(map, stringBuilder, bl);
            }
        }
        finally {
            stringBuilder.setLength(n);
        }
        return map2;
    }

    protected Map<String, Value> getChildrenNamedValues(Map<String, Value> map, StringBuilder stringBuilder, boolean bl) {
        Map<String, Value> map2 = map;
        List<ActionControl> list = this.getChildControls();
        if (list != null) {
            for (ActionControl actionControl : list) {
                map2 = actionControl.getNamedValue(map, stringBuilder, bl);
            }
        }
        return map2;
    }

    public abstract void setEditable(boolean var1);

    public void enableUI(boolean bl) {
        this.getUI().setEnabled(bl);
    }

    public boolean isUIEnabled() {
        return this.getUI().isEnabled();
    }

    public String getName() {
        return this._name;
    }

    public String getPrompt() {
        return this._prompt;
    }

    public boolean fillVertical() {
        return this._fillVertical;
    }

    public void setFillVertical(boolean bl) {
        this._fillVertical = bl;
    }

    protected void firePropertyChangeListeners() {
        this._changeSupport.firePropertyChange("", null, this.getValue());
    }

    public void firePropertyChangeListeners(String string) {
        System.out.println("FirePropertyChange.property=" + string);
        this._changeSupport.firePropertyChange(string, null, this.getValue());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean springVertical() {
        return this._springVertical;
    }

    public void setSpringVertical(boolean bl) {
        this._springVertical = bl;
    }

    public static class Value {
        private String _value = null;
        private final HashMap<String, String> _valueMap = new HashMap();
        private final HashMap<String, List<String>> _listMap = new HashMap();

        public void set(String string) {
            this._value = string;
        }

        public String get() {
            return this._value;
        }

        public boolean isNull() {
            return this._value == null && this._valueMap.size() == 0 && this._listMap.size() == 0;
        }

        public Set<String> getNames() {
            return this._valueMap.keySet();
        }

        public void add(String string, String string2) {
            this._valueMap.put(string, string2);
        }

        public void remove(String string) {
            this._valueMap.remove(string);
        }

        public String get(String string) {
            return this._valueMap.get(string);
        }

        public Set<String> getListNames() {
            return this._listMap.keySet();
        }

        public void addList(String string, List<String> list) {
            this._listMap.put(string, list);
        }

        public void removeList(String string) {
            this._listMap.remove(string);
        }

        public List<String> getList(String string) {
            return this._listMap.get(string);
        }
    }
}

