/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class KeyboardFocusLogger
implements FocusListener,
PropertyChangeListener {
    private static Border DEBUG_BORDER = BorderFactory.createLineBorder(Color.RED);
    private static KeyboardFocusLogger _keyboardFocusLogger;
    private KeyboardFocusManager keyboardFocusManager;
    private boolean decorateBorder = true;
    private static final String FOCUS_OWNER = "focusOwner";
    private static Logger LOGGER;
    private Map<JComponent, Border> originalBorderMap = new HashMap<JComponent, Border>();

    private KeyboardFocusLogger() {
    }

    public static KeyboardFocusLogger getInstance() {
        if (null == _keyboardFocusLogger) {
            _keyboardFocusLogger = new KeyboardFocusLogger();
        }
        return _keyboardFocusLogger;
    }

    public static void start() {
        KeyboardFocusLogger.start(true);
    }

    public static void start(boolean bl) {
        KeyboardFocusLogger.getInstance().startImpl(bl);
    }

    private void startImpl(boolean bl) {
        this.decorateBorder = bl;
        this.setKeyboardFocusManager(KeyboardFocusManager.getCurrentKeyboardFocusManager());
    }

    private void setKeyboardFocusManager(KeyboardFocusManager keyboardFocusManager) {
        this.keyboardFocusManager = keyboardFocusManager;
        this.keyboardFocusManager.addPropertyChangeListener(FOCUS_OWNER, this);
    }

    public static void stop() {
        KeyboardFocusLogger.getInstance().stopImpl();
    }

    private void stopImpl() {
        if (this.keyboardFocusManager != null) {
            this.keyboardFocusManager.removePropertyChangeListener(FOCUS_OWNER, _keyboardFocusLogger);
            this.keyboardFocusManager = null;
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (null == this.keyboardFocusManager) {
            this.log(focusEvent);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (null == this.keyboardFocusManager) {
            this.log(focusEvent);
        }
    }

    public boolean setDecorateBorder(boolean bl) {
        boolean bl2 = this.decorateBorder;
        this.decorateBorder = bl;
        return bl2;
    }

    public void watch(JComponent jComponent) {
        this.ignore(jComponent);
        jComponent.addFocusListener(this);
    }

    public void ignore(JComponent jComponent) {
        jComponent.removeFocusListener(this);
    }

    public void watchAll(JComponent jComponent) {
        this.watch(jComponent);
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            this.watchAll((JComponent)component);
        }
    }

    public void ignoreAll(JComponent jComponent) {
        this.ignore(jComponent);
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            this.ignoreAll((JComponent)component);
        }
    }

    protected void log(FocusEvent focusEvent) {
        LOGGER.log(Level.FINER, focusEvent.toString());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (FOCUS_OWNER.equals(propertyChangeEvent.getPropertyName())) {
            this.log(propertyChangeEvent);
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (this.decorateBorder) {
                JComponent jComponent;
                if (object instanceof JComponent) {
                    jComponent = (JComponent)object;
                    this.resetBorder(jComponent);
                }
                if (object2 instanceof JComponent) {
                    jComponent = (JComponent)object2;
                    this.setBorder(jComponent);
                }
            }
        }
    }

    private void resetBorder(JComponent jComponent) {
        if (DEBUG_BORDER == jComponent.getBorder()) {
            Border border = this.originalBorderMap.remove(jComponent);
            jComponent.setBorder(border);
        }
    }

    private void setBorder(JComponent jComponent) {
        Border border = jComponent.getBorder();
        if (border != DEBUG_BORDER) {
            this.originalBorderMap.put(jComponent, border);
            jComponent.setBorder(DEBUG_BORDER);
        }
    }

    protected void log(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        String string2 = String.format("%1$10s: %2$s\n%3$10s: %4$s", string, object2, "old", object);
        LOGGER.log(Level.INFO, string2);
    }

    static {
        LOGGER = Logger.getLogger(KeyboardFocusLogger.class.getName());
    }
}

