/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.raptor.runner.GridData;

class Type {
    private String _typeName;
    private String _declName;
    private boolean _outputSupported;
    private static final Set CHARACTER_TYPES = new HashSet<String>(Arrays.asList("CHAR", "NCHAR", "VARCHAR2", "NVARCHAR2"));

    Type(String string) {
        this(string, true);
    }

    Type(String string, boolean bl) {
        this(string, string, bl);
    }

    Type(String string, String string2, boolean bl) {
        this._typeName = string;
        this._declName = string2;
        this._outputSupported = bl;
    }

    String getTypeName() {
        return this._typeName;
    }

    void setTypeName(String string) {
        this._typeName = string;
    }

    String getDeclaredName() {
        return this._declName;
    }

    boolean isOutputSupported() {
        return this._outputSupported;
    }

    boolean isCharType() {
        return this._outputSupported && CHARACTER_TYPES.contains(this._typeName);
    }

    Integer getSqlType() {
        if ("REF CURSOR".equals(this._declName)) {
            return -10;
        }
        if ("NUMBER".equals(this._declName)) {
            return 2;
        }
        if ("DATE".equals(this._declName)) {
            return 91;
        }
        if ("TIMESTAMP".equals(this._declName)) {
            return 93;
        }
        if ("CLOB".equals(this._declName)) {
            return 2005;
        }
        if (this._declName.contains("CHAR")) {
            return 12;
        }
        return null;
    }

    GridData extractValue(CallableStatement callableStatement, int n) throws SQLException {
        GridData gridData = new GridData();
        if ("REF CURSOR".equals(this._declName)) {
            int n2;
            ResultSet resultSet = (ResultSet)callableStatement.getObject(n);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            gridData.header = new String[resultSetMetaData.getColumnCount()];
            for (n2 = 0; n2 < gridData.header.length; ++n2) {
                gridData.header[n2] = resultSetMetaData.getColumnName(n2 + 1);
            }
            gridData.data = new ArrayList<Object[]>();
            for (n2 = 0; n2 < 10000 && resultSet.next(); ++n2) {
                Object[] objectArray = new Object[gridData.header.length];
                gridData.data.add(objectArray);
                for (int i = 0; i < gridData.header.length; ++i) {
                    objectArray[i] = resultSet.getObject(i + 1);
                }
            }
        } else {
            gridData.header = new String[1];
            gridData.header[0] = "";
            gridData.data = new ArrayList<Object[]>();
            Object[] objectArray = new Object[1];
            gridData.data.add(objectArray);
            if ("CLOB".equals(this._declName)) {
                Clob clob = callableStatement.getClob(n);
                long l = clob.length();
                if (100L < l) {
                    l = 100L;
                }
                String string = clob.getSubString(1L, (int)l);
                if (l == 100L) {
                    string = string + "...";
                }
                objectArray[0] = string;
            } else {
                objectArray[0] = callableStatement.getObject(n);
            }
        }
        return gridData;
    }
}

