/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import oracle.dbtools.raptor.runner.Mode;
import oracle.dbtools.raptor.runner.Parameter;
import oracle.dbtools.raptor.runner.Type;
import oracle.dbtools.util.Service;
import oracle.ide.util.FastStringBuffer;

class ParamImpl
implements Parameter {
    private String _name;
    private String _varName;
    private Type _type;
    private Mode _mode;
    private boolean _default;
    private boolean _return;
    boolean isOutputBound = false;

    ParamImpl(Type type) {
        this._name = "<Return Value>";
        this._varName = "v_Return";
        this._type = type;
        this._mode = Mode.OUT;
        this._default = false;
        this._return = true;
    }

    ParamImpl(String string, Type type, Mode mode, boolean bl) {
        this._name = string;
        this._varName = string;
        this._type = type;
        this._mode = mode;
        this._default = bl;
        this._return = false;
    }

    @Override
    public boolean isReturn() {
        return this._return;
    }

    @Override
    public boolean isDefaultProvided() {
        return this._default;
    }

    @Override
    public String getVarName() {
        return this._varName;
    }

    @Override
    public Type getType() {
        return this._type;
    }

    @Override
    public String getParamName() {
        return this._name;
    }

    @Override
    public Mode getMode() {
        return this._mode;
    }

    @Override
    public void generateDeclaration(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append("  ");
        fastStringBuffer.append(this._varName);
        fastStringBuffer.append(" ");
        fastStringBuffer.append(this._type.getTypeName());
        fastStringBuffer.append(";\n");
    }

    @Override
    public void generateInitialization(FastStringBuffer fastStringBuffer) {
        if (this._type.isOutputSupported()) {
            fastStringBuffer.append("  ");
        } else {
            fastStringBuffer.append("  ");
            fastStringBuffer.append("-- Modify the code to initialize the variable\n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("-- ");
        }
        fastStringBuffer.append(this._varName);
        fastStringBuffer.append(" := NULL;\n");
    }

    @Override
    public void generateCallReference(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append("  ");
        fastStringBuffer.append(Service.addDoubleQuote((String)this._name));
        fastStringBuffer.append(" => ");
        fastStringBuffer.append(this._varName);
    }

    @Override
    public void generateResultOutput(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append("  ");
        fastStringBuffer.append("/* Legacy output: \n");
        if ("BOOLEAN".equals(this._type.getTypeName())) {
            fastStringBuffer.append("IF (").append(this._varName).append(") THEN \n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("DBMS_OUTPUT.PUT_LINE('");
            fastStringBuffer.append(this._varName);
            fastStringBuffer.append(" = ' || ");
            fastStringBuffer.append("'TRUE');\n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("ELSE\n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("DBMS_OUTPUT.PUT_LINE('");
            fastStringBuffer.append(this._varName);
            fastStringBuffer.append(" = ' || ");
            fastStringBuffer.append("'FALSE');\n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("END IF;\n");
        } else {
            fastStringBuffer.append("DBMS_OUTPUT.PUT_LINE('");
            fastStringBuffer.append(this._varName);
            fastStringBuffer.append(" = ' || ");
            fastStringBuffer.append(this._varName);
            fastStringBuffer.append(");\n");
        }
        fastStringBuffer.append("*/ \n");
        fastStringBuffer.append("  ");
        if (this._type.getSqlType() == null) {
            fastStringBuffer.append("--");
        }
        fastStringBuffer.append(":");
        fastStringBuffer.append(this._varName);
        fastStringBuffer.append(" := ");
        fastStringBuffer.append(this._varName);
        fastStringBuffer.append(";");
        if ("REF CURSOR".equals(this._type.getDeclaredName())) {
            fastStringBuffer.append(" --<-- Cursor");
        }
        fastStringBuffer.append("\n");
    }

    @Override
    public boolean isOutputBound() {
        return this.isOutputBound;
    }

    @Override
    public void setOutputBound(boolean bl) {
        this.isOutputBound = bl;
    }
}

