/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;

public class ArgusHelper {
    private static final String ARGUS_HEADER = "$Oracle";
    private static final Map<String, String> _argusNames = new HashMap<String, String>();
    private static final Map<String, String> _argusTypes = new HashMap<String, String>();

    private ArgusHelper() {
    }

    public static String getArgusNameForType(String string) {
        return _argusNames.get(string);
    }

    public static String getArgusTypeForName(String string) {
        int n;
        String string2 = _argusTypes.get(string);
        if (string2 != null && (n = string2.indexOf(47)) >= 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static String getArgusSubTypeForName(String string) {
        int n;
        String string2 = null;
        String string3 = _argusTypes.get(string);
        if (string3 != null && (n = string3.indexOf(47)) >= 0) {
            string2 = string3.substring(n + 1);
        }
        return string2;
    }

    private static void registerArgusTypeAndName(String string, String string2) {
        _argusNames.put(string, string2);
        _argusTypes.put(string2, string);
    }

    public static final URL argusStringToUrl(String string, String string2) {
        ArgusStringParser argusStringParser = ArgusStringParser.makeArgusStringParser(string);
        if (argusStringParser != null) {
            URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2, null, argusStringParser.schema, argusStringParser.type);
            return DBURLFormatHelper.getURL(uRL, argusStringParser.programUnitName);
        }
        return null;
    }

    static {
        ArgusHelper.registerArgusTypeAndName("PACKAGE", "Package");
        ArgusHelper.registerArgusTypeAndName("PACKAGE BODY", "PackageBody");
        ArgusHelper.registerArgusTypeAndName("PROCEDURE", "Procedure");
        ArgusHelper.registerArgusTypeAndName("FUNCTION", "Function");
        ArgusHelper.registerArgusTypeAndName("TYPE", "Type");
        ArgusHelper.registerArgusTypeAndName("TYPE BODY", "TypeBody");
        ArgusHelper.registerArgusTypeAndName("TRIGGER", "Trigger");
        ArgusHelper.registerArgusTypeAndName("BLOCK", "Block");
    }

    private static class ArgusStringParser {
        String type;
        String subtype;
        String programUnitType;
        String programUnitName;
        String schema;

        ArgusStringParser(String string, String string2, String string3, String string4, String string5) {
            this.type = string;
            this.subtype = string2;
            this.programUnitType = string3;
            this.programUnitName = string4;
            this.schema = string5;
        }

        static ArgusStringParser makeArgusStringParser(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n = Math.min(stringTokenizer.countTokens(), 4);
            String[] stringArray = new String[n];
            int n2 = 0;
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n2++] = stringTokenizer.nextToken();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stringArray[0].equals(ArgusHelper.ARGUS_HEADER)) {
                String string2;
                String string3;
                String string4 = stringArray[1];
                if (n2 > 3) {
                    string3 = stringArray[2];
                    string2 = stringArray[3];
                } else {
                    string3 = "";
                    string2 = stringArray[2];
                }
                String string5 = ArgusHelper.getArgusTypeForName(string4);
                String string6 = ArgusHelper.getArgusSubTypeForName(string4);
                return new ArgusStringParser(string5, string6, string4, string2, string3);
            }
            return null;
        }
    }
}

