/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.Pair;

public class Renamer {
    List<LexerToken> src;
    LazyNode root;
    int offset;
    String newName;
    BasicEditorPane p;

    public boolean rename(Context context) {
        Object object;
        Object object2;
        Node node = context.getNode();
        View view = context.getView();
        this.p = ((FindableEditor)view).getFocusedEditorPane();
        this.newName = null;
        if (node instanceof PlSqlNode) {
            object2 = (PlSqlNode)node;
            this.src = ((PlSqlNode)object2).getParser().src;
        } else if (view instanceof FindableEditor && view instanceof EquippedWithParser) {
            object2 = ((EquippedWithParser)view).getParser();
            this.src = ((BackgroundParser)object2).src;
        }
        int n = this.p.getCaretPosition();
        this.offset = -1;
        LexerToken lexerToken = null;
        for (LexerToken lexerToken2 : this.src) {
            ++this.offset;
            if (lexerToken2.begin > n) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("Renamer.0"), null, null);
                return false;
            }
            if (lexerToken2.begin <= n && n <= lexerToken2.end) {
                if (lexerToken2.type != Token.IDENTIFIER) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("Renamer.1"), null, null);
                    return false;
                }
                if (lexerToken == null || !".".equals(lexerToken.content)) break;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("Renamer.3"), null, null);
                return false;
            }
            lexerToken = lexerToken2;
        }
        this.newName = this.askForNewName(this.src.get((int)this.offset).content);
        if (this.newName == null) {
            return false;
        }
        if (node instanceof PlSqlNode) {
            object = (PlSqlNode)node;
            this.root = ((PlSqlNode)object).getParser().output;
        } else if (view instanceof EquippedWithParser) {
            object = ((EquippedWithParser)view).getParser();
            this.root = ((BackgroundParser)object).output;
        }
        if (this.root == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("Renamer.4"), null, null);
            return false;
        }
        this.finishRename();
        return true;
    }

    private String askForNewName(String string) {
        JPanel jPanel = new JPanel(new FlowLayout());
        JTextField jTextField = new JTextField(30);
        jTextField.setText(string);
        jPanel.add(new JLabel(Messages.getString("Renamer.5")));
        jPanel.add(jTextField);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_rename_variable_html");
        if (!OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jTextField, (String)(Messages.getString("Renamer.7") + string))) {
            return null;
        }
        return jTextField.getText();
    }

    void finishRename() {
        LexerToken lexerToken;
        String string = this.src.get((int)this.offset).content;
        int n = this.newName.length() - string.length();
        Map<ParseNode, Pair<Integer, Integer>> map = IdentifiersDb.collectIdentifiers(this.offset, this.offset + 1, this.root);
        LexerToken lexerToken2 = null;
        for (ParseNode parseNode : map.keySet()) {
            if (!this.src.get((int)(parseNode.to - 1)).content.equals(string)) continue;
            lexerToken = map.get(parseNode);
            if ((Integer)lexerToken.first > this.offset || this.offset >= (Integer)lexerToken.second || lexerToken2 != null && ((Integer)lexerToken2.first > (Integer)lexerToken.first || (Integer)lexerToken.first > (Integer)lexerToken2.second)) continue;
            lexerToken2 = lexerToken;
        }
        if (lexerToken2 == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)(string + Messages.getString("Renamer.8")), null, null);
        }
        int n2 = 0;
        int n3 = -1;
        if (lexerToken2 != null) {
            lexerToken = null;
            for (LexerToken lexerToken3 : this.src) {
                if ((Integer)lexerToken2.first <= ++n3 && n3 < (Integer)lexerToken2.second && Service.handleMixedCase((String)this.src.get((int)n3).content).equals(Service.handleMixedCase((String)string)) && !".".equals(lexerToken.content) && !this.nestedDeclWithSameName(map, n3, Service.handleMixedCase((String)string), (Pair<Integer, Integer>)lexerToken2)) {
                    this.p.setSelectionStart(lexerToken3.begin + n2 * n);
                    this.p.setSelectionEnd(lexerToken3.end + n2 * n);
                    this.p.replaceSelection(this.newName);
                    ++n2;
                }
                lexerToken = lexerToken3;
            }
        }
    }

    private boolean nestedDeclWithSameName(Map<ParseNode, Pair<Integer, Integer>> map, int n, String string, Pair<Integer, Integer> pair) {
        for (ParseNode parseNode : map.keySet()) {
            Pair<Integer, Integer> pair2 = map.get(parseNode);
            if ((Integer)pair2.first > n || n >= (Integer)pair2.second || (Integer)pair.first >= (Integer)pair2.first || (Integer)pair2.first >= (Integer)pair.second || !string.equals(Service.handleMixedCase((String)this.src.get((int)(parseNode.to - 1)).content))) continue;
            return true;
        }
        return false;
    }
}

