/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.queryBuilder;

import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Logger;
import oracle.bali.dbUI.constraint.DCArithmeticExpression;
import oracle.bali.dbUI.constraint.DCBetweenExpression;
import oracle.bali.dbUI.constraint.DCBinaryExpression;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCCollectionExpression;
import oracle.bali.dbUI.constraint.DCComparisonExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DCExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraint.FreeFormDataConstraint;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.TableAlias;
import oracle.bali.dbUI.util.Collection;
import oracle.dbtools.raptor.queryBuilder.Messages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;

public class SQLGenerator {
    private static SQLGenerator _sSQLGenerator;
    private OuterJoin[] _outerjoins;
    private Logger logger = Logger.getLogger(SQLGenerator.class.getName());
    private String _connName = null;

    public static SQLGenerator getSQLGenerator() {
        if (_sSQLGenerator == null) {
            _sSQLGenerator = new SQLGenerator();
        }
        return _sSQLGenerator;
    }

    public String getSQLString(Column[] columnArray, DataConstraint dataConstraint, Relationship[] relationshipArray, OuterJoin[] outerJoinArray) {
        StringBuffer stringBuffer = new StringBuffer();
        this._outerjoins = outerJoinArray;
        this._getSQLString(stringBuffer, columnArray, relationshipArray, outerJoinArray);
        String string = stringBuffer.toString();
        int n = stringBuffer.length();
        stringBuffer = new StringBuffer();
        this.getSQLString(stringBuffer, dataConstraint);
        String string2 = stringBuffer.toString();
        int n2 = stringBuffer.length();
        if (n == 0) {
            string = string2;
        } else if (n2 != 0) {
            string = columnArray != null && columnArray.length > 0 ? (string.indexOf("WHERE") == -1 ? string + " WHERE " + string2 : string + " AND " + string2) : string + " AND " + string2;
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    protected void getSQLString(StringBuffer stringBuffer, DataConstraint dataConstraint) {
        if (dataConstraint == null) {
            return;
        }
        if (dataConstraint instanceof FreeFormDataConstraint) {
            FreeFormDataConstraint freeFormDataConstraint = (FreeFormDataConstraint)dataConstraint;
            stringBuffer.append("( ");
            stringBuffer.append(freeFormDataConstraint.getString());
            stringBuffer.append(" )");
            return;
        }
        DataConstraint dataConstraint2 = null;
        DataConstraint dataConstraint3 = null;
        int n = -1;
        if (dataConstraint instanceof DCExpression) {
            n = ((DCExpression)dataConstraint).getOperand();
        }
        if (dataConstraint instanceof DCBinaryExpression) {
            DCBinaryExpression dCBinaryExpression = (DCBinaryExpression)dataConstraint;
            dataConstraint2 = dCBinaryExpression.getConstraint(0);
            dataConstraint3 = dCBinaryExpression.getConstraint(1);
            if (!(dataConstraint2 instanceof DCVariable) && dataConstraint3 instanceof DCVariable) {
                DataConstraint dataConstraint4 = dataConstraint2;
                dataConstraint2 = dataConstraint3;
                dataConstraint3 = dataConstraint4;
            }
        } else if (dataConstraint instanceof DCUnaryExpression) {
            DCUnaryExpression dCUnaryExpression = (DCUnaryExpression)dataConstraint;
            dataConstraint2 = dCUnaryExpression.getConstraint(0);
        }
        if (dataConstraint instanceof DCVariable) {
            this._getVariableValue(stringBuffer, (DCVariable)dataConstraint);
        } else if (dataConstraint instanceof DCConstant) {
            this._getConstantValue(stringBuffer, (DCConstant)dataConstraint);
        } else if (dataConstraint instanceof DCArithmeticExpression) {
            this._getArithmetic(stringBuffer, dataConstraint2, dataConstraint3, n);
        } else if (dataConstraint instanceof DCBooleanExpression) {
            this._getBoolean(stringBuffer, (DCBooleanExpression)dataConstraint);
        } else if (dataConstraint instanceof DCUnaryExpression) {
            stringBuffer.append("( NOT ");
            this.getSQLString(stringBuffer, dataConstraint2);
            stringBuffer.append(" )");
        } else if (dataConstraint instanceof DCComparisonExpression) {
            this._getComparison(stringBuffer, dataConstraint2, dataConstraint3, n);
        } else if (dataConstraint instanceof DCCollectionExpression) {
            this._getCollection(stringBuffer, dataConstraint2, dataConstraint3, n);
        } else if (dataConstraint instanceof DCBetweenExpression) {
            this._getBetween(stringBuffer, (DCBetweenExpression)dataConstraint);
        }
    }

    private void _getArithmetic(StringBuffer stringBuffer, DataConstraint dataConstraint, DataConstraint dataConstraint2, int n) {
        stringBuffer.append("( ");
        this.getSQLString(stringBuffer, dataConstraint);
        switch (n) {
            case 1: {
                stringBuffer.append(" + ");
                break;
            }
            case 2: {
                stringBuffer.append(" - ");
                break;
            }
            case 3: {
                stringBuffer.append(" * ");
                break;
            }
            case 4: {
                stringBuffer.append(" / ");
            }
        }
        this.getSQLString(stringBuffer, dataConstraint2);
        stringBuffer.append(" )");
    }

    private void _getBoolean(StringBuffer stringBuffer, DCBooleanExpression dCBooleanExpression) {
        stringBuffer.append("( ");
        int n = dCBooleanExpression.getOperand();
        String string = n == 1 ? " AND " : " OR ";
        int n2 = dCBooleanExpression.getConstraintCount();
        for (int i = 0; i < n2 - 1; ++i) {
            this.getSQLString(stringBuffer, dCBooleanExpression.getConstraint(i));
            stringBuffer.append(string);
        }
        this.getSQLString(stringBuffer, dCBooleanExpression.getConstraint(n2 - 1));
        stringBuffer.append(" )");
    }

    private void _getBetween(StringBuffer stringBuffer, DCBetweenExpression dCBetweenExpression) {
        int n = dCBetweenExpression.getOperand();
        String string = n == 1 ? " BETWEEN " : " NOT BETWEEN ";
        stringBuffer.append("( ");
        this.getSQLString(stringBuffer, dCBetweenExpression.getCheckConstraint());
        stringBuffer.append(string);
        this.getSQLString(stringBuffer, dCBetweenExpression.getFirstConstraint());
        stringBuffer.append(" AND ");
        this.getSQLString(stringBuffer, dCBetweenExpression.getSecondConstraint());
        stringBuffer.append(" )");
    }

    private void _getComparison(StringBuffer stringBuffer, DataConstraint dataConstraint, DataConstraint dataConstraint2, int n) {
        stringBuffer.append("( ");
        this.getSQLString(stringBuffer, dataConstraint);
        boolean bl = false;
        boolean bl2 = false;
        if (dataConstraint2 instanceof DCConstant) {
            Object object = ((DCConstant)dataConstraint2).getValue();
            if (object == null) {
                bl = true;
            } else if (object instanceof String) {
                bl2 = true;
            }
        }
        switch (n) {
            case 1: {
                stringBuffer.append(" > ");
                break;
            }
            case 2: {
                stringBuffer.append(" < ");
                break;
            }
            case 3: {
                stringBuffer.append(bl ? " IS " : " = ");
                break;
            }
            case 4: {
                stringBuffer.append(bl ? " IS NOT " : " <> ");
                break;
            }
            case 5: {
                stringBuffer.append(" >= ");
                break;
            }
            case 6: {
                stringBuffer.append(" <= ");
            }
        }
        if (bl2) {
            stringBuffer.append("'");
        }
        this.getSQLString(stringBuffer, dataConstraint2);
        if (bl2) {
            stringBuffer.append("'");
        }
        stringBuffer.append(" )");
    }

    private void _getCollection(StringBuffer stringBuffer, DataConstraint dataConstraint, DataConstraint dataConstraint2, int n) {
        boolean bl;
        boolean bl2 = bl = n == 2 || n == 4 || n == 6;
        if (bl) {
            stringBuffer.append("( NOT ");
        } else {
            stringBuffer.append("( ");
        }
        this.getSQLString(stringBuffer, dataConstraint);
        switch (n) {
            case 1: {
                stringBuffer.append(" LIKE '");
                this.getSQLString(stringBuffer, dataConstraint2);
                stringBuffer.append("%')");
                break;
            }
            case 2: {
                stringBuffer.append(" LIKE '");
                this.getSQLString(stringBuffer, dataConstraint2);
                stringBuffer.append("%')");
                break;
            }
            case 3: {
                stringBuffer.append(" LIKE '%");
                this.getSQLString(stringBuffer, dataConstraint2);
                stringBuffer.append("')");
                break;
            }
            case 4: {
                stringBuffer.append(" LIKE '%");
                this.getSQLString(stringBuffer, dataConstraint2);
                stringBuffer.append("')");
                break;
            }
            case 5: 
            case 6: {
                if (!(dataConstraint2 instanceof DCConstant)) break;
                Object object = ((DCConstant)dataConstraint2).getValue();
                if (object instanceof String) {
                    stringBuffer.append(" LIKE '%");
                    this.getSQLString(stringBuffer, dataConstraint2);
                    stringBuffer.append("%')");
                    break;
                }
                if (!(object instanceof Collection)) break;
                stringBuffer.append(" IN ");
                this.getSQLString(stringBuffer, dataConstraint2);
                stringBuffer.append(" )");
            }
        }
    }

    private boolean _isColumnInOuterJoin(Column column) {
        if (this._outerjoins == null) {
            return false;
        }
        for (int i = 0; i < this._outerjoins.length; ++i) {
            if (this._outerjoins[i].getDestination() != column.getTable()) continue;
            return true;
        }
        return false;
    }

    private void _getVariableValue(StringBuffer stringBuffer, DCVariable dCVariable) {
        if (dCVariable == null) {
            return;
        }
        Object object = dCVariable.getVariable();
        if (object instanceof Column) {
            Column column = (Column)object;
            if (!(column.getTable() instanceof TableAlias)) {
                stringBuffer.append(this._getQuotedString(column.getTable().getSchema().getName()));
                stringBuffer.append(".");
            }
            stringBuffer.append(this._getQuotedString(column.getTable().getName()));
            stringBuffer.append(".");
            stringBuffer.append(this._getQuotedString(column.getName()));
            if (this._isColumnInOuterJoin(column)) {
                stringBuffer.append(" (+)");
            }
        } else if (object instanceof DataDescriptor) {
            DataDescriptor dataDescriptor = (DataDescriptor)object;
            stringBuffer.append(dataDescriptor.getName());
        } else if (object != null) {
            stringBuffer.append(object.toString());
        }
    }

    private void _getConstantValue(StringBuffer stringBuffer, DCConstant dCConstant) {
        if (dCConstant == null) {
            return;
        }
        Object object = dCConstant.getValue();
        if (object == null) {
            stringBuffer.append("NULL");
            return;
        }
        try {
            Connection connection = Connections.getInstance().getConnection(this._connName);
            if (object instanceof Collection) {
                Enumeration enumeration = ((Collection)object).getEnumeration();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("( ");
                while (enumeration.hasMoreElements()) {
                    stringBuffer2.append("'");
                    stringBuffer2.append(enumeration.nextElement().toString());
                    stringBuffer2.append("', ");
                }
                String string = stringBuffer2.toString();
                int n = string.lastIndexOf(44);
                string = n != -1 ? string.substring(0, n) + " )" : string + " )";
                stringBuffer.append(string);
            } else if (object instanceof Time) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm:ss");
                stringBuffer.append("'");
                stringBuffer.append(simpleDateFormat.format(object));
                stringBuffer.append("'");
            } else if (object instanceof Timestamp) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
                String string = null;
                string = NLSUtils.format((Connection)connection, (Object)new TIMESTAMP((Timestamp)object));
                string = "to_timestamp('" + string + "','" + NLSUtils.getTimeStampFormat((Connection)connection) + "')";
                if (string == null) {
                    stringBuffer.append("'");
                    stringBuffer.append(simpleDateFormat.format(object));
                    stringBuffer.append("'");
                } else {
                    stringBuffer.append(string);
                }
            } else if (object instanceof java.util.Date) {
                String string;
                String string2 = string = object instanceof Date ? NLSUtils.format((Connection)connection, (Object)new DATE((Date)object)) : NLSUtils.format((Connection)connection, (Object)new DATE(object));
                if (string != null) {
                    string = "to_date('" + string + "','" + NLSUtils.getDateFormat((Connection)connection) + "')";
                }
                if (string == null) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
                    stringBuffer.append("'");
                    stringBuffer.append(simpleDateFormat.format(object));
                    stringBuffer.append("'");
                } else {
                    stringBuffer.append(string);
                }
            } else if (object instanceof String) {
                stringBuffer.append(object.toString());
            } else if (object instanceof Double) {
                if ((double)((Double)object).intValue() == (Double)object) {
                    stringBuffer.append(((Double)object).intValue());
                } else {
                    char c = NLSUtils.getDecimalSeparator((Connection)connection);
                    stringBuffer.append((double)(((Double)object).intValue() + c) + ((Double)object - (double)((Double)object).intValue()));
                }
            } else {
                stringBuffer.append("'");
                stringBuffer.append(object.toString());
                stringBuffer.append("'");
            }
        }
        catch (Exception exception) {
            this.logger.severe(Messages.getString("SQLGenerator.1") + object.toString());
        }
    }

    private void _getRelationshipString(StringBuffer stringBuffer, Relationship[] relationshipArray, OuterJoin[] outerJoinArray) {
        int n;
        if (relationshipArray == null) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = outerJoinArray == null ? 0 : outerJoinArray.length;
        for (int i = 0; i < relationshipArray.length; ++i) {
            boolean bl = false;
            boolean bl2 = false;
            Relationship relationship = relationshipArray[i];
            int n3 = relationship.getColumnCount();
            for (n = 0; n < n3; ++n) {
                Column column = relationship.getColumn(n);
                Table table = column.getTable();
                Column column2 = relationship.getReferencedColumn(n);
                Table table2 = column2.getTable();
                int n4 = relationship.getRelationshipType();
                if (n2 > 0) {
                    for (int j = 0; j < n2; ++j) {
                        if (outerJoinArray[j].getSource().equals((Object)table) && outerJoinArray[j].getDestination().equals((Object)table2)) {
                            bl2 = true;
                            continue;
                        }
                        if (!outerJoinArray[j].getSource().equals((Object)table2) || !outerJoinArray[j].getDestination().equals((Object)table)) continue;
                        bl = true;
                    }
                }
                stringBuffer2.append("( ");
                if (!(table instanceof TableAlias)) {
                    stringBuffer2.append(this._getQuotedString(table.getSchema().getName()));
                    stringBuffer2.append(".");
                }
                stringBuffer2.append(this._getQuotedString(table.getName()));
                stringBuffer2.append(".");
                stringBuffer2.append(this._getQuotedString(column.getName()));
                if (bl) {
                    stringBuffer2.append(" (+)");
                }
                this._getTypeString(stringBuffer2, n4);
                if (!(table2 instanceof TableAlias)) {
                    stringBuffer2.append(this._getQuotedString(table2.getSchema().getName()));
                    stringBuffer2.append(".");
                }
                stringBuffer2.append(this._getQuotedString(table2.getName()));
                stringBuffer2.append(".");
                stringBuffer2.append(this._getQuotedString(column2.getName()));
                if (bl2) {
                    stringBuffer2.append(" (+)");
                }
                stringBuffer2.append(" ) AND ");
            }
        }
        String string = stringBuffer2.toString();
        n = string.lastIndexOf(" AND ");
        if (n != -1) {
            string = string.substring(0, n);
        }
        stringBuffer.append(string);
    }

    private void _getTypeString(StringBuffer stringBuffer, int n) {
        switch (n) {
            case 0: {
                stringBuffer.append(" = ");
                break;
            }
            case 1: {
                stringBuffer.append(" <> ");
                break;
            }
            case 2: {
                stringBuffer.append(" > ");
                break;
            }
            case 3: {
                stringBuffer.append(" < ");
                break;
            }
            case 5: {
                stringBuffer.append(" >= ");
                break;
            }
            case 4: {
                stringBuffer.append(" <= ");
                break;
            }
            default: {
                this.logger.info(Messages.getString("SQLGenerator.0"));
            }
        }
    }

    private void _getSQLString(StringBuffer stringBuffer, Column[] columnArray, Relationship[] relationshipArray, OuterJoin[] outerJoinArray) {
        String string;
        String string2;
        int n;
        String string3;
        Table table;
        Column column;
        int n2;
        if (columnArray == null || columnArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (n2 = 0; n2 < columnArray.length; ++n2) {
            String string4;
            TableAlias tableAlias;
            column = columnArray[n2];
            table = column.getTable();
            TableAlias tableAlias2 = tableAlias = table instanceof TableAlias ? (TableAlias)table : null;
            if (tableAlias != null) {
                string4 = this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(tableAlias.getTable().getName()) + " " + this._getQuotedString(tableAlias.getName());
                string3 = this._getQuotedString(tableAlias.getName());
            } else {
                string3 = string4 = this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(table.getName());
            }
            if (stringBuffer3.toString().indexOf(string4) == -1) {
                stringBuffer3.append(string4);
                stringBuffer3.append(", ");
            }
            String string5 = column.getName();
            String string6 = string3 + "." + this._getQuotedString(string5);
            String string7 = column.getDisplayName(Locale.getDefault());
            if (string5.equals(string7)) {
                stringBuffer2.append(string6);
                stringBuffer2.append(", ");
                continue;
            }
            stringBuffer2.append(string6);
            stringBuffer2.append(" as ");
            stringBuffer2.append(this._getQuotedString(string7));
            stringBuffer2.append(", ");
        }
        if (relationshipArray != null) {
            for (n2 = 0; n2 < relationshipArray.length; ++n2) {
                Relationship relationship = relationshipArray[n2];
                column = relationship.getColumn(0);
                table = column.getTable();
                string3 = table instanceof TableAlias ? this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(((TableAlias)table).getTable().getName()) + " " + this._getQuotedString(table.getName()) : this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(table.getName());
                if (stringBuffer3.toString().indexOf(string3) == -1) {
                    stringBuffer3.append(string3);
                    stringBuffer3.append(", ");
                }
                string3 = (table = (column = relationship.getReferencedColumn(0)).getTable()) instanceof TableAlias ? this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(((TableAlias)table).getTable().getName()) + " " + this._getQuotedString(table.getName()) : this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(table.getName());
                if (stringBuffer3.toString().indexOf(string3) != -1) continue;
                stringBuffer3.append(string3);
                stringBuffer3.append(", ");
            }
        }
        if ((n = (string2 = stringBuffer2.toString()).lastIndexOf(44)) != -1) {
            string2 = string2.substring(0, n);
        }
        if ((n = (string = stringBuffer3.toString()).lastIndexOf(44)) != -1) {
            string = string.substring(0, n);
        }
        if (string2 != "") {
            stringBuffer.append("SELECT ");
            stringBuffer.append(string2);
            stringBuffer.append(" FROM ");
            stringBuffer.append(string);
        }
        StringBuffer stringBuffer4 = new StringBuffer();
        if (string.indexOf(44) != -1) {
            this._getRelationshipString(stringBuffer4, relationshipArray, outerJoinArray);
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(stringBuffer4);
        } else if (stringBuffer4.length() != 0) {
            stringBuffer.append(" WHERE ");
            stringBuffer.append(stringBuffer4.toString());
        }
    }

    private String _getQuotedString(String string) {
        return "\"" + string + "\"";
    }

    public void setConnName(String string) {
        this._connName = string;
    }

    protected SQLGenerator() {
    }
}

