/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.queryBuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.bali.dbUI.queryBuilder.CustomizedQueryBuilder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.queryBuilder.Messages;
import oracle.dbtools.raptor.queryBuilder.QueryBuilderDatabase;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class QueryBuilderContextMenu
implements Controller,
ContextMenuListener {
    public static int QB_POPUP = Ide.findOrCreateCmdID((String)"sqldev.qb.launch");
    private static QueryBuilderContextMenu _instance;
    private IdeAction _qbLaunch;

    private QueryBuilderContextMenu() {
    }

    public static synchronized QueryBuilderContextMenu getInstance() {
        if (_instance == null) {
            _instance = new QueryBuilderContextMenu();
        }
        return _instance;
    }

    private Database getDatabase(Context context) {
        Database database = null;
        Node node = context.getNode();
        if (context.getView() instanceof IDBEditor) {
            database = ((IDBEditor)context.getView()).getDatabase();
        } else if (node instanceof DatabaseSourceNode) {
            try {
                String string = ((DatabaseSourceNode)node).getConnectionName();
                if (string != null) {
                    database = Connections.getInstance().getDatabase(string);
                }
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
        return database;
    }

    private String getConnectionName(Context context) {
        String string = null;
        Node node = context.getNode();
        if (context.getView() instanceof IDBEditor) {
            string = ((IDBEditor)context.getView()).getConnectionName();
        } else if (node instanceof DatabaseSourceNode) {
            string = ((DatabaseSourceNode)node).getConnectionName();
        }
        return string;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == QB_POPUP) {
            String string = null;
            Database database = this.getDatabase(context);
            if (database != null) {
                Object object;
                BasicEditorPane basicEditorPane = null;
                if (context.getView() instanceof Editor && (object = (Editor)context.getView()).getDefaultFocusComponent() instanceof BasicEditorPane) {
                    basicEditorPane = (BasicEditorPane)object.getDefaultFocusComponent();
                    string = basicEditorPane.getText();
                }
                object = new CustomizedQueryBuilder(new QueryBuilderDatabase(database));
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)object, "Center");
                jPanel.setMinimumSize(new Dimension(400, 400));
                BasicEditorPane basicEditorPane2 = basicEditorPane;
                HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_popupquerybuilder_html");
                UIUtils.showPanelAsDialog((JPanel)jPanel, (String)Messages.getString("QueryBuilderContextMenu.2"), (ActionListener)new ActionListener((CustomizedQueryBuilder)object, basicEditorPane2){
                    final /* synthetic */ CustomizedQueryBuilder val$qb;
                    final /* synthetic */ BasicEditorPane val$editorPane;
                    {
                        this.val$qb = customizedQueryBuilder;
                        this.val$editorPane = basicEditorPane;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                        String string = this.val$qb.getSQLString();
                        int n = this.val$editorPane.getCaretPosition();
                        try {
                            this.val$editorPane.getDocument().insertString(n, string, null);
                        }
                        catch (BadLocationException badLocationException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                        }
                    }
                });
            } else {
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)Messages.getString("QueryBuilderContextMenu.3"), (String)Messages.getString("QueryBuilderContextMenu.4"), (String)"f1_no_connection_html");
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Database database;
        Context context = contextMenu.getContext();
        String string = this.getConnectionName(context);
        Connections connections = Connections.getInstance();
        if (string != null && !connections.getLock(string).isLocked() && (database = this.getDatabase(context)) != null && connections.isOracle(database.getConnection()) && context.getEvent().getSource() instanceof JTextComponent && this.isValidNode(context)) {
            if (this._qbLaunch == null) {
                this.init();
            }
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this._qbLaunch));
        }
    }

    private boolean isValidNode(Context context) {
        Node node = context.getNode();
        return node instanceof PlSqlNode || node instanceof SqlNode;
    }

    private void init() {
        this._qbLaunch = IdeAction.get((int)QB_POPUP, null, (String)Messages.getString("QueryBuilderContextMenu.6"), null, null, null, null, (boolean)true);
        this._qbLaunch.addController((Controller)this);
    }
}

