/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlArguments;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.navigator.plsql.PlsqlStructureParser;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.ide.Context;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class OutlinePanel
extends JPanel
implements TreeSelectionListener,
ParserEventListener {
    private JTree tree;
    DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode(""));
    private JTextField restrict;
    private Editor editor = null;

    public OutlinePanel() {
        super(new GridBagLayout());
        this.tree = new JTree(this.model);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setCellRenderer(new NodeRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.restrict = new JTextField();
        this.restrict.getAccessibleContext().setAccessibleName(Messages.getString("OutlinePanel.0"));
        this.restrict.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = OutlinePanel.this.restrict.getText();
                OutlinePanel.this.trimTree(string);
            }
        });
        this.add((Component)this.restrict, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 10, 0));
        this.add((Component)new JScrollPane(this.tree), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(1, 1, 0, 0), 0, 0));
    }

    protected void trimTree(String string) {
        String string2 = string.toLowerCase();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.clone();
        int n = this.model.getChildCount(defaultMutableTreeNode);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)this.model.getChild(defaultMutableTreeNode, i);
            if (!(defaultMutableTreeNode3.getUserObject() instanceof Member)) continue;
            Member member = (Member)defaultMutableTreeNode3.getUserObject();
            if (!member.name.toLowerCase().startsWith(string2)) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(member));
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode2);
        this.tree.setModel(defaultTreeModel);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof Member) {
            Member member = (Member)object;
            if (this.editor != null) {
                this.editor.activate();
                BasicEditorPane basicEditorPane = null;
                if (this.editor instanceof FindableEditor) {
                    basicEditorPane = ((FindableEditor)this.editor).getFocusedEditorPane();
                }
                this.gotoOffset(member.codeOffset, member.name.length(), basicEditorPane);
            }
        }
    }

    private boolean gotoOffset(int n, int n2, BasicEditorPane basicEditorPane) {
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        int n3 = basicDocument.getLength();
        int n4 = Math.max(0, Math.min(n, n3));
        int n5 = Math.max(n4, Math.min(n4 + n2, n3));
        basicEditorPane.setCaretPositionCenter(n4);
        if (n4 != n5) {
            basicEditorPane.moveCaretPositionCenter(n5);
        }
        return n == n4 && n2 == n5 - n4;
    }

    public void refresh(Editor editor) {
        this.buildNewOutlineTree((View)editor);
        this.restrict.setText("");
    }

    public void buildNewOutlineTree(View view) {
        this.editor = view instanceof Editor ? (Editor)view : null;
        this.setModel(new DefaultMutableTreeNode(""));
        Context context = view.getContext();
        Node node = context.getNode();
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            plSqlNode.getParser().replaceOutlineListener(this);
            String string = plSqlNode.getObjectType();
            String string2 = plSqlNode.getObjectName();
            if (string == null || string2 == null) {
                plSqlNode.parseNameTypeOwner();
                string2 = plSqlNode.getName();
                string = plSqlNode.getType();
            }
            if ("BLOCK".equals(string)) {
                string2 = "ANONYMOUS BLOCK";
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new Member(string2, string, 0, string + " " + string2));
            ArrayList<Member> arrayList = new ArrayList<Member>();
            plSqlNode.addMembersTo(arrayList);
            for (Member member : arrayList) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(member));
            }
            this.setModel(defaultMutableTreeNode);
        } else if (node instanceof TextNode) {
            if (view instanceof EquippedWithParser) {
                ((EquippedWithParser)view).getParser().replaceOutlineListener(this);
            }
            TextBuffer textBuffer = ((TextNode)node).acquireTextBuffer();
            String string = textBuffer.getString(0, textBuffer.getLength());
            ((TextNode)node).releaseTextBuffer();
            List list = LexerToken.parse((String)string, (boolean)false);
            PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
            plsqlStructureParser.parse(list, PlSqlArguments.sort);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("");
            for (Member member : plsqlStructureParser.children) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(member));
            }
            this.setModel(defaultMutableTreeNode);
        }
    }

    public void setModel(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.model = new DefaultTreeModel(defaultMutableTreeNode);
        this.tree.setModel(this.model);
    }

    @Override
    public void stateChanged(BackgroundParser backgroundParser) {
        PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
        plsqlStructureParser.parse(backgroundParser.src, PlSqlArguments.sort);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.model.getRoot()).clone();
        for (Member member : plsqlStructureParser.children) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(member));
        }
        this.setModel(defaultMutableTreeNode);
    }

    class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        NodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (!(object instanceof DefaultMutableTreeNode)) {
                return this;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (!(defaultMutableTreeNode.getUserObject() instanceof Member)) {
                return this;
            }
            Member member = (Member)defaultMutableTreeNode.getUserObject();
            this.setIcon(member.getIcon());
            this.setToolTipText(member.tooltip);
            String string = member.name;
            if (member.type.contains("BODY")) {
                string = string + " Body";
            }
            this.setText(string);
            return this;
        }
    }
}

