/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;

public class BackgroundParser
implements TextBufferListener,
EditorPlugin {
    static int cnt = 0;
    int num = 0;
    public LazyNode output = null;
    public List<LexerToken> src = null;
    public String text = null;
    public ArrayList<NumberRange> increments = new ArrayList();
    private TextBuffer buffer = null;
    long lastUpdate = -1L;
    public BasicEditorPane editor;
    boolean quit = false;
    public boolean isInsertion = false;
    public boolean isSingleChar = false;
    private List<ParserEventListener> listeners = new ArrayList<ParserEventListener>();

    public BackgroundParser() {
        this.num = cnt++;
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.buffer = textBuffer;
        this.increments.add(new NumberRange(n, n + n2));
        this.lastUpdate = System.currentTimeMillis();
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.buffer = textBuffer;
        this.increments.add(new NumberRange(n, n - n2));
        this.lastUpdate = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean extractText() {
        try {
            if (!this.buffer.tryReadLock()) {
                boolean bl = false;
                return bl;
            }
            if (this.buffer.getLength() > 5000000) {
                this.quit = true;
                Logger.getLogger(this.getClass().getName()).warning("Mem exceeded");
                boolean bl = false;
                return bl;
            }
            this.text = this.buffer.getString(0, this.buffer.getLength());
            if (this.text != null) return true;
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.buffer.readUnlock();
            }
            catch (Throwable throwable) {}
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.quit = true;
        if (this.buffer != null) {
            this.buffer.removeTextBufferListener((TextBufferListener)this);
        }
    }

    private void cleanup() {
        this.editor = null;
        this.text = null;
        this.output = null;
        this.buffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        if (this.text == null) {
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            this.buffer = basicDocument.getTextBuffer();
            if (!this.buffer.tryReadLock()) {
                return;
            }
            try {
                if (this.buffer.getLength() > 5000000) {
                    Logger.getLogger(this.getClass().getName()).warning("Mem exceeded");
                    return;
                }
                this.text = this.buffer.getString(0, this.buffer.getLength());
                this.buffer.addTextBufferListener((TextBufferListener)this);
            }
            finally {
                this.buffer.readUnlock();
            }
            this.init();
        }
    }

    private void init() {
        this.src = null;
        try {
            NamedSwingWorker namedSwingWorker = new NamedSwingWorker("Background Parser"){

                @Override
                public Object construct() {
                    BackgroundParser.this.quit = false;
                    while (!BackgroundParser.this.quit) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (BackgroundParser.this.src != null && System.currentTimeMillis() - BackgroundParser.this.lastUpdate < 250L || BackgroundParser.this.src != null && BackgroundParser.this.increments.size() == 0) continue;
                        BackgroundParser.this.isInsertion = BackgroundParser.this.isInsertion();
                        BackgroundParser.this.isSingleChar = BackgroundParser.this.isSingleChar();
                        if (!BackgroundParser.this.extractText()) continue;
                        try {
                            BackgroundParser.this.parse();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    BackgroundParser.this.cleanup();
                    return null;
                }
            };
            namedSwingWorker.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        this.increments = new ArrayList();
        long l = System.currentTimeMillis();
        if (this.text == null) {
            return;
        }
        List list = LexerToken.parse((String)this.text);
        this.output = StackParser.parse((List)list);
        this.src = list;
        long l2 = System.currentTimeMillis();
        if (RaptorExtensionConstants.isStandAlone()) {
            System.out.println("Finished parsing = " + (l2 - l));
        }
        BackgroundParser backgroundParser = this;
        synchronized (backgroundParser) {
            for (ParserEventListener parserEventListener : this.listeners) {
                try {
                    parserEventListener.stateChanged(this);
                }
                catch (Exception exception) {
                    exception.fillInStackTrace();
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public synchronized void addParserEventListener(ParserEventListener parserEventListener) {
        this.listeners.add(parserEventListener);
    }

    public synchronized void removeParserEventListener(ParserEventListener parserEventListener) {
        this.listeners.remove(parserEventListener);
    }

    public synchronized void replaceOutlineListener(OutlinePanel outlinePanel) {
        LinkedList<ParserEventListener> linkedList = new LinkedList<ParserEventListener>();
        for (ParserEventListener parserEventListener : this.listeners) {
            if (!(parserEventListener instanceof OutlinePanel)) continue;
            linkedList.add(parserEventListener);
        }
        this.listeners.removeAll(linkedList);
        this.listeners.add(outlinePanel);
    }

    public static boolean isBody(LinkedList<LexerToken> linkedList) {
        boolean bl = false;
        int n = 0;
        for (LexerToken lexerToken : linkedList) {
            if ("BODY".equalsIgnoreCase(lexerToken.content)) {
                bl = true;
                break;
            }
            if (n++ <= 10) continue;
            break;
        }
        return bl;
    }

    public int recalculatePosition(int n) {
        int n2 = this.recalcPos(n);
        while (n2 != n) {
            n = n2;
            n2 = this.recalcPos(n2);
        }
        return n2;
    }

    private int recalcPos(int n) {
        for (NumberRange numberRange : this.increments) {
            if (numberRange.end != n) continue;
            return numberRange.start;
        }
        return n;
    }

    private boolean isInsertion() {
        boolean bl = false;
        for (NumberRange numberRange : this.increments) {
            if (numberRange.start < numberRange.end) {
                bl = true;
                continue;
            }
            if (numberRange.start <= numberRange.end) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isSingleChar() {
        if (this.increments.size() != 1) {
            return false;
        }
        for (NumberRange numberRange : this.increments) {
            if (numberRange.start + 1 == numberRange.end) continue;
            return false;
        }
        return true;
    }
}

