/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.navigator.BaseNavigatorManager;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.ChildType;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseItem;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.FilterChildProvider;
import oracle.dbtools.raptor.navigator.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.xml.XmlChildImpl;
import oracle.dbtools.raptor.navigator.xml.XmlDBObject;
import oracle.dbtools.raptor.navigator.xml.XmlDatabaseItem;
import oracle.dbtools.raptor.navigator.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.navigator.xml.XmlObjectType;
import oracle.ide.model.Element;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.XMLNode;

public class XmlNodeImpl
extends XmlDatabaseItem
implements XmlDBObject,
NavigatorXmlElements {
    private XmlObjectType m_type;
    private List<XmlChildImpl> m_childTypes = new ArrayList<XmlChildImpl>();
    private String m_nodeClassName;
    private Class<? extends Element> m_nodeClass;
    private String m_implClassName;
    private Class<? extends DatabaseObject> m_implClass;
    private String m_instClassName;
    private Class<? extends DBObjectInstance> m_instClass;

    public XmlNodeImpl(XmlObjectType xmlObjectType, NavigatorDescriptor navigatorDescriptor, XMLNode xMLNode) {
        super(xMLNode, navigatorDescriptor, xmlObjectType.getType());
        this.m_type = xmlObjectType;
        this.m_nodeClassName = XmlNavigatorUtils.getAttributeValue("", "nodeClass", xMLNode);
        this.m_implClassName = XmlNavigatorUtils.getAttributeValue("", "itemClass", xMLNode);
        this.m_instClassName = XmlNavigatorUtils.getAttributeValue("", "instanceClass", xMLNode);
        XMLNode[] xMLNodeArray = XmlNavigatorUtils.getElements("childType", xMLNode);
        if (xMLNodeArray != null) {
            for (XMLNode xMLNode2 : xMLNodeArray) {
                String string = XmlNavigatorUtils.getAttributeValue("", "id", xMLNode2);
                if (string == null) continue;
                this.m_childTypes.add(new XmlChildImpl(string, navigatorDescriptor, xmlObjectType.getType(), xMLNode2));
            }
        }
    }

    @Override
    public ChildType[] getChildTypes() {
        return this.m_childTypes.toArray(new ChildType[0]);
    }

    @Override
    public DatabaseItem getChildType(String string) {
        return this.getChildTypeImpl(string);
    }

    private XmlChildImpl getChildTypeImpl(String string) {
        for (XmlChildImpl xmlChildImpl : this.m_childTypes) {
            if (!ModelUtil.areEqual((Object)string, (Object)xmlChildImpl.getChildType())) continue;
            return xmlChildImpl;
        }
        return null;
    }

    @Override
    public Class<? extends Element> getImplementationClass() {
        if (this.m_nodeClass == null && this.m_nodeClassName != null) {
            try {
                this.m_nodeClass = Class.forName(this.m_nodeClassName).asSubclass(Element.class);
                assert (DatabaseNode.class.isAssignableFrom(this.m_nodeClass));
                BaseNavigatorManager.registerObjectNodeClass(this.m_type.getType(), this.m_nodeClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_nodeClass;
    }

    Class<? extends DatabaseObject> getDBObjectImplementationClass() {
        if (this.m_implClass == null && this.m_implClassName != null) {
            try {
                this.m_implClass = Class.forName(this.m_implClassName).asSubclass(DatabaseObject.class);
                assert (DatabaseObject.class.isAssignableFrom(this.m_implClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_implClass;
    }

    @Override
    public Class<? extends DBObjectInstance> getDBObjectInstanceClass() {
        if (this.m_instClass == null && this.m_instClassName != null) {
            try {
                this.m_instClass = Class.forName(this.m_instClassName).asSubclass(DBObjectInstance.class);
                assert (DBObjectInstance.class.isAssignableFrom(this.m_instClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_instClass;
    }

    @Override
    public Class<? extends FilterChildProvider> getChildProvider(String string) {
        XmlChildImpl xmlChildImpl = this.getChildTypeImpl(string);
        return xmlChildImpl != null ? xmlChildImpl.getProviderImpl() : null;
    }
}

