/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.model.BaseElement;
import oracle.dbtools.raptor.navigator.model.Catalogs;
import oracle.dbtools.raptor.navigator.model.DBSchemas;
import oracle.dbtools.raptor.navigator.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.xml.XmlCatalogsImpl;
import oracle.dbtools.raptor.navigator.xml.XmlSchemasImpl;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;

public final class QueryFactory
implements NavigatorXmlElements {
    private static final Map<String, QueryFactory> s_factories = new HashMap<String, QueryFactory>();
    private String m_dbType;
    private List<Pair<String, ObjectType>> m_types = new ArrayList<Pair<String, ObjectType>>();
    private List<Pair<String, ObjectCategory>> m_categories = new ArrayList<Pair<String, ObjectCategory>>();
    private XmlSchemasImpl m_schemas;
    private XmlCatalogsImpl m_catalogs;

    public static synchronized QueryFactory getFactory(String string) {
        QueryFactory queryFactory = s_factories.get(string);
        if (queryFactory == null) {
            queryFactory = QueryFactory.createFactory(string);
            s_factories.put(string, queryFactory);
        }
        return queryFactory;
    }

    private static QueryFactory createFactory(String string) {
        return new QueryFactory(string);
    }

    private QueryFactory(String string) {
        this.m_dbType = string;
        Iterator<NavigatorDescriptor> iterator = NavigatorHook.getNavigatorDescriptors();
        while (iterator.hasNext()) {
            NavigatorDescriptor navigatorDescriptor = iterator.next();
            try {
                XmlCatalogsImpl xmlCatalogsImpl;
                XmlSchemasImpl xmlSchemasImpl = navigatorDescriptor.getSchemasDescriptor();
                if (xmlSchemasImpl != null && ModelUtil.areEqual((Object)xmlSchemasImpl.getDBType(), (Object)string)) {
                    this.m_schemas = xmlSchemasImpl;
                }
                if ((xmlCatalogsImpl = navigatorDescriptor.getCatalogsDescriptor()) != null && ModelUtil.areEqual((Object)xmlCatalogsImpl.getDBType(), (Object)string)) {
                    this.m_catalogs = xmlCatalogsImpl;
                }
                for (Pair<String, ObjectType> pair : navigatorDescriptor.getObjectTypes()) {
                    if (!ModelUtil.areEqual((Object)((ObjectType)pair.second).getDBType(), (Object)string)) continue;
                    this.m_types.add(pair);
                }
                for (Pair pair : navigatorDescriptor.getCategories()) {
                    if (!ModelUtil.areEqual((Object)((ObjectCategory)pair.second).getDBType(), (Object)string)) continue;
                    this.m_categories.add((Pair<String, ObjectCategory>)pair);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public ObjectType[] listTypes() {
        int n = 0;
        ObjectType[] objectTypeArray = new ObjectType[this.m_types.size()];
        for (Pair<String, ObjectType> pair : this.m_types) {
            objectTypeArray[n++] = (ObjectType)pair.second;
        }
        return objectTypeArray;
    }

    public ObjectType[] listTypes(String string) {
        int n = 0;
        ObjectType[] objectTypeArray = new ObjectType[this.m_types.size()];
        for (Pair<String, ObjectType> pair : this.m_types) {
            if (!ModelUtil.areEqual((Object)string, (Object)pair.first)) continue;
            objectTypeArray[n++] = (ObjectType)pair.second;
        }
        if (n < objectTypeArray.length) {
            ObjectType[] objectTypeArray2 = objectTypeArray;
            objectTypeArray = new ObjectType[n];
            System.arraycopy(objectTypeArray2, 0, objectTypeArray, 0, n);
        }
        return objectTypeArray;
    }

    public ObjectCategory[] listCategories(String string) {
        int n = 0;
        ObjectCategory[] objectCategoryArray = new ObjectCategory[this.m_types.size()];
        for (Pair<String, ObjectCategory> pair : this.m_categories) {
            if (!ModelUtil.areEqual((Object)string, (Object)pair.first)) continue;
            objectCategoryArray[n++] = (ObjectCategory)pair.second;
        }
        if (n < objectCategoryArray.length) {
            ObjectCategory[] objectCategoryArray2 = objectCategoryArray;
            objectCategoryArray = new ObjectCategory[n];
            System.arraycopy(objectCategoryArray2, 0, objectCategoryArray, 0, n);
        }
        return objectCategoryArray;
    }

    public ObjectType getObjectType(String string) {
        for (Pair<String, ObjectType> pair : this.m_types) {
            ObjectType objectType = (ObjectType)pair.second;
            if (!ModelUtil.areEqual((Object)objectType.getType(), (Object)string)) continue;
            return objectType;
        }
        return null;
    }

    public BaseElement getObjectType(String string, String string2) {
        for (Pair<String, ObjectType> pair : this.m_types) {
            ObjectType objectType = (ObjectType)pair.second;
            if (!ModelUtil.areEqual((Object)pair.first, (Object)string2) || !ModelUtil.areEqual((Object)objectType.getType(), (Object)string)) continue;
            return objectType;
        }
        return null;
    }

    DBSchemas getSchemas() {
        return this.m_schemas;
    }

    Catalogs getCatalogs() {
        return this.m_catalogs;
    }

    public String getType() {
        return null;
    }
}

