/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.model.BaseElement;
import oracle.dbtools.raptor.navigator.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.xml.AbstractObjectType;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.xml.ResourceProvider;
import oracle.dbtools.raptor.navigator.xml.XmlCatalogsImpl;
import oracle.dbtools.raptor.navigator.xml.XmlCategoryType;
import oracle.dbtools.raptor.navigator.xml.XmlConnectionType;
import oracle.dbtools.raptor.navigator.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.navigator.xml.XmlObjectType;
import oracle.dbtools.raptor.navigator.xml.XmlSchemasImpl;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.javatools.util.Pair;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public final class NavigatorDescriptor
implements NavigatorXmlElements,
ResourceProvider {
    private ResourceBundle m_bundle;
    private Map<String, ConnectionType> m_types;
    private List<Pair<String, ObjectType>> m_objectTypes = new ArrayList<Pair<String, ObjectType>>();
    private List<Pair<String, ObjectCategory>> m_categories = new ArrayList<Pair<String, ObjectCategory>>();
    private XmlSchemasImpl m_schemas;
    private XmlCatalogsImpl m_catalogs;

    public NavigatorDescriptor(XMLDocument xMLDocument) {
        Object object;
        String string;
        String string2;
        XMLNode[] xMLNodeArray;
        assert (xMLDocument != null);
        String string3 = XMLHelper.getAttributeNode((Node)XMLHelper.getChildNode((Node)xMLDocument, (String)"navigator"), (String)"RESOURCE_FILE");
        if (xMLDocument != null && string3 == null) {
            string3 = XMLHelper.getAttributeNode((Node)xMLDocument, (String)"RESOURCE_FILE");
        }
        if (string3 != null) {
            this.m_bundle = ResourceBundle.getBundle(string3);
        }
        if ((xMLNodeArray = XMLHelper.getChildNodes((Node)xMLDocument.getFirstChild(), (String)"connection")) != null) {
            this.m_types = new HashMap<String, ConnectionType>();
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                XmlConnectionType xmlConnectionType = new XmlConnectionType(xMLNodeArray[i], this);
                this.m_types.put(xmlConnectionType.getType(), xmlConnectionType);
            }
        } else {
            this.m_types = Collections.emptyMap();
        }
        for (XMLNode xMLNode : XmlNavigatorUtils.getElements("/navigator/objectType", (XMLNode)xMLDocument)) {
            String string4 = XmlNavigatorUtils.getAttributeValue("", "id", xMLNode);
            if (string4 == null) continue;
            string2 = XmlNavigatorUtils.getAttributeValue("", "connType", xMLNode);
            if ("SCHEMAS".equals(string4)) {
                this.m_schemas = new XmlSchemasImpl(string2, this, xMLNode);
                continue;
            }
            if ("CATALOGS".equals(string4)) {
                this.m_catalogs = new XmlCatalogsImpl(string2, this, xMLNode);
                continue;
            }
            string = XmlNavigatorUtils.getAttributeValue("", "category", xMLNode);
            object = this.createObjectType(string2, string4, xMLNode);
            this.m_objectTypes.add((Pair<String, ObjectType>)new Pair((Object)string, object));
        }
        XMLNode[] xMLNodeArray2 = XmlNavigatorUtils.getElements("/navigator/categoryType", (XMLNode)xMLDocument);
        if (xMLNodeArray2 != null) {
            for (XMLNode xMLNode : xMLNodeArray2) {
                string2 = XmlNavigatorUtils.getAttributeValue("", "id", xMLNode);
                if (string2 == null) continue;
                string = XmlNavigatorUtils.getAttributeValue("", "connType", xMLNode);
                object = XmlNavigatorUtils.getAttributeValue("", "category", xMLNode);
                this.m_categories.add((Pair<String, ObjectCategory>)new Pair(object, (Object)this.createObjectCategory(string, string2, xMLNode)));
            }
        }
    }

    private BaseElement createObjectType(String string, String string2, XMLNode xMLNode) {
        ObjectType objectType = new XmlObjectType(string, string2, this, xMLNode);
        String string3 = XmlNavigatorUtils.getAttributeValue("", "implementationClass", xMLNode);
        if (string3 != null) {
            try {
                Class<?> clazz = Class.forName(string3);
                assert (AbstractObjectType.class.isAssignableFrom(clazz));
                AbstractObjectType abstractObjectType = (AbstractObjectType)clazz.newInstance();
                abstractObjectType.setDelegate((XmlObjectType)objectType);
                objectType = abstractObjectType;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectType;
    }

    private ObjectCategory createObjectCategory(String string, String string2, XMLNode xMLNode) {
        return new XmlCategoryType(string, string2, this, xMLNode);
    }

    @Override
    public String getResource(String string) {
        try {
            return this.m_bundle != null ? this.m_bundle.getString(string) : string;
        }
        catch (MissingResourceException missingResourceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "No Value for key:" + string);
            return string;
        }
    }

    public Collection<Pair<String, ObjectType>> getObjectTypes() {
        return this.m_objectTypes;
    }

    public Collection<Pair<String, ObjectCategory>> getCategories() {
        return this.m_categories;
    }

    XmlSchemasImpl getSchemasDescriptor() {
        return this.m_schemas;
    }

    XmlCatalogsImpl getCatalogsDescriptor() {
        return this.m_catalogs;
    }

    public ConnectionType getConnectionType(String string) {
        return this.m_types.get(string);
    }

    public Iterator<ConnectionType> getConnectionTypes() {
        return this.m_types.values().iterator();
    }
}

