/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlArguments;
import oracle.dbtools.util.Service;

public class PlsqlStructureParser {
    public Set<Member> children = null;
    static final SqlEarley parser = SqlEarley.getInstance();
    static final int basic_decl_item = parser.getSymbol("basic_decl_item");
    static final int full_cursor_body = parser.getSymbol("full_cursor_body");
    static final int basic_d = parser.getSymbol("basic_d");
    static final int cursor_d = parser.getSymbol("cursor_d");
    static final int TYPE = parser.getSymbol("'TYPE'");
    static final int SUBTYPE = parser.getSymbol("'SUBTYPE'");
    static final int EXCEPTION = parser.getSymbol("'EXCEPTION'");
    static final int CURSOR = parser.getSymbol("'CURSOR'");
    static final int identifier = parser.getSymbol("identifier");
    static final int decl_id = parser.getSymbol("decl_id");
    static final int object_d_rhs = parser.getSymbol("object_d_rhs");

    public void parse(List<LexerToken> list, Comparator<Member> comparator) {
        this.children = new TreeSet<Member>(comparator);
        LazyNode lazyNode = StackParser.parse(list);
        for (ParseNode parseNode : lazyNode.descendants()) {
            int n;
            if (!(parseNode instanceof LazyNode) || this.containingMemberExists(parseNode.from, parseNode.to)) continue;
            LazyNode lazyNode2 = (LazyNode)parseNode;
            String string = null;
            if ("procedure".equalsIgnoreCase(lazyNode2.startToken)) {
                string = "PROCEDURE";
            } else {
                if (!"function".equalsIgnoreCase(lazyNode2.startToken)) continue;
                string = "FUNCTION";
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n = parseNode.from; i < parseNode.to && !"IS".equalsIgnoreCase(list.get((int)i).content) && !"AS".equalsIgnoreCase(list.get((int)i).content); ++i) {
                stringBuffer.append(list.get((int)i).content + " ");
                if (")".equals(list.get((int)i).content) && (i + 1 >= list.size() || !"return".equalsIgnoreCase(list.get((int)(i + 1)).content)) || ";".equals(list.get((int)i).content)) break;
            }
            Member member = new Member(list.get((int)(n + 1)).content, string, list.get((int)(n + 1)).begin, stringBuffer.toString());
            member.from = n;
            member.to = parseNode.to;
            member.overload = this.getOverload(member);
            this.children.add(member);
        }
        this.parseDataObjects(list);
    }

    private boolean containingMemberExists(int n, int n2) {
        for (Member member : this.children) {
            if (member.from > n || n2 > member.to) continue;
            return true;
        }
        return false;
    }

    public void parseDataObjects(List<LexerToken> list) {
        int n = -1;
        for (LexerToken lexerToken : list) {
            if (this.containingMemberExists(++n, n + 1) || !";".equals(lexerToken.content) || n == list.size() - 1) continue;
            int n2 = 0;
            for (Member member : this.children) {
                if (n <= member.from || n2 >= member.to) continue;
                n2 = member.to;
            }
            ArrayList arrayList = new ArrayList();
            int n3 = 0;
            if (!"CREATE".equalsIgnoreCase(list.get((int)n2).content)) {
                arrayList.add(new LexerToken((CharSequence)"CREATE", -1, -1, Token.IDENTIFIER));
                ++n3;
                arrayList.add(new LexerToken((CharSequence)"PACKAGE", -1, -1, Token.IDENTIFIER));
                ++n3;
                arrayList.add(new LexerToken((CharSequence)"DUM", -1, -1, Token.IDENTIFIER));
                ++n3;
                arrayList.add(new LexerToken((CharSequence)"AS", -1, -1, Token.IDENTIFIER));
                ++n3;
            }
            for (int i = n2; i < list.size(); ++i) {
                arrayList.add(list.get(i));
                if (";".equals(list.get((int)i).content)) break;
            }
            SqlEarley sqlEarley = SqlEarley.getInstance();
            Matrix matrix = new Matrix((Parser)sqlEarley);
            sqlEarley.parse((List)arrayList, matrix);
            ParseNode parseNode = sqlEarley.forest((List)arrayList, matrix);
            ParseNode parseNode2 = this.getBasicDeclItem(parseNode);
            if (parseNode2 == null) {
                return;
            }
            Member member = this.generateMember(parseNode2, arrayList);
            if (member == null) continue;
            member.from = n2 + parseNode2.from - n3;
            member.to = n2 + parseNode2.to - n3;
            this.children.add(member);
        }
    }

    private ParseNode getBasicDeclItem(ParseNode parseNode) {
        if (parseNode.contains(basic_decl_item) || parseNode.contains(full_cursor_body)) {
            return parseNode;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!parseNode2.contains(basic_decl_item) && !parseNode2.contains(full_cursor_body)) continue;
            return parseNode2;
        }
        return null;
    }

    private Member generateMember(ParseNode parseNode, List<LexerToken> list) {
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!parseNode2.contains(basic_d) && !parseNode2.contains(cursor_d)) continue;
            String string = null;
            String string2 = null;
            int n = 0;
            for (ParseNode parseNode3 : parseNode2.children()) {
                if (parseNode3.contains(TYPE) || parseNode3.contains(SUBTYPE)) {
                    string = "TYPE";
                    continue;
                }
                if (parseNode3.contains(CURSOR)) {
                    string = "CURSOR";
                    continue;
                }
                if (string != null && parseNode3.contains(identifier) || parseNode3.contains(decl_id)) {
                    string2 = parseNode3.content(list);
                    n = list.get((int)parseNode3.from).begin;
                    continue;
                }
                if (string2 == null || !parseNode3.contains(object_d_rhs) && !parseNode3.contains(EXCEPTION)) continue;
                String string3 = list.get((int)parseNode3.from).content.toUpperCase();
                if ("CONSTANT".equals(string3)) {
                    string = list.get((int)(parseNode3.from + 1)).content.toUpperCase();
                    continue;
                }
                string = string3;
            }
            if (string == null || string2 == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = parseNode.from; i <= parseNode.from + 20 && i < parseNode.to; ++i) {
                stringBuffer.append(list.get((int)i).content + " ");
            }
            return new Member(string2, string, n, stringBuffer.toString());
        }
        return null;
    }

    private Integer getOverload(Member member) {
        int n = 0;
        int n2 = 0;
        for (Member member2 : this.children) {
            if (!member2.name.equals(member.name) || !member2.type.equals(member.type)) continue;
            ++n2;
            if (member2.codeOffset > member.codeOffset) continue;
            ++n;
        }
        if (n2 == 1) {
            return null;
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(StackParser.class, (String)"test.sql");
        long l = System.currentTimeMillis();
        List list = LexerToken.parse((String)string, (boolean)false);
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = Runtime.getRuntime().freeMemory();
        PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
        long l4 = System.currentTimeMillis();
        plsqlStructureParser.parse(list, PlSqlArguments.sort);
        for (Member member : plsqlStructureParser.children) {
            System.out.println(member);
        }
        long l5 = System.currentTimeMillis();
        System.out.println("Process time = " + (l5 - l4));
        l2 = Runtime.getRuntime().totalMemory();
        l3 = Runtime.getRuntime().freeMemory();
    }
}

