/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.compiler.OraSubmitResults;
import oracle.dbtools.raptor.compiler.PlSqlErrorInfo;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.plsql.OraPls;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Node;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;

public final class PlSqlTranslator {
    private Translator.Log _log = null;

    public void setLog(Translator.Log log) {
        this._log = log;
    }

    public List<PlSqlErrorInfo> translate(PlSqlNode plSqlNode) {
        ArrayList<PlSqlErrorInfo> arrayList = new ArrayList<PlSqlErrorInfo>();
        try {
            String string = plSqlNode.getConnectionName();
            Connection connection = Connections.getInstance().getConnection(string, true);
            OraPls oraPls = new OraPls(connection);
            String string2 = plSqlNode.getOwner();
            String string3 = plSqlNode.getSource();
            OraSubmitResults oraSubmitResults = oraPls.plsSubmit(string2, string3);
            List list = oraSubmitResults.getErrorList();
            arrayList.addAll(list);
            if (null != list) {
                IdeStorage ideStorage = new IdeStorage((Node)plSqlNode);
                ideStorage.setProperty("PlSqlCompilerPage.URL", (Object)plSqlNode.getURL());
                for (PlSqlErrorInfo plSqlErrorInfo : list) {
                    if (plSqlErrorInfo.isWarning()) {
                        this._log.warning((Storage)ideStorage, plSqlErrorInfo.getLineNumber(), plSqlErrorInfo.getColumn(), 0, plSqlErrorInfo.getErrorMessage());
                        continue;
                    }
                    this._log.error((Storage)ideStorage, plSqlErrorInfo.getLineNumber(), plSqlErrorInfo.getColumn(), 0, plSqlErrorInfo.getErrorMessage());
                }
                if (list.size() == 20) {
                    this._log.warning((Storage)ideStorage, 1, 1, 0, DatabaseNavigatorResources.getString("PLSQL_TRANSLATOR_MSGS_EXCEEDED"));
                }
            }
            if (!oraSubmitResults.isSubmitFailed()) {
                plSqlNode.markDirty(false);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }
}

