/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.compiler.PlSqlErrorInfo;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ViewerOpener;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.NavWindow;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlArguments;
import oracle.dbtools.raptor.navigator.plsql.PlSqlCompilerPage;
import oracle.dbtools.raptor.navigator.plsql.PlSqlTranslator;
import oracle.dbtools.raptor.navigator.plsql.PlsqlStructureParser;
import oracle.dbtools.raptor.navigator.plsql.Project;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.plsql.PLSQLAddin;
import oracle.dbtools.raptor.runner.ArgusHelper;
import oracle.dbtools.raptor.runner.DBSourceFinder;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.compiler.Compiler;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.log.LogPage;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.Debugger;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;

public class PlSqlNode
extends RunnableSourceNode
implements DBObjectPlSqlNode,
Comparable<PlSqlNode>,
EquippedWithParser {
    private List<Member> members = new LinkedList<Member>();
    private BackgroundParser parser = new BackgroundParser();
    private String m_parsedOwner = null;
    private String m_parsedType = null;
    private String m_parsedName = null;
    public boolean invokedFromToolbar = false;
    private LinkedList<Observer> listeners = new LinkedList();
    private boolean readOnly = false;
    private Boolean queryDba = null;
    private static ViewerOpener viewerOpener;

    public PlSqlNode() {
        Attributes attributes = this.getAttributes();
        attributes.unset(ElementAttributes.RENAMEABLE);
        attributes.set(ElementAttributes.SAVEABLE_AS);
    }

    protected void openImpl() throws IOException {
        Ide.getMainWindow().setCursor(new Cursor(3));
        this.m_name = null;
        this.m_cName = null;
        this.m_type = null;
        this.m_schema = null;
        this.parseURL();
        super.openImpl();
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig.getBoolean("AUTOPINPLSQLEDITORS").booleanValue() && !this.getURL().getFile().contains("anon_block")) {
            PLSQLAddin.pin((Node)this);
        }
        this.readOnly = DBConfig.getInstance().getBoolean("READONLYSQLEDITORS");
        Ide.getMainWindow().setCursor(new Cursor(0));
    }

    protected void closeImpl() throws IOException {
        try {
            super.closeImpl();
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
        PLSQLAddin.unpin((Node)this);
        LogPage logPage = PlSqlCompilerPage.getErrorLog();
        logPage.clearAll();
    }

    public boolean mayHaveChildren() {
        return DBURLFormatHelper.isDBURL(this.getURL());
    }

    public Icon getIcon() {
        Icon icon = null;
        if (this.m_node != null && this.m_node.getObjectFactory() != null) {
            ConnectionTypeDetails connectionTypeDetails = this.m_node.getObjectFactory().getConnectionTypeDescriptor().getImpl();
            icon = connectionTypeDetails.getIcon(this.m_node);
        }
        if (icon == null && DBURLFormatHelper.isDBURL(this.getURL()) && this.getNodeInstance() != null && !"BLOCK".equals(this.m_type) && this.getNodeInstance().getDescriptor() != null) {
            icon = this.getNodeInstance().getDescriptor().getIcon();
        } else if (icon == null) {
            icon = super.getIcon();
        }
        return icon;
    }

    public boolean isBody() {
        URL uRL = this.getURL();
        String string = DBURLFormatHelper.getBaseType(uRL);
        return string != null && string.contains("BODY");
    }

    public String getPackage(oracle.ide.model.Project project) {
        CharSequence charSequence;
        URL uRL = this.getURL();
        String string = DBURLFormatHelper.getBaseType(uRL);
        if (string == null) {
            string = this.getType();
        }
        string = ArgusHelper.getArgusNameForType(string);
        String string2 = DBURLFormatHelper.getSchema(uRL);
        if (string2 == null) {
            string2 = this.getOwner();
        }
        if (string2 == null) {
            try {
                charSequence = this.getConnectionName();
                if (charSequence == null) {
                    Set<String> set = Project.getInstance().getDbURL(uRL.toString());
                    if (set.size() == 1) {
                        for (String string3 : set) {
                            string2 = DBURLFormatHelper.getSchema(new URL(string3));
                        }
                    }
                } else {
                    Database database = Connections.getInstance().getDatabase((String)charSequence, false);
                    string2 = database.getUserName();
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("$Oracle.");
        ((StringBuilder)charSequence).append(string);
        ((StringBuilder)charSequence).append(".");
        ((StringBuilder)charSequence).append(string2);
        return ((StringBuilder)charSequence).toString();
    }

    public String getSourceFile() {
        String string;
        String string2 = (String)this.getProperty("NAME");
        String string3 = string = ModelUtil.hasLength((String)string2) ? string2 : URLFileSystem.getFileName((URL)this.getURL());
        if (string.indexOf(46) >= 0) {
            string = string.substring(0, string.indexOf(46));
        }
        return string + ".pls";
    }

    public String getType() {
        if (this.m_parsedType == null) {
            this.parseNameTypeOwner();
        }
        return this.m_parsedType;
    }

    public String getName() {
        if (this.m_parsedName == null) {
            this.parseNameTypeOwner();
        }
        return this.m_parsedName;
    }

    public String getOwner() {
        if (this.m_schema != null) {
            return this.m_schema;
        }
        if (this.m_parsedOwner == null) {
            this.parseNameTypeOwner();
        }
        return this.m_parsedOwner;
    }

    public URL matchingDbUrl() {
        String string = this.getName();
        String string2 = this.getType();
        String string3 = this.getOwner();
        if (string3 == null) {
            try {
                Database database = Connections.getInstance().getDatabase(this.getConnectionName(), true);
                string3 = database.getUserName();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", this.getConnectionName(), null, string3, string2), string);
    }

    protected void saveImpl() throws IOException {
        String string;
        String string2;
        URL uRL = this.getURL();
        if (!DBURLFormatHelper.isDBURL(uRL)) {
            if (!this.validated(uRL)) {
                if (MessageDialog.confirm(null, (Object)"File pathname has changed, reload?", (String)"", null)) {
                    this.close();
                }
                return;
            }
            super.saveImpl();
            if (!this.invokedFromToolbar) {
                return;
            }
        }
        this.invokedFromToolbar = false;
        String string3 = this.getConnectionName();
        if (string3 == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DatabaseNavigatorResources.getString("PLSQLNODE_CONN_SELECT_PROMPT"), null, null);
            return;
        }
        this.parseNameTypeOwner();
        if (this.m_parsedOwner == null) {
            if (this.getOwner() != null) {
                this.m_parsedOwner = this.getOwner();
            } else {
                try {
                    string2 = Connections.getInstance().getDatabase(string3, true);
                    this.m_parsedOwner = string2.getUserName();
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
        this.setProperty("SCHEMA", this.m_parsedOwner);
        string2 = this.m_parsedOwner;
        if (string2 != null) {
            int n = string2.length();
            if (string2.charAt(0) == '\"' && n > 1 && string2.charAt(n - 1) == '\"') {
                string2 = Service.addDoubleQuote((String)string2.substring(1, n - 1));
            }
        }
        if ((string = this.m_parsedName) == null) {
            string = this.m_name;
            this.m_parsedName = this.m_name;
        }
        if (this.m_parsedType == null) {
            this.m_parsedType = this.m_type;
        }
        URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", string3, null, string2, this.m_parsedType), string);
        Debugger debugger = Debugger.getDebugger();
        if (debugger.isDebugging()) {
            throw new IOException(ConnectionArb.getString((String)"ERROR_SAVING_WHILE_DEBUGGING"));
        }
        TextBuffer textBuffer = this.getTextBufferDirectly();
        if (textBuffer != null) {
            textBuffer.clearModified();
        }
        Compiler compiler = Compiler.getCompiler();
        PlSqlTranslator plSqlTranslator = new PlSqlTranslator();
        IdeStorage ideStorage = new IdeStorage((Node)this);
        ideStorage.setProperty("PlSqlCompilerPage.URL", (Object)uRL2);
        IdeLog ideLog = new IdeLog();
        LogPage logPage = PlSqlCompilerPage.getErrorLog();
        logPage.clearAll();
        ideLog.registerAsynchronousLogPage(logPage);
        ideLog.setProject(NavWindow.getProject(string3));
        ideLog.setWorkspace(NavWindow.getWorkspace());
        ideLog.clear((Storage)ideStorage);
        plSqlTranslator.setLog((Translator.Log)ideLog);
        List<PlSqlErrorInfo> list = plSqlTranslator.translate(this);
        this.setProperty("INVALID", "false");
        boolean bl = false;
        boolean bl2 = false;
        for (PlSqlErrorInfo object : list) {
            if (!object.isWarning() && !object.getErrorMessage().startsWith("ORA-02303: can't")) {
                this.setProperty("INVALID", "true");
                bl2 = true;
                continue;
            }
            bl = true;
        }
        this.setProperty("PLSQL_DEBUG", DBConfig.getInstance().getInt("PLSQLOPTIMLEVEL") < 2 ? "true" : "false");
        plSqlTranslator.setLog(null);
        ideLog.completed();
        ideLog.unregisterAsynchronousLogPage(logPage);
        String string4 = bl2 && bl ? "PLSQLNODE_ERRORS_AND_WARNINGS" : (bl2 ? "PLSQLNODE_ERRORS" : (bl ? "PLSQLNODE_WARNINGS" : "PLSQLNODE_COMPILED"));
        compiler.getOutputLog().log((Object)DatabaseNavigatorResources.format(string4, this.getShortLabel()));
        DatabaseOverlayClient.updateOverlay(this);
        this.setURL(uRL2);
        if (DBURLFormatHelper.isDBURL(uRL)) {
            if (!uRL2.equals(uRL)) {
                UpdateMessage.fireObjectRenamed((Subject)this);
            }
            this.updateNavigator();
            for (Observer observer : this.listeners) {
                observer.update((Object)this, null);
            }
            return;
        }
        if (!bl2) {
            Project.getInstance().save(uRL.toString(), uRL2.toString());
        }
        this.setURL(uRL);
        this.updateNavigator();
        DBSourceFinder.resetWarning(this);
        for (Observer observer : this.listeners) {
            observer.update((Object)this, null);
        }
    }

    private void updateNavigator() {
        UpdateMessage.fireStructureChanged((Subject)this);
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay((Element)this);
            iconOverlayTracker.repaintOverlays();
        }
    }

    public void parseNameTypeOwner() {
        String string;
        this.m_parsedName = null;
        this.m_parsedType = null;
        this.m_parsedOwner = null;
        List list = this.parser.src;
        if (list == null) {
            if (this.parser.text == null) {
                return;
            }
            string = this.parser.text.length() > 10000 ? this.parser.text.substring(0, 10000) : this.parser.text;
            list = LexerToken.parse((String)string);
        }
        string = null;
        for (int i = 0; i < list.size() && i < 10; ++i) {
            LexerToken lexerToken = list.get(i);
            if ("(".equalsIgnoreCase(lexerToken.content) || "RETURN".equalsIgnoreCase(lexerToken.content) || "IS".equalsIgnoreCase(lexerToken.content) || "AS".equalsIgnoreCase(lexerToken.content) || "BEFORE".equalsIgnoreCase(lexerToken.content) || "AFTER".equalsIgnoreCase(lexerToken.content)) break;
            if (string == null && "PACKAGE".equalsIgnoreCase(lexerToken.content)) {
                string = lexerToken.content.toUpperCase();
                continue;
            }
            if (string == null && "PROCEDURE".equalsIgnoreCase(lexerToken.content)) {
                string = lexerToken.content.toUpperCase();
                continue;
            }
            if (string == null && "FUNCTION".equalsIgnoreCase(lexerToken.content)) {
                string = lexerToken.content.toUpperCase();
                continue;
            }
            if (string == null && "TRIGGER".equalsIgnoreCase(lexerToken.content)) {
                string = lexerToken.content.toUpperCase();
                continue;
            }
            if (string == null && "TYPE".equalsIgnoreCase(lexerToken.content)) {
                string = lexerToken.content.toUpperCase();
                continue;
            }
            if (string != null && "BODY".equalsIgnoreCase(lexerToken.content)) {
                string = string + " " + lexerToken.content.toUpperCase();
                continue;
            }
            if (string != null && !"BODY".equalsIgnoreCase(lexerToken.content) && this.m_parsedName == null) {
                this.m_parsedName = lexerToken.content;
                if (this.m_parsedName == null) continue;
                if (this.m_parsedName.startsWith("\"") && this.m_parsedName.endsWith("\"")) {
                    this.m_parsedName = this.m_parsedName.substring(1, this.m_parsedName.length() - 1);
                    continue;
                }
                this.m_parsedName = this.m_parsedName.toUpperCase();
                continue;
            }
            if (!".".equalsIgnoreCase(lexerToken.content)) continue;
            this.m_parsedOwner = this.m_parsedName;
            this.m_parsedName = null;
        }
        if (this.m_parsedType == null) {
            this.m_parsedType = string;
        }
    }

    public void addListener(Observer observer) {
        if (!this.listeners.contains(observer)) {
            this.listeners.add(observer);
        }
    }

    public void removeListener(Observer observer) {
        this.listeners.remove(observer);
    }

    public void initMembers() {
        if (this.members.size() == 0) {
            this.parseMembers();
        }
    }

    public List<Member> parseMembers() {
        TextBuffer textBuffer = this.acquireTextBuffer();
        String string = textBuffer.getString(0, textBuffer.getLength());
        this.releaseTextBuffer();
        List list = LexerToken.parse((String)string, (boolean)false);
        this.members.clear();
        this.members.addAll(this.parseMembers(list));
        return this.members;
    }

    private List<Member> parseMembers(List<LexerToken> list) {
        PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
        plsqlStructureParser.parse(list, PlSqlArguments.sort);
        LinkedList<Member> linkedList = new LinkedList<Member>();
        linkedList.addAll(plsqlStructureParser.children);
        if (this.isBody()) {
            URL uRL = this.getURL();
            String string = DBURLFormatHelper.getBaseType(uRL);
            URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), string.substring(0, string.indexOf(32))), DBURLFormatHelper.getName(uRL));
            PlSqlNode plSqlNode = (PlSqlNode)DatabaseNavigatorElementFactory.getObjectNode(uRL2);
            if (plSqlNode.members.size() == 0) {
                plSqlNode.parseMembers();
            }
            for (Member member : linkedList) {
                if (!"FUNCTION".equals(member.type) && !"PROCEDURE".equals(member.type)) continue;
                boolean bl = false;
                for (Member member2 : plSqlNode.members) {
                    if (!"FUNCTION".equals(member2.type) && !"PROCEDURE".equals(member2.type) || !member2.name.equalsIgnoreCase(member.name)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                member.isPrivate = true;
            }
        }
        return linkedList;
    }

    public void addMembersTo(Collection<Member> collection) {
        if (this.members.size() == 0) {
            this.parseMembers();
        }
        for (Member member : this.members) {
            collection.add(member);
        }
    }

    public Member getMember(String string) {
        for (Member member : this.members) {
            if (!Service.handleMixedCase((String)member.name).equals(Service.handleMixedCase((String)string))) continue;
            return member;
        }
        return null;
    }

    @Override
    public final String getSource() {
        String string = super.getSource().trim();
        if (!DBURLFormatHelper.isDBURL(this.getURL())) {
            string = this.trimRemErrorsSlash(string);
        }
        return string;
    }

    private String trimRemErrorsSlash(String string) {
        int n = 0;
        int n2 = string.length();
        List list = LexerToken.parse((String)string, (boolean)true);
        LexerToken lexerToken = null;
        LexerToken lexerToken2 = null;
        for (LexerToken lexerToken3 : list) {
            if (lexerToken != null && lexerToken.type == Token.LINE_COMMENT && lexerToken.content.toLowerCase().startsWith("rem")) {
                n = lexerToken3.begin;
                lexerToken = lexerToken3;
                lexerToken2 = lexerToken3;
                continue;
            }
            if (lexerToken3.content.equalsIgnoreCase("errors") && lexerToken != null && lexerToken.content.equalsIgnoreCase("show")) {
                n2 = lexerToken.begin;
                break;
            }
            if (lexerToken3.type != Token.WS) {
                lexerToken = lexerToken3;
            }
            if (lexerToken3.type == Token.WS || lexerToken3.type == Token.LINE_COMMENT || lexerToken3.type == Token.COMMENT || lexerToken3.content.equalsIgnoreCase("show")) continue;
            lexerToken2 = lexerToken3;
        }
        if (lexerToken2 != null && lexerToken2.content == "/") {
            n2 = lexerToken2.begin;
        }
        return string.substring(n, n2);
    }

    public static int offset(String string, String string2) {
        List list = LexerToken.parse((String)string, (boolean)true);
        int n = -1;
        for (LexerToken lexerToken : list) {
            if (!"procedure".equalsIgnoreCase(lexerToken.content) && !"function".equalsIgnoreCase(lexerToken.content) && !"package".equalsIgnoreCase(lexerToken.content) && !"type".equalsIgnoreCase(lexerToken.content) && (!"trigger".equalsIgnoreCase(string2) || !"begin".equalsIgnoreCase(lexerToken.content) && !"declare".equalsIgnoreCase(lexerToken.content))) continue;
            n = lexerToken.begin;
            break;
        }
        if (n == -1) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if ('\n' != string.charAt(i)) continue;
            ++n2;
        }
        return n2;
    }

    public int offset(String string) {
        return PlSqlNode.offset(this.parser.text, string);
    }

    @Override
    public Object getProperty(String string) {
        return "SHORT_NAME".equals(string) && "BLOCK".equals(this.m_type) ? "ANONYMOUS_BLOCK" : super.getProperty(string);
    }

    @Override
    public String getShortLabel() {
        String string = super.getShortLabel();
        return this.isBody() ? string + " Body" : string;
    }

    @Override
    public int compareTo(PlSqlNode plSqlNode) {
        return this.getURL().toString().compareTo(plSqlNode.getURL().toString());
    }

    @Override
    public BackgroundParser getParser() {
        return this.parser;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void toggleReadOnly() {
        this.readOnly = !this.readOnly;
    }

    public boolean dictionarySupported() {
        return true;
    }

    public boolean hasBody() {
        boolean bl = false;
        if (this.canHaveBody()) {
            String string;
            String string2 = this.getConnectionName();
            DBUtil dBUtil = DBUtil.getInstance((String)string2);
            if (this.queryDba == null) {
                this.queryDba = "0".equals(dBUtil.executeReturnOneCol("SELECT count(*) FROM SYS.DBA_OBJECTS where 1=0"));
            }
            if ((string = (String)this.getProperty("BODY_TYPE")) == null) {
                string = "PACKAGE BODY";
            }
            String string3 = "SELECT 1 FROM SYS." + (this.queryDba == true ? "DBA_OBJECTS" : "ALL_OBJECTS") + "\n WHERE OWNER = :SCHEMA AND OBJECT_TYPE = '" + string + "' and object_name = :NAME";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("SCHEMA", this.getOwner());
            hashMap.put("NAME", this.getName());
            bl = "1".equals(dBUtil.executeReturnOneCol(string3, hashMap));
        }
        return bl;
    }

    public boolean canHaveBody() {
        return Boolean.parseBoolean((String)this.getProperty("BODY_ALLOWED"));
    }

    public static void registerViewerOpener(ViewerOpener viewerOpener) {
        PlSqlNode.viewerOpener = viewerOpener;
    }

    private boolean validated(URL uRL) {
        String string = URLFileSystem.getPath((URL)uRL);
        return new File(string).exists();
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() != UpdateMessage.OBJECT_CLOSED) {
            super.notifyObservers(object, updateMessage);
        }
    }

    @Override
    protected String getTypeImpl() {
        String string = this.getType();
        if (string == null) {
            string = super.getTypeImpl();
        }
        return string;
    }

    static {
        CodeEditor.registerNodeType(PlSqlNode.class, (String)CodeEditor.TYPE_PLSQL);
    }
}

