/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.BinaryObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class DBURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static ObjectQueries s_queries;
    private static Set<String> SOURCE_TYPE;

    @Override
    public URLStreamHandler createURLStreamHandler(String string) {
        return string.startsWith("sqldev.nav") ? new DBURLStreamHandler() : null;
    }

    private static synchronized Query getQuery(String string) {
        if (s_queries == null) {
            DBURLStreamHandlerFactory.initQueries();
        }
        return s_queries.getQuery(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initQueries() {
        URL uRL;
        if (s_queries == null && (uRL = DBURLStreamHandlerFactory.class.getResource("source.xml")) != null) {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                dOMParser.parse(inputStream);
                XMLDocument xMLDocument = dOMParser.getDocument();
                Node node = XMLHelper.getChildNode((Node)xMLDocument, (String)"/source");
                if (node != null) {
                    s_queries = new ObjectQueries((XMLNode)XMLHelper.getChildNode((Node)node, (String)"queries"));
                }
            }
            catch (Exception exception) {
                Logger.getLogger(DBURLStreamHandlerFactory.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    static boolean isOracleSource(URL uRL) {
        return Connections.getInstance().isOracle(DBURLFormatHelper.getConnectionName(uRL)) && SOURCE_TYPE.contains(DBURLFormatHelper.getBaseType(uRL));
    }

    static boolean isOracleTimesTenSource(URL uRL) {
        return Connections.getInstance().isTimesTen(DBURLFormatHelper.getConnectionName(uRL)) && SOURCE_TYPE.contains(DBURLFormatHelper.getBaseType(uRL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static char[] fetchSource(URL uRL) {
        String string = DBURLFormatHelper.getConnectionName(uRL);
        String string2 = DBURLFormatHelper.getSchema(uRL);
        String string3 = DBURLFormatHelper.getName(uRL);
        Query query = DBURLStreamHandlerFactory.getQuery(string);
        assert (query != null);
        if (query == null) {
            return new char[0];
        }
        String string4 = DBURLFormatHelper.getBaseType(uRL);
        if (string4.equals("EDITION_TRIGGER")) {
            string4 = "TRIGGER";
        }
        StringBuffer stringBuffer = new StringBuffer("create or replace \n");
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TYPE", string4);
        hashMap.put("OWNER", string2);
        hashMap.put("NAME", string3);
        try {
            if (!Connections.getInstance().lock(string)) {
                char[] cArray = stringBuffer.toString().toCharArray();
                return cArray;
            }
            DBUtil dBUtil = DBUtil.getInstance((String)string);
            if (dBUtil != null) {
                boolean bl;
                String string5 = query.getSql();
                boolean bl2 = 1 < string5.indexOf("SYS.DBA_SOURCE");
                boolean bl3 = bl = "TRIGGER".equals(string4) && !bl2;
                if (bl) {
                    string5 = "select 'trigger '||description prefix, trigger_body from all_triggers \nwhere /*vacuous bind to match*/:TYPE='TRIGGER' and owner = :OWNER and trigger_name = :NAME";
                }
                if ((resultSetWrapper = dBUtil.executeQuery(string5, hashMap)) != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string6 = resultSet.getString(1);
                        if (bl) {
                            String string7 = resultSet.getString(2);
                            string6 = string6 != null && string6.length() > 0 && Character.isWhitespace(string6.charAt(string6.length() - 1)) || string7 != null && string7.length() > 0 && Character.isWhitespace(string7.charAt(0)) ? string6 + string7 : string6 + " " + string7;
                        }
                        stringBuffer.append(string6);
                    }
                } else {
                    SQLException sQLException = dBUtil.getLastException();
                    if (sQLException != null) {
                        Logger.getLogger(DBURLStreamHandlerFactory.class.getClass().getName()).log(Level.WARNING, sQLException.getLocalizedMessage(), sQLException);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DBURLStreamHandlerFactory.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            Connections.getInstance().unlock(string);
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
        }
        return stringBuffer.toString().toCharArray();
    }

    static {
        SOURCE_TYPE = new HashSet<String>(Arrays.asList("PACKAGE", "PACKAGE BODY", "TYPE", "TYPE BODY", "PROCEDURE", "FUNCTION", "TRIGGER", "EDITION_TRIGGER"));
    }

    private static class DBURLConnection
    extends URLConnection {
        private Database m_db;

        private DBURLConnection(URL uRL) {
            super(uRL);
        }

        @Override
        public void connect() throws IOException {
            if (!this.connected) {
                try {
                    this.m_db = Connections.getInstance().getDatabase(DBURLFormatHelper.getConnectionName(this.url));
                }
                catch (DBException dBException) {
                    throw new IOException(dBException.getLocalizedMessage());
                }
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (!this.connected) {
                this.connect();
            }
            InputStream inputStream = null;
            String string = DBURLFormatHelper.getSchema(this.url);
            String string2 = DBURLFormatHelper.getName(this.url);
            String string3 = DBURLFormatHelper.getBaseType(this.url);
            if (string3.equals("EDITION_TRIGGER")) {
                string3 = "TRIGGER";
            }
            if (DBURLStreamHandlerFactory.isOracleSource(this.url) || DBURLStreamHandlerFactory.isOracleTimesTenSource(this.url)) {
                char[] cArray = DBURLStreamHandlerFactory.fetchSource(this.url);
                if (cArray != null) {
                    String string4 = new String(cArray);
                    inputStream = this.getInputStreamFromString(string4);
                }
            } else {
                String string5 = null;
                if ("PACKAGE".equals(string3) || "TYPE".equals(string3)) {
                    string5 = "Spec";
                } else if ("PACKAGE BODY".equals(string3) || "TYPE BODY".equals(string3)) {
                    string3 = "PACKAGE BODY".equals(string3) ? "PACKAGE" : "TYPE";
                    string5 = "Body";
                }
                try {
                    SchemaObject schemaObject;
                    Schema schema = this.m_db.getSchema(string);
                    String string6 = this.m_db.getDatabaseSource(string3, schema, string2, string5);
                    inputStream = string6 != null ? this.getInputStreamFromString(string6) : ((schemaObject = this.m_db.getObject(string3, schema, string2)) instanceof BinaryObject ? ((BinaryObject)schemaObject).getInputStream() : new ByteArrayInputStream(new byte[0]));
                }
                catch (DBException dBException) {
                    throw new IOException(dBException.getLocalizedMessage());
                }
            }
            return inputStream;
        }

        private InputStream getInputStreamFromString(String string) {
            byte[] byArray;
            try {
                byArray = string.getBytes(IdeUtil.getIdeEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
            return new ByteArrayInputStream(byArray);
        }
    }

    private static class DBURLStreamHandler
    extends URLStreamHandler {
        private DBURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL uRL) throws IOException {
            return new DBURLConnection(uRL);
        }

        @Override
        protected boolean equals(URL uRL, URL uRL2) {
            return ModelUtil.areEqual((Object)this.toExternalForm(uRL), (Object)this.toExternalForm(uRL2));
        }

        @Override
        protected int hashCode(URL uRL) {
            return this.toExternalForm(uRL).hashCode();
        }
    }
}

