/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.navigator.filter.FilterDetails;
import oracle.dbtools.raptor.navigator.filter.FilterEntryPanel;
import oracle.dbtools.raptor.navigator.filter.FilterResources;
import oracle.dbtools.raptor.navigator.xml.FilterArguments;
import oracle.dbtools.raptor.navigator.xml.QueryAttributeInstance;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryParameter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.layout.VerticalFlowLayout;

public class ObjectFilterPanel
extends DefaultTraversablePanel {
    private static final String CMD_ADD = "ADD";
    private static final String CMD_REMOVE = "REMOVE";
    private static final String CMD_UP = "UP";
    private static final String CMD_DOWN = "DOWN";
    private JPanel m_panelButtons = new JPanel();
    private GridBagLayout m_layoutButtons = new GridBagLayout();
    private JButton m_btnAdd = new JButton();
    private JButton m_btnRemove = new JButton();
    private JButton m_btnUp = new JButton();
    private JButton m_btnDown = new JButton();
    private JScrollPane m_scrContent = new JScrollPane();
    private JPanel m_panelAttributes = new JPanel();
    private VerticalFlowLayout m_layoutAttributes = new VerticalFlowLayout();
    private JPanel m_pnlMatch = new JPanel();
    private GridBagLayout m_layMatch = new GridBagLayout();
    private JRadioButton m_radAny = new JRadioButton();
    private JRadioButton m_radAll = new JRadioButton();
    private ButtonGroup m_grpMatch = new ButtonGroup();
    private GridBagLayout m_layMain = new GridBagLayout();
    private L m_listener = new L();
    private String m_defaultAttr;
    private Query m_query;
    private Map<String, QueryParameter> m_attrs = new HashMap<String, QueryParameter>();
    private List<QueryParameter> m_params = new ArrayList<QueryParameter>();
    private List<FilterEntryPanel> m_panels = new ArrayList<FilterEntryPanel>();
    private FilterEntryPanel m_currPanel;
    private JLabel m_lblTop = new JLabel();
    private JCheckBox m_chkSyns = new JCheckBox();
    private JCheckBox m_chkOverrideSchemaFilter = new JCheckBox();
    private FilterDetails m_details;

    public ObjectFilterPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public Component getInitialSelection() {
        return this.m_btnAdd;
    }

    private void init(FilterDetails filterDetails, Query query, FilterArguments filterArguments) {
        QueryAttributeInstance[] queryAttributeInstanceArray;
        Object object2;
        this.m_details = filterDetails != null ? filterDetails : new FilterDetails();
        this.m_query = query;
        List list = this.m_query.getCols();
        for (Object object2 : list) {
            if (!object2.isFilterable()) continue;
            this.m_attrs.put(object2.getName(), (QueryParameter)object2);
            if (!"NAME".equals(object2.getID())) continue;
            this.m_defaultAttr = object2.getName();
        }
        if (this.m_defaultAttr == null) {
            for (Object object2 : list) {
                if (!this.m_attrs.containsKey(object2.getName())) continue;
                this.m_defaultAttr = object2.getName();
                break;
            }
        }
        List list2 = this.m_query.getOptionalBinds();
        object2 = list2.iterator();
        while (object2.hasNext()) {
            queryAttributeInstanceArray = (QueryAttributeInstance[])object2.next();
            if (!queryAttributeInstanceArray.isFilterable()) continue;
            this.m_attrs.put(queryAttributeInstanceArray.getName(), (QueryParameter)queryAttributeInstanceArray);
        }
        this.m_params.addAll(this.m_attrs.values());
        Collections.sort(this.m_params, new Comparator<QueryParameter>(){

            @Override
            public int compare(QueryParameter queryParameter, QueryParameter queryParameter2) {
                return queryParameter.getName().compareTo(queryParameter2.getName());
            }
        });
        boolean bl = false;
        if (filterArguments != null) {
            queryAttributeInstanceArray = filterArguments.getQueryArguments();
            if (queryAttributeInstanceArray != null && queryAttributeInstanceArray.length > 0) {
                for (QueryAttributeInstance queryAttributeInstance : queryAttributeInstanceArray) {
                    this.addRow(queryAttributeInstance);
                }
            }
            bl = filterArguments.isMatchAny();
        }
        if (bl) {
            this.m_radAny.setSelected(true);
        } else {
            this.m_radAll.setSelected(true);
        }
        this.m_chkSyns.setSelected(filterArguments.isIncludeSynonyms());
        this.m_chkSyns.setVisible(filterArguments.isSupportsSynonyms());
        this.m_chkOverrideSchemaFilter.setSelected(filterArguments.isOverrideSchemaFilter());
        this.m_chkOverrideSchemaFilter.setVisible(filterDetails.isSupportsSchemaFilters());
        if (this.m_panels.size() == 0) {
            this.addRow(null);
        }
    }

    private void addRow(QueryAttributeInstance queryAttributeInstance) {
        FilterEntryPanel filterEntryPanel;
        if (queryAttributeInstance == null) {
            filterEntryPanel = this.m_attrs.get(this.m_defaultAttr);
            queryAttributeInstance = new QueryAttributeInstance((QueryParameter)filterEntryPanel);
        }
        filterEntryPanel = new FilterEntryPanel();
        filterEntryPanel.init(this.m_details, queryAttributeInstance, this.m_params);
        this.m_panels.add(filterEntryPanel);
        this.refreshRows();
        filterEntryPanel.getDefaultFocusComponent().requestFocusInWindow();
    }

    Component getInitialFocusComponent() {
        if (this.m_panels.size() > 0) {
            return this.m_panels.get(0).getDefaultFocusComponent();
        }
        return null;
    }

    private void refreshRows() {
        this.m_panelAttributes.removeAll();
        for (FilterEntryPanel filterEntryPanel : this.m_panels) {
            this.m_panelAttributes.add(filterEntryPanel);
        }
        this.m_panelAttributes.updateUI();
    }

    private void updateButtons() {
        if (this.m_currPanel != null) {
            int n = this.m_panels.size();
            this.m_btnRemove.setEnabled(n > 1);
            int n2 = this.m_panels.indexOf(this.m_currPanel);
            this.m_btnUp.setEnabled(n2 > 0);
            this.m_btnDown.setEnabled(n2 < n - 1);
        }
    }

    private void jbInit() throws Exception {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.m_listener);
        this.setLayout(this.m_layMain);
        this.m_panelButtons.setLayout(this.m_layoutButtons);
        this.m_panelButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Dimension dimension = new Dimension(28, 25);
        this.m_btnAdd.setActionCommand(CMD_ADD);
        this.m_btnAdd.addActionListener(this.m_listener);
        this.m_btnAdd.setPreferredSize(dimension);
        this.m_btnAdd.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.m_btnAdd.setToolTipText(FilterResources.getString("TOOLTIP_ADD_CRITERIA"));
        this.m_btnRemove.setActionCommand(CMD_REMOVE);
        this.m_btnRemove.addActionListener(this.m_listener);
        this.m_btnRemove.setPreferredSize(dimension);
        this.m_btnRemove.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.m_btnRemove.setToolTipText(FilterResources.getString("TOOLTIP_REMOVE_CRITERIA"));
        this.m_btnUp.setActionCommand(CMD_UP);
        this.m_btnUp.addActionListener(this.m_listener);
        this.m_btnUp.setPreferredSize(dimension);
        this.m_btnUp.setIcon(ComponentArb.getIcon((int)0));
        this.m_btnUp.setToolTipText(FilterResources.getString("TOOLTIP_MOVE_CRITERIA_UP"));
        this.m_btnDown.setActionCommand(CMD_DOWN);
        this.m_btnDown.addActionListener(this.m_listener);
        this.m_btnDown.setPreferredSize(dimension);
        this.m_btnDown.setIcon(ComponentArb.getIcon((int)1));
        this.m_btnDown.setToolTipText(FilterResources.getString("TOOLTIP_MOVE_CRITERIA_DOWN"));
        this.m_scrContent.setHorizontalScrollBarPolicy(31);
        this.m_panelAttributes.setLayout((LayoutManager)this.m_layoutAttributes);
        this.m_pnlMatch.setLayout(this.m_layMatch);
        this.m_radAny.setText(FilterResources.getString("LABEL_MATCH_ANY"));
        this.m_grpMatch.add(this.m_radAny);
        this.m_radAll.setText(FilterResources.getString("LABEL_MATH_ALL"));
        this.m_lblTop.setText(FilterResources.getString("LABEL_FILTER_INSTRUCTIONS"));
        this.m_chkSyns.setText(FilterResources.getString("LABEL_INCLUDE_SYNS"));
        this.m_chkOverrideSchemaFilter.setText(FilterResources.getString("LABEL_OVERRIDE_FILTER"));
        this.m_grpMatch.add(this.m_radAll);
        this.m_panelButtons.add((Component)this.m_btnAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_panelButtons.add((Component)this.m_btnRemove, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_panelButtons.add((Component)this.m_btnUp, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.m_panelButtons.add((Component)this.m_btnDown, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_panelButtons, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_scrContent.getViewport().add((Component)this.m_panelAttributes, null);
        this.add(this.m_scrContent, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 335, 265));
        this.m_pnlMatch.add((Component)this.m_radAny, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlMatch.add((Component)this.m_radAll, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_pnlMatch.add((Component)this.m_lblTop, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_pnlMatch, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_chkSyns, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_chkOverrideSchemaFilter, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        this.init((FilterDetails)traversableContext.find("FilterAndSortPanel.FILTER_DETAILS_KEY"), (Query)traversableContext.find("FilterCommand.QUERY"), (FilterArguments)traversableContext.find("FilterCommand.ARGS"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        ArrayList<QueryAttributeInstance> arrayList = new ArrayList<QueryAttributeInstance>();
        for (FilterEntryPanel filterEntryPanel : this.m_panels) {
            QueryAttributeInstance queryAttributeInstance = filterEntryPanel.commit();
            if (queryAttributeInstance == null) continue;
            arrayList.add(queryAttributeInstance);
        }
        FilterArguments filterArguments = new FilterArguments();
        filterArguments.setQueryArguments(arrayList.toArray(new QueryAttributeInstance[arrayList.size()]));
        filterArguments.setMatchAny(this.m_radAny.isSelected());
        filterArguments.setIncludeSynonyms(this.m_chkSyns.isSelected());
        filterArguments.setSupportsSynonyms(this.m_chkSyns.isVisible());
        filterArguments.setOverrideSchemaFilter(this.m_chkOverrideSchemaFilter.isSelected());
        traversableContext.put("FilterCommand.ARGS", (Object)filterArguments);
    }

    private class L
    implements ActionListener,
    PropertyChangeListener {
        private L() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (ObjectFilterPanel.CMD_ADD.equals(string)) {
                ObjectFilterPanel.this.addRow(null);
            } else {
                int n = ObjectFilterPanel.this.m_panels.indexOf(ObjectFilterPanel.this.m_currPanel);
                if (ObjectFilterPanel.CMD_REMOVE.equals(string)) {
                    if (ObjectFilterPanel.this.m_panels.remove(ObjectFilterPanel.this.m_currPanel)) {
                        ObjectFilterPanel.this.refreshRows();
                        FilterEntryPanel filterEntryPanel = (FilterEntryPanel)ObjectFilterPanel.this.m_panels.get(n >= ObjectFilterPanel.this.m_panels.size() ? ObjectFilterPanel.this.m_panels.size() - 1 : n);
                        if (filterEntryPanel != null) {
                            filterEntryPanel.getDefaultFocusComponent().requestFocusInWindow();
                        }
                    }
                } else if (ObjectFilterPanel.CMD_UP.equals(string)) {
                    if (n > 0) {
                        ObjectFilterPanel.this.m_panels.remove(n);
                        ObjectFilterPanel.this.m_panels.add(n - 1, ObjectFilterPanel.this.m_currPanel);
                        ObjectFilterPanel.this.refreshRows();
                        ObjectFilterPanel.this.updateButtons();
                    }
                } else if (ObjectFilterPanel.CMD_DOWN.equals(string) && n < ObjectFilterPanel.this.m_panels.size() - 1) {
                    ObjectFilterPanel.this.m_panels.remove(n);
                    ObjectFilterPanel.this.m_panels.add(n + 1, ObjectFilterPanel.this.m_currPanel);
                    ObjectFilterPanel.this.refreshRows();
                    ObjectFilterPanel.this.updateButtons();
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            FilterEntryPanel filterEntryPanel = (FilterEntryPanel)SwingUtilities.getAncestorOfClass(FilterEntryPanel.class, (Component)object);
            if (filterEntryPanel != null && filterEntryPanel != ObjectFilterPanel.this.m_currPanel) {
                ObjectFilterPanel.this.m_currPanel = filterEntryPanel;
                ObjectFilterPanel.this.updateButtons();
            }
        }
    }
}

