/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.config;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.navigator.config.ConfigTraversable;
import oracle.dbtools.raptor.navigator.config.NavigatorSettings;
import oracle.dbtools.raptor.navigator.model.BaseElement;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.xml.QueryFactory;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.checktree.CheckboxTree;
import oracle.javatools.ui.checktree.TriStateNode;
import oracle.javatools.util.ModelUtil;

public class NavigatorSettingsPanel
extends ConfigTraversable {
    private static final Comparator<ConnectionType> C = new Comparator<ConnectionType>(){

        @Override
        public int compare(ConnectionType connectionType, ConnectionType connectionType2) {
            String string = connectionType.getType();
            String string2 = connectionType2.getType();
            return string.compareTo(string2);
        }
    };
    private static final ListCellRenderer R = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ConnectionType connectionType = (ConnectionType)object;
            return super.getListCellRendererComponent((JList<?>)jList, connectionType.getType(), n, bl, bl2);
        }
    };
    private static final Set<String> IGNORE = new HashSet<String>(Arrays.asList("MIGREPO", "MIGREPOC", "Oracle DBA"));
    private JComboBox m_connTypes = new JComboBox();
    private CheckboxTree m_tree = new CheckboxTree();
    private Map<ConnectionType, TreeModel> m_models;

    @Override
    public void onEntry(TraversableContext traversableContext) {
        this.init(NavigatorSettings.getInstance(traversableContext.getPropertyStorage()));
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit(NavigatorSettings.getInstance(traversableContext.getPropertyStorage()));
    }

    private void init(NavigatorSettings navigatorSettings) {
        this.m_models = new HashMap<ConnectionType, TreeModel>();
        SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel();
        sortedComboBoxModel.setComparator(C);
        Iterator<ConnectionType> iterator = NavigatorHook.getConnectionTypes();
        while (iterator.hasNext()) {
            ConnectionType connectionType = iterator.next();
            if (this.ignoreType(connectionType)) continue;
            sortedComboBoxModel.addElement((Object)connectionType);
            String string = connectionType.getType();
            QueryFactory queryFactory = QueryFactory.getFactory(string);
            TriStateNode triStateNode = new TriStateNode((Object)string);
            for (TriStateNode triStateNode2 : this.getNodes(queryFactory, null)) {
                triStateNode.add((MutableTreeNode)triStateNode2);
            }
            this.m_models.put(connectionType, new DefaultTreeModel((TreeNode)triStateNode));
        }
        this.m_connTypes.setModel(sortedComboBoxModel);
    }

    private Collection<TriStateNode> getNodes(QueryFactory queryFactory, String string) {
        ArrayList<TriStateNode> arrayList = new ArrayList<TriStateNode>();
        for (ObjectType baseElement : queryFactory.listTypes(string)) {
            for (DatabaseFolder databaseFolder : baseElement.getFolders()) {
                arrayList.add(new TriStateNode((Object)databaseFolder.getLabel()));
            }
        }
        for (BaseElement baseElement : queryFactory.listCategories(string)) {
            TriStateNode triStateNode = new TriStateNode((Object)baseElement.getLabel());
            for (TriStateNode triStateNode2 : this.getNodes(queryFactory, baseElement.getType())) {
                triStateNode.add((MutableTreeNode)triStateNode2);
            }
            arrayList.add(triStateNode);
        }
        return arrayList;
    }

    private boolean ignoreType(ConnectionType connectionType) {
        return IGNORE.contains(connectionType.getType()) || ModelUtil.hasLength((String)connectionType.getProviderClass());
    }

    private void commit(NavigatorSettings navigatorSettings) throws TraversalException {
    }

    @Override
    protected JPanel createContentPanel() {
        this.m_connTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ConnectionType connectionType = (ConnectionType)itemEvent.getItem();
                    TreeModel treeModel = (TreeModel)NavigatorSettingsPanel.this.m_models.get(connectionType);
                    NavigatorSettingsPanel.this.m_tree.setModel(treeModel);
                }
            }
        });
        this.m_connTypes.setRenderer(R);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_connTypes, (String)"Connection Type");
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)this.m_connTypes, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_tree, (String)"Object Types");
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_tree);
        jPanel.add((Component)jScrollPane, LayoutControl.GBC.gbc(0, 2, 2, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        return jPanel;
    }
}

