/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBTypeOwnerInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.db.ConnectionException;

public abstract class TypeContainerFilter
extends BaseRaptorFilter {
    private Comparator<Object> m_comp;
    private List<Element> m_children;

    protected TypeContainerFilter() {
    }

    public final Iterator<Element> getChildren() {
        if (this.m_children == null) {
            this.m_children = new ArrayList<Element>();
            Element element = this.getOwner() != null ? this.getOwner().getData() : null;
            try {
                this.m_children.addAll(this.loadChildrenImpl());
            }
            catch (IOException iOException) {
                this.cleanupOnError(element);
            }
        }
        return this.m_children.iterator();
    }

    protected void cleanupOnError(final Element element) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (element instanceof Node) {
                    Node node = (Node)element;
                    try {
                        node.close();
                    }
                    catch (Exception exception) {}
                } else if (element instanceof Subject) {
                    UpdateMessage.fireObjectClosed((Subject)((Subject)element));
                }
            }
        });
    }

    protected abstract List<Element> loadChildrenImpl() throws IOException;

    protected final void addChild(Element element) {
        if (this.m_children == null) {
            this.m_children = new ArrayList<Element>();
        }
        this.m_children.add(element);
    }

    protected final void removeChild(Element element) {
        if (this.m_children != null) {
            this.m_children.remove(element);
        }
    }

    protected boolean loadInThread() {
        return false;
    }

    public final void closeChildren() {
        if (this.m_children != null) {
            this.m_children.clear();
            this.m_children = null;
        }
        this.m_comp = null;
        this.clearCache();
    }

    public Comparator<Object> getComparator() {
        if (this.m_comp == null) {
            this.m_comp = new C();
        }
        return this.m_comp;
    }

    protected final List<Element> loadTypeFolders(DBTypeOwnerInstance dBTypeOwnerInstance, String string, String string2, String string3) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        String string4 = this.getURLProtocol();
        if (string4 != null) {
            for (DBFolderInstance dBFolderInstance : dBTypeOwnerInstance.listTypeFolders()) {
                URL uRL = DBURLFormatHelper.getURL(string4, string, string2, string3, dBFolderInstance.getType());
                Element element = this.createTypeFolder(dBFolderInstance, uRL);
                arrayList.add(element);
            }
        }
        return arrayList;
    }

    private Element createTypeFolder(DBFolderInstance dBFolderInstance, URL uRL) {
        return DatabaseNavigatorElementFactory.getTypeFolder(uRL, dBFolderInstance);
    }

    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getAddObjects()) {
            Element element = (Element)e;
            TNode tNode2 = treeExplorer.addChild(element, tNode, treeExplorer.getTreeModel());
            this.cache(tNode2);
            this.addChild(element);
            tNode2.getChildFilter();
        }
        return tNode;
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getRemoveObjects()) {
            Element element = (Element)e;
            TNode tNode2 = this.lookup(element);
            if (tNode2 == null) {
                tNode2 = treeExplorer.searchTNodeBreadthFirst((Element)e, tNode);
            }
            if (tNode2 != null) {
                treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
                this.uncache(tNode2);
            }
            this.removeChild(element);
        }
        return tNode;
    }

    public boolean canRefresh(TNode[] tNodeArray) {
        return super.canRefresh(tNodeArray);
    }

    public boolean canUpdate(TNode tNode, UpdateMessage updateMessage) {
        return super.canUpdate(tNode, updateMessage);
    }

    public void refresh(TNode[] tNodeArray) {
        super.refresh(tNodeArray);
    }

    protected static class ExceptionDialogRunnable
    implements Runnable {
        Throwable m_ex;
        String m_msg;

        public ExceptionDialogRunnable(String string, Throwable throwable) {
            Throwable throwable2;
            while ((throwable instanceof ConnectionException || throwable instanceof DBException) && (throwable2 = throwable.getCause()) instanceof Exception) {
                throwable = throwable2;
            }
            this.m_ex = throwable;
            this.m_msg = string;
        }

        @Override
        public void run() {
            String string = CommonArb.getString("ERROR_CONNECTING");
            Frame frame = IdeUtil.getMainWindow();
            if (this.m_ex instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(null, (Component)frame, (String)string, (SQLException)((SQLException)this.m_ex));
            } else {
                String string2 = this.m_ex instanceof ConnectionException ? MessageFormat.format(this.m_msg, this.m_ex.getLocalizedMessage()) : this.m_ex.getLocalizedMessage();
                ExceptionDialog.showExceptionDialog((Component)frame, (Throwable)this.m_ex, (String)string, (String)string2, null);
            }
        }
    }

    private static class C
    implements Comparator<Object> {
        private C() {
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            return this.compareTNodes((TNode)object, (TNode)object2);
        }

        private int compareTNodes(TNode tNode, TNode tNode2) {
            Element element = tNode.getData();
            Element element2 = tNode2.getData();
            if (element instanceof OtherSchemasFolder) {
                return 1;
            }
            if (element2 instanceof OtherSchemasFolder) {
                return -1;
            }
            int n = Double.compare(this.getWeight(element), this.getWeight(element2));
            if (n != 0) {
                return n;
            }
            return element.getShortLabel().compareTo(element2.getShortLabel());
        }

        private double getWeight(Element element) {
            double d = Double.NaN;
            if (element instanceof ObjectFolder) {
                DBFolderInstance dBFolderInstance = ((ObjectFolder)element).getFolderInstance();
                DatabaseFolder databaseFolder = (DatabaseFolder)dBFolderInstance.getDescriptor();
                d = databaseFolder.getWeight();
            } else if (element instanceof CategoryFolder) {
                CategoryInstance categoryInstance = ((CategoryFolder)element).getCategoryInstance();
                ObjectCategory objectCategory = (ObjectCategory)categoryInstance.getDescriptor();
                d = objectCategory.getWeight();
            }
            return d;
        }
    }
}

