/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.TypeContainerFilter;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class SchemaFilter
extends TypeContainerFilter {
    public DBSchemaInstance getSchemaInstance() {
        SchemaFolder schemaFolder = (SchemaFolder)this.getOwner().getData();
        return schemaFolder.getSchemaInstance();
    }

    @Override
    protected Object getKey(Object object) {
        return null;
    }

    @Override
    protected List<Element> loadChildrenImpl() throws IOException {
        List<Element> list = null;
        final SchemaFolder schemaFolder = (SchemaFolder)this.getOwner().getData();
        try {
            URL uRL = schemaFolder.getURL();
            final String string = DBURLFormatHelper.getConnectionName(uRL);
            final DBSchemaInstance dBSchemaInstance = schemaFolder.getSchemaInstance();
            ObjectFactory objectFactory = dBSchemaInstance.getObjectFactory();
            if (objectFactory != null) {
                String string2;
                String string3 = (String)dBSchemaInstance.getProperty("CATALOG");
                if (string3 == null) {
                    string3 = DBURLFormatHelper.getCatalog(uRL);
                }
                if ((string2 = (String)dBSchemaInstance.getProperty("SCHEMA")) == null) {
                    string2 = DBURLFormatHelper.getSchema(uRL);
                }
                final String string4 = string3;
                final String string5 = string2;
                RaptorTask<List<Element>> raptorTask = new RaptorTask<List<Element>>(DatabaseNavigatorResources.getString("CONNECTION_FILTER_OPEN"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

                    protected List<Element> doWork() throws TaskException {
                        ArrayList<Element> arrayList = new ArrayList<Element>();
                        arrayList.addAll(SchemaFilter.this.loadTypeFolders(dBSchemaInstance, string, string4, string5));
                        String string2 = SchemaFilter.this.getURLProtocol();
                        if (string2 != null) {
                            for (CategoryInstance categoryInstance : dBSchemaInstance.listCategories()) {
                                URL uRL = DBURLFormatHelper.getURL(string2, string, string4, string5, categoryInstance.getDescriptor().getType());
                                arrayList.add(new CategoryFolder(uRL, categoryInstance));
                            }
                        }
                        return arrayList;
                    }

                    protected boolean isCancellable() {
                        return false;
                    }
                };
                raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)raptorTask){
                    final /* synthetic */ RaptorTask val$task;
                    {
                        this.val$task = raptorTask;
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                UpdateMessage.fireChildRemoved((Subject)schemaFolder, (Element)DummyElement.INSTANCE);
                                try {
                                    List list = (List)val$task.getResult();
                                    UpdateMessage.fireChildrenAdded((Subject)schemaFolder, (Collection)list);
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (ExecutionException executionException) {
                                    // empty catch block
                                }
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                list = Collections.singletonList(DummyElement.INSTANCE);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public String getShortLabel() {
        SchemaFolder schemaFolder;
        DBSchemaInstance dBSchemaInstance;
        String string = super.getShortLabel();
        boolean bl = false;
        Element element = this.getOwner().getData();
        if (element != null && element instanceof SchemaFolder && (dBSchemaInstance = (schemaFolder = (SchemaFolder)element).getSchemaInstance()) != null) {
            bl = dBSchemaInstance.isSchemaFiltered();
        }
        return bl ? DatabaseNavigatorResources.format("FILTER_FORMAT", string) : string;
    }
}

