/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.navigator.AbstractDatabaseFilter;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DeferredLoadingFilter;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBContainerInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;

public class OtherSchemasFilter
extends AbstractDatabaseFilter {
    @Override
    protected DeferredLoadingFilter.FilterLoadTask getLoadTask() {
        URL uRL = ((Locatable)this.getOwner().getData()).getURL();
        String string = DBURLFormatHelper.getConnectionName(uRL);
        return new SchemasFilterLoadTask(string);
    }

    @Override
    public DBContainerInstance getFolderInstance() {
        OtherSchemasFolder otherSchemasFolder = (OtherSchemasFolder)this.getOwner().getData();
        return otherSchemasFolder.getDBSchemasInstance();
    }

    public boolean canRefresh(TNode[] tNodeArray) {
        return true;
    }

    @Override
    protected Object getKey(Object object) {
        return object instanceof SchemaFolder ? ((SchemaFolder)object).getURL() : super.getKey(object);
    }

    private class SchemasFilterLoadTask
    extends DeferredLoadingFilter.FilterLoadTask {
        SchemasFilterLoadTask(String string) {
            super(DatabaseNavigatorResources.getString("OTHER_SCHEMAS_LOAD_MSG"), string);
        }

        @Override
        protected List<Element> doWorkImpl() {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            OtherSchemasFolder otherSchemasFolder = (OtherSchemasFolder)OtherSchemasFilter.this.getOwner().getData();
            DBSchemasInstance dBSchemasInstance = otherSchemasFolder.getDBSchemasInstance();
            try {
                this.checkCanProceed();
                String string = OtherSchemasFilter.getURLProtocol((Element)otherSchemasFolder);
                String string2 = otherSchemasFolder.getConnectionName();
                String string3 = (String)dBSchemasInstance.getProperty("ConnectionType");
                for (DBChildInstance dBChildInstance : dBSchemasInstance.listChildren()) {
                    DBSchemaInstance dBSchemaInstance = (DBSchemaInstance)dBChildInstance;
                    SchemaFolder schemaFolder = new SchemaFolder(DBURLFormatHelper.getURL(string, string2, null, (String)dBSchemaInstance.getProperty("SCHEMA"), null), dBSchemaInstance, string3);
                    arrayList.add(schemaFolder);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            catch (AbortException abortException) {
                arrayList.clear();
            }
            catch (ExecutionException executionException) {
                arrayList.clear();
            }
            return arrayList;
        }
    }
}

