/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.DeferredLoadingFilter;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.ChildType;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.FilterChildProvider;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.explorer.TNode;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;

public class ObjectNodeFilter
extends DeferredLoadingFilter {
    private List<FilterChildProvider> m_providers = new ArrayList<FilterChildProvider>();

    public boolean canRefresh(TNode[] tNodeArray) {
        return true;
    }

    @Override
    protected Object getKey(Object object) {
        return object instanceof Locatable ? ((Locatable)object).getURL() : (object != null ? object.toString() : null);
    }

    public Comparator<?> getComparator() {
        return null;
    }

    @Override
    protected DeferredLoadingFilter.FilterLoadTask getLoadTask() {
        URL uRL = ((Locatable)this.getOwner().getData()).getURL();
        String string = DBURLFormatHelper.getConnectionName(uRL);
        return new ObjectNodeFilterLoadTask(string);
    }

    private static final class ChildFolder
    extends DefaultFolder {
        private ChildType m_impl;

        ChildFolder(ChildType childType, List<Element> list) {
            this.m_impl = childType;
            this._children.addAll(list);
        }

        public Icon getIcon() {
            Icon icon = this.m_impl.getFolderIcon();
            return icon != null ? icon : super.getIcon();
        }

        public String getShortLabel() {
            return this.m_impl.getFolderLabel();
        }
    }

    private class ObjectNodeFilterLoadTask
    extends DeferredLoadingFilter.FilterLoadTask {
        private ObjectNodeFilterLoadTask(String string) {
            super("Loading Children", string);
        }

        @Override
        protected List<Element> doWorkImpl() {
            DatabaseNode databaseNode = (DatabaseNode)ObjectNodeFilter.this.getOwner().getData();
            ArrayList<Element> arrayList = new ArrayList<Element>();
            URL uRL = databaseNode.getURL();
            DBObjectInstance dBObjectInstance = databaseNode.getNodeInstance();
            DatabaseObject databaseObject = (DatabaseObject)dBObjectInstance.getDescriptor();
            try {
                for (ChildType childType : databaseObject.getChildTypes()) {
                    Object object;
                    this.checkCanProceed();
                    Class<? extends FilterChildProvider> clazz = databaseObject.getChildProvider(childType.getChildType());
                    List<DBChildInstance> list = null;
                    if (clazz != null) {
                        assert (FilterChildProvider.class.isAssignableFrom(clazz));
                        try {
                            object = clazz.newInstance();
                            ObjectNodeFilter.this.m_providers.add(object);
                            list = object.listChildren(databaseNode, childType.getChildType());
                        }
                        catch (Exception exception) {}
                    } else {
                        list = dBObjectInstance.listChildren(childType.getChildType());
                    }
                    if (list == null) continue;
                    object = new ArrayList();
                    for (DBChildInstance dBChildInstance : list) {
                        this.checkCanProceed();
                        String string = (String)dBChildInstance.getProperty("NAME");
                        if (string == null) continue;
                        object.add(DatabaseNavigatorElementFactory.createChildElement(uRL, childType.getChildType(), dBChildInstance));
                    }
                    if (childType.showAsFolder()) {
                        arrayList.add((Element)new ChildFolder(childType, (List<Element>)object));
                        continue;
                    }
                    arrayList.addAll((Collection<Element>)object);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            catch (AbortException abortException) {
                arrayList.clear();
            }
            catch (ExecutionException executionException) {
                arrayList.clear();
            }
            return arrayList;
        }
    }
}

