/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.navigator.AbstractDatabaseFilter;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DeferredLoadingFilter;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBContainerInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.QueryProgressListener;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;

public class ObjectFilter
extends AbstractDatabaseFilter {
    @Override
    public DBContainerInstance getFolderInstance() {
        ObjectFolder objectFolder;
        DBFolderInstance dBFolderInstance = null;
        TNode tNode = this.getOwner();
        if (tNode != null && (objectFolder = (ObjectFolder)tNode.getData()) != null) {
            dBFolderInstance = objectFolder.getFolderInstance();
        }
        return dBFolderInstance;
    }

    @Override
    protected Object getKey(Object object) {
        return object instanceof ObjectFolder ? ((ObjectFolder)object).getURL() : super.getKey(object);
    }

    public boolean canRefresh(TNode[] tNodeArray) {
        return true;
    }

    @Override
    protected DeferredLoadingFilter.FilterLoadTask getLoadTask() {
        URL uRL = ((Locatable)this.getOwner().getData()).getURL();
        String string = DBURLFormatHelper.getConnectionName(uRL);
        return new ObjectFilterLoadTask(string);
    }

    public String getShortLabel() {
        String string = super.getShortLabel();
        return this.isFiltered() ? DatabaseNavigatorResources.format("FILTER_FORMAT", string) : string;
    }

    private boolean isFiltered() {
        DBContainerInstance dBContainerInstance = this.getFolderInstance();
        return dBContainerInstance != null ? dBContainerInstance.isFiltered() : false;
    }

    public Comparator getComparator() {
        DatabaseFolder databaseFolder;
        DBContainerInstance dBContainerInstance = this.getFolderInstance();
        if (dBContainerInstance != null && (databaseFolder = (DatabaseFolder)dBContainerInstance.getDescriptor()) != null && databaseFolder.ignoreDefaultComparator()) {
            return null;
        }
        return super.getComparator();
    }

    private class ObjectFilterLoadTask
    extends DeferredLoadingFilter.FilterLoadTask {
        ObjectFilterLoadTask(String string) {
            super(DatabaseNavigatorResources.getString("OBJECT_FILTER_LOAD"), string);
        }

        @Override
        protected List<Element> doWorkImpl() {
            QueryProgressListener queryProgressListener = new QueryProgressListener(){

                public void rsClosed() {
                    ObjectFilterLoadTask.this.setMessage(DatabaseNavigatorResources.getString("OBJECT_FILTER_RS_CLOSED"));
                }

                public void rsOpened() {
                }

                public void rsRowFetched() {
                    ObjectFilterLoadTask.this.setMessage(DatabaseNavigatorResources.getString("OBJECT_FILTER_ROW_FETCHED"));
                }
            };
            URL uRL = ((Locatable)ObjectFilter.this.getOwner().getData()).getURL();
            DBContainerInstance dBContainerInstance = ObjectFilter.this.getFolderInstance();
            ArrayList<Element> arrayList = new ArrayList<Element>();
            try {
                this.checkCanProceed();
                for (DBChildInstance dBChildInstance : dBContainerInstance.listChildren(queryProgressListener)) {
                    this.checkCanProceed();
                    DBObjectInstance dBObjectInstance = (DBObjectInstance)dBChildInstance;
                    DatabaseNode databaseNode = DatabaseNavigatorElementFactory.createObjectNode(uRL, dBObjectInstance);
                    if (databaseNode == null) continue;
                    arrayList.add(databaseNode);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            catch (AbortException abortException) {
                arrayList.clear();
            }
            catch (ExecutionException executionException) {
                arrayList.clear();
            }
            return arrayList;
        }
    }
}

