/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.TextNode;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.navigator.NavigatorConstants;
import oracle.jdeveloper.JDeveloperMenuConstants;

class NavigatorMenuListener
implements ContextMenuListener {
    NavigatorMenuListener() {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        IdeAction ideAction;
        Context context = contextMenu.getContext();
        NavigatorConstants.removeNewMenuItem((ContextMenu)contextMenu);
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 0) {
            return;
        }
        boolean bl = elementArray.length > 1;
        Element element = elementArray[0];
        if (element instanceof Databases) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_NEW_CONN), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_IMP_CONN), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_EXP_CONN), 1.0f);
        } else if (!bl && element instanceof DatabaseConnection) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_CONNECT, 1.0f), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_DISCONNECT, 1.1f), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_RECONNECT, 1.1f), 1.0f);
            contextMenu.add((Component)this.createMenu((MenuManager)contextMenu, 20), 1.0f);
            contextMenu.add((Component)this.createMenu((MenuManager)contextMenu, 56), JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_FILTER), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_CLEAR_FILTER), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
        } else if (!bl && element instanceof ObjectFolder) {
            Object object;
            if (!((ObjectFolder)element).getObjectType().equals("TABLESPACE") && (object = DatabaseNavigatorController.getCreateActionProvider().getNewAction(element)) != null) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)object), 1.0f);
                object.updateAction(contextMenu.getContext());
            }
            contextMenu.add((Component)this.createMenu((MenuManager)contextMenu, 51), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            if (!((ObjectFolder)element).getURL().toString().toLowerCase().startsWith("sqldev.migration") && (object = ((ObjectFolder)element).getFolderInstance()).canHaveFilter()) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_FILTER), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_CLEAR_FILTER), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            }
        } else if (!bl && element instanceof CategoryFolder) {
            contextMenu.add((Component)this.createMenu((MenuManager)contextMenu, 51), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
        } else if (element instanceof OtherSchemasFolder) {
            contextMenu.add((Component)this.createMenu((MenuManager)contextMenu, 51), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_FILTER), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_CLEAR_FILTER), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
        } else if (element instanceof SchemaFolder) {
            if (!((SchemaFolder)element).getURL().toString().toLowerCase().startsWith("sqldev.migration")) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_FILTER), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DatabaseNavigatorController.ACTION_CLEAR_FILTER), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            }
        } else if (!bl && (ideAction = DatabaseNavigatorController.getCreateActionProvider().getEditAction(element)) != null) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction, 1.0f), element instanceof TextNode ? 1.0f : MenuConstants.SECTION_EDIT_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        Object object;
        TNode tNode;
        boolean bl = false;
        NavigationPoint navigationPoint = null;
        Element element = context.getElement();
        if (element instanceof ChildObjectElement) {
            tNode = ExplorerContext.getSingleTNode((Context)context);
            if (tNode != null && (object = (DatabaseSourceNode)tNode.getAncestor(DatabaseSourceNode.class, true)) != null) {
                navigationPoint = ((DatabaseSourceNode)object).getNavigationPoint((ChildObjectElement)element);
            }
            bl = true;
        } else if (element instanceof DatabaseSourceNode) {
            tNode = ExplorerContext.getFirstTNode((Context)context);
            object = tNode.getOwner();
            object.expand(tNode, false);
            bl = false;
        }
        if (navigationPoint != null) {
            tNode = NavigationManager.getNavigationManager();
            try {
                if (tNode != null) {
                    tNode.navigateTo(navigationPoint);
                } else {
                    navigationPoint.navigate();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return bl;
    }

    private JMenuItem createMenu(MenuManager menuManager, int n) {
        IdeAction ideAction = IdeAction.find((int)n);
        return ideAction != null ? menuManager.createMenuItem((ToggleAction)ideAction) : null;
    }
}

