/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.awt.Component;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.cloud.navigator.CloudConnections;
import oracle.dbtools.raptor.navigator.BaseNavigatorManager;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.ViewableSelectionComponentProvider;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.util.MnemonicSolver;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class NavWindow
extends DefaultNavigatorWindow
implements ViewableSelectionComponentProvider {
    private static Class<? extends ContextSupport> s_supportClass;
    private static ContextSupport s_ctxSupport;
    private static ContextMenu s_contextMenu;
    private String m_title;
    private Controller m_controller;
    private URL m_lastSaveAsLocation;
    protected Component _gui;

    public static void setContextSupportClass(Class<? extends ContextSupport> clazz) {
        s_supportClass = clazz;
    }

    protected static synchronized ContextMenu getOrCreateContextMenu() {
        if (s_contextMenu == null) {
            s_contextMenu = new ContextMenu(new MnemonicSolver());
            BaseNavigatorManager.populateDatabaseNavigatorContextMenu(s_contextMenu, "db_nav");
        }
        return s_contextMenu;
    }

    protected NavWindow(Context context, String string, String string2) {
        super(context, string);
        this.m_title = string2;
    }

    public String getTitleName() {
        return this.m_title;
    }

    public String getTabName() {
        return this.m_title;
    }

    public ContextMenu getContextMenu() {
        return NavWindow.getOrCreateContextMenu();
    }

    protected Controller createController(Controller controller) {
        return new DatabaseNavigatorController(controller);
    }

    public Controller getController() {
        if (this.m_controller == null) {
            this.m_controller = this.createController(super.getController());
        }
        return this.m_controller;
    }

    @Override
    public Component getViewableSelectionComponent() {
        this.getGUI();
        return this.getTree();
    }

    public Context getContext(EventObject eventObject) {
        String string;
        Context context = super.getContext(eventObject);
        s_ctxSupport.updateContext(context);
        Node node = context.getNode();
        if (node != null && node.getURL() != null && (string = DBURLFormatHelper.getName(node.getURL())) != null) {
            try {
                if (this.m_lastSaveAsLocation == null) {
                    this.m_lastSaveAsLocation = URLFactory.newFileURL((String)System.getProperty("user.home"));
                }
                URL uRL = URLFactory.newURL((URL)this.m_lastSaveAsLocation, (String)(string + ".sql"));
                context.setProperty("selectedURL", (Object)uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return context;
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._gui = super.getGUI();
            NavWindow.getContextSupport().attach(this);
            TreeExplorer treeExplorer = this.getTreeExplorer();
            if (RaptorExtensionConstants.isStandAlone()) {
                JTree jTree = treeExplorer.getJTree();
                jTree.setShowsRootHandles(false);
                this.specifyTreeWillExpandListener(jTree);
            }
            this.expandVisibleRoot(treeExplorer);
        }
        return this._gui;
    }

    protected void specifyTreeWillExpandListener(final JTree jTree) {
        jTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreeModel treeModel = jTree.getModel();
                TNode tNode = (TNode)treeModel.getRoot();
                TNode tNode2 = null;
                if (treeModel.getChildCount(tNode) > 0) {
                    tNode2 = (TNode)treeModel.getChild(tNode, 0);
                }
                if (tNode2 == treeExpansionEvent.getPath().getLastPathComponent()) {
                    throw new ExpandVetoException(treeExpansionEvent);
                }
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
    }

    protected void expandVisibleRoot(TreeExplorer treeExplorer) {
        TNode tNode = treeExplorer.getRoot();
        ExplorerContext.restoreExpansionState((TNode)tNode, (TreeExplorer)treeExplorer, null);
        Enumeration enumeration = tNode.getChildTNodes();
        while (enumeration.hasMoreElements()) {
            TNode tNode2 = (TNode)enumeration.nextElement();
            Element element = tNode2.getData();
            if (element instanceof Databases) {
                Databases databases = (Databases)element;
                if (!"IdeConnections".equals(databases.getStoreId())) continue;
                this.expand(tNode2, false);
                continue;
            }
            if (!(element instanceof CloudConnections)) continue;
            this.expand(tNode2, false);
        }
    }

    protected static ContextSupport getContextSupport() {
        if (s_ctxSupport == null) {
            if (s_supportClass != null) {
                try {
                    s_ctxSupport = s_supportClass.newInstance();
                }
                catch (Exception exception) {
                    Logger.getLogger(NavWindow.class.getName()).severe(exception.getStackTrace()[0] + exception.getLocalizedMessage());
                }
            }
            if (s_ctxSupport == null) {
                s_ctxSupport = new DefaultContextSupport();
            }
        }
        return s_ctxSupport;
    }

    public static Project getProject(String string) {
        return NavWindow.getContextSupport().getProject(string);
    }

    public static Workspace getWorkspace() {
        return NavWindow.getContextSupport().getWorkspace();
    }

    private static class DefaultContextSupport
    implements ContextSupport {
        private DefaultContextSupport() {
        }

        @Override
        public Project getProject(String string) {
            Project project = Ide.getActiveProject();
            if (project == null) {
                project = Ide.getDefaultProject();
            }
            return project;
        }

        @Override
        public Workspace getWorkspace() {
            Workspace workspace = Ide.getActiveWorkspace();
            if (workspace == null) {
                workspace = Ide.getDefaultWorkspace();
            }
            return workspace;
        }

        @Override
        public void attach(NavWindow navWindow) {
        }

        @Override
        public void updateContext(Context context) {
        }
    }

    public static interface ContextSupport {
        public void attach(NavWindow var1);

        public void updateContext(Context var1);

        public Project getProject(String var1);

        public Workspace getWorkspace();
    }
}

