/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

abstract class DeferredLoadingFilter
extends BaseRaptorFilter {
    private List<Element> m_children;
    private volatile RaptorTask<List<Element>> m_task;

    DeferredLoadingFilter() {
    }

    @Override
    protected Object getKey(Object object) {
        return object != null ? object.toString() : null;
    }

    public final TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        if (this.m_children != null) {
            for (Object e : updateMessage.getAddObjects()) {
                Element element = (Element)e;
                if (this.m_children.contains(element)) continue;
                this.m_children.add(element);
                TNode tNode2 = treeExplorer.addChild(element, tNode, treeExplorer.getTreeModel());
                this.cache(tNode2);
            }
        }
        return tNode;
    }

    public final TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        if (this.m_children != null) {
            for (Object e : updateMessage.getRemoveObjects()) {
                Element element = (Element)e;
                TNode tNode2 = this.lookup(element);
                if (tNode2 == null) continue;
                treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
                this.uncache(tNode2);
            }
        }
        return tNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeChildren() {
        if (this.m_children != null) {
            this.m_children = null;
        }
        DeferredLoadingFilter deferredLoadingFilter = this;
        synchronized (deferredLoadingFilter) {
            if (this.m_task != null) {
                this.m_task.requestCancel();
                this.m_task = null;
            }
        }
        super.closeChildren();
    }

    protected abstract FilterLoadTask getLoadTask();

    public final Iterator<?> getChildren() {
        if (this.m_children == null) {
            final Element element = this.getOwner().getData();
            this.m_children = new ArrayList<Element>();
            this.m_children.add(DummyElement.INSTANCE);
            assert (this.m_task == null);
            this.m_task = this.getLoadTask();
            this.m_task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    DeferredLoadingFilter deferredLoadingFilter = DeferredLoadingFilter.this;
                    synchronized (deferredLoadingFilter) {
                        DeferredLoadingFilter.this.m_task = null;
                    }
                    DeferredLoadingFilter.this.cleanupOnError(element);
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    RaptorTask raptorTask = null;
                    Object object = DeferredLoadingFilter.this;
                    synchronized (object) {
                        raptorTask = DeferredLoadingFilter.this.m_task;
                        DeferredLoadingFilter.this.m_task = null;
                    }
                    if (raptorTask != null) {
                        UpdateMessage.fireChildRemoved((Subject)((Subject)element), (Element)DummyElement.INSTANCE);
                        try {
                            object = (List)raptorTask.getResult();
                            UpdateMessage.fireChildrenAdded((Subject)((Subject)element), (Collection)object);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask(this.m_task);
        }
        return this.m_children.iterator();
    }

    public void refresh(TNode[] tNodeArray) {
        if (this.m_children != null) {
            this.m_children = null;
        }
    }

    protected final void cleanupOnError(final Element element) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (element instanceof Node) {
                    Node node = (Node)element;
                    try {
                        node.close();
                    }
                    catch (Exception exception) {}
                } else if (element instanceof Subject) {
                    UpdateMessage.fireObjectClosed((Subject)((Subject)element));
                }
            }
        });
    }

    protected static abstract class FilterLoadTask
    extends DatabaseQueryTask<List<Element>> {
        private volatile Thread m_execThread;
        String _fqConnName;

        FilterLoadTask(String string, String string2) {
            super(string, IRaptorTaskRunMode.IDE_STATUSBAR, false, true);
            this._fqConnName = string2;
        }

        @Override
        public String getConnectionName() {
            return this._fqConnName;
        }

        @Override
        public String getQuery() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<Element> doWork() {
            this.m_execThread = Thread.currentThread();
            try {
                List<Element> list = this.doWorkImpl();
                return list;
            }
            finally {
                this.m_execThread = null;
            }
        }

        protected abstract List<Element> doWorkImpl();

        public final boolean cancel() {
            Thread thread = this.m_execThread;
            if (thread != null) {
                DBUtil.cancelExecution((Thread)thread);
                thread.interrupt();
            }
            return true;
        }
    }
}

