/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.util.logging.Logger;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.navigator.BaseNavigatorManager;
import oracle.dbtools.raptor.navigator.ConnectionStores;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.NavActionListener;
import oracle.dbtools.raptor.navigator.net.DBURLFileSystemHelper;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Folder;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;

public class DatabaseNavigatorManager
extends BaseNavigatorManager {
    private static final String DEFAULT_NAME = "DatabaseNavigatorName";
    public static final Logger LOGGER = Logger.getLogger(DatabaseNavigatorManager.class.getName());
    private static final int TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.TOGGLE_TOOLBAR_CMD_ID");
    private static final String DATABASE_NAVIGATOR_WINDOW_ID = "DatabaseNavigatorWindow";
    private static final String DB_NAV_CMD = "DatabaseNavigator.SHOW_NAVIGATOR";
    private static final int DB_NAV_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.SHOW_NAVIGATOR");
    private static final String ACCEL_FILE = "/oracle/dbtools/raptor/navigator/accelerators.xml";
    private static NavigatorManager s_instance;

    private static String getNavigatorLabel() {
        return DatabaseNavigatorResources.getString(RaptorExtensionConstants.isStandAlone() ? "STANDALONE_NAVIGATOR_LABEL" : "PACKAGED_NAVIGATOR_LABEL");
    }

    public static synchronized NavigatorManager getInstance() {
        if (s_instance == null) {
            s_instance = new DatabaseNavigatorManager();
            ObjectActionController.addListener(new NavActionListener(s_instance));
        }
        return s_instance;
    }

    protected DatabaseNavigatorManager() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), ACCEL_FILE);
    }

    protected IdeAction createShowNavigatorAction() {
        IdeAction ideAction = IdeAction.get((int)DB_NAV_CMD_ID);
        if (!RaptorExtensionConstants.isStandAlone()) {
            String string = DatabaseNavigatorResources.getString("PACKAGED_NAVIGATOR_MENU");
            ideAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)string));
            ideAction.putValue("MnemonicKey", (Object)StringUtils.getMnemonicKeyCode((String)string));
        }
        return ideAction;
    }

    protected NavigatorWindow createNavigatorWindow() {
        NavigatorWindow navigatorWindow = this.createNavigatorWindow((Folder)ConnectionStores.s_instance, false, RaptorExtensionConstants.isStandAlone() ? 1 : 0);
        return navigatorWindow;
    }

    protected String getDefaultName() {
        return DEFAULT_NAME;
    }

    protected String getViewCategory() {
        return DATABASE_NAVIGATOR_WINDOW_ID;
    }

    protected IdeAction createToggleToolbarAction() {
        return IdeAction.get((int)TOGGLE_TOOLBAR_CMD_ID, null, (String)(RaptorExtensionConstants.isStandAlone() ? CommonArb.getString("CONN_NAVIGATOR_TOOLBAR") : DatabaseNavigatorResources.getString("PACKAGED_NAVIGATOR_LABEL")), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)(RaptorExtensionConstants.isStandAlone() ? CommonArb.getInteger("CONN_NAVIGATOR_TOOLBAR_MNEMONIC") : null), null, null, null, (boolean)true);
    }

    @Override
    public void initialize() {
        super.initialize();
        URLFileSystem.registerHelper((String)"sqldev.nav", (URLFileSystemHelper)new DBURLFileSystemHelper());
    }

    @Override
    protected String getTabTitle() {
        return DatabaseNavigatorManager.getNavigatorLabel();
    }
}

