/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.DBDevExtensionResource;
import oracle.dbtools.raptor.cloud.navigator.CloudController;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionGrinder;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.navigator.AbstractDatabaseFilter;
import oracle.dbtools.raptor.navigator.BaseNavigatorController;
import oracle.dbtools.raptor.navigator.ConnectionFilter;
import oracle.dbtools.raptor.navigator.CreateActionProvider;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.DefaultCreateActionProvider;
import oracle.dbtools.raptor.navigator.ObjectFilter;
import oracle.dbtools.raptor.navigator.SchemaFilter;
import oracle.dbtools.raptor.navigator.TypeContainerFilter;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.runner.DBStarterFactory;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.TNSPing;
import oracle.dbtools.util.objectpriv.PermissionRegistry;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class DatabaseNavigatorController
extends BaseNavigatorController {
    static final String OBJECT_URL = "URL";
    public static final String GLOBAL_FILTER_CMD = "DatabaseNavigator.FILTER_ALL";
    public static final int GLOBAL_FILTER_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.FILTER_ALL");
    public static final String CLEAR_FILTER_CMD = "DatabaseNavigator.CLEAR_FILTER";
    public static final int CLEAR_FILTER_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.CLEAR_FILTER");
    public static final String NEW_CONN_CMD = "DatabaseNavigator.NewConnection";
    public static final int NEW_DBCONN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.NewConnection");
    private static final String NEW_CONN_CHILD_CMD = "DatabaseNavigator.NewDBConnection";
    static final int NEW_CONN_CHILD_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.NewDBConnection");
    public static final String IMP_CONN_CMD = "DatabaseNavigator.ImportConnections";
    public static final int IMP_CONN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.ImportConnections");
    public static final String EXP_CONN_CMD = "DatabaseNavigator.ExportConnections";
    public static final int EXP_CONN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.ExportConnections");
    public static final String OPEN_CMD = "DatabaseNavigator.CONNECT";
    public static final int OPEN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.CONNECT");
    public static final String CLOSE_CMD = "DatabaseNavigator.DISCONNECT";
    public static final int CLOSE_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DISCONNECT");
    public static final String REOPEN_CMD = "DatabaseNavigator.RECONNECT";
    public static final int REOPEN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.RECONNECT");
    public static final String COLLAPSE_ALL_NODES_CMD = "DatabaseNavigator.COLLAPSE_ALL_NODES";
    public static final int COLLAPSE_ALL_NODES_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.COLLAPSE_ALL_NODES");
    public static final String NEW_CLOUD_CONN_CMD = "Cloud.NewCloudConnection";
    public static final int NEW_CLOUD_CONN_CMD_ID = Ide.findOrCreateCmdID((String)"Cloud.NewCloudConnection");
    public static final IdeAction ACTION_FILTER = IdeAction.find((String)"DatabaseNavigator.FILTER");
    public static final IdeAction ACTION_CLEAR_FILTER = IdeAction.find((String)"DatabaseNavigator.CLEAR_FILTER");
    public static final IdeAction ACTION_NEW_CONN = IdeAction.find((String)"DatabaseNavigator.NewConnection");
    public static final IdeAction ACTION_IMP_CONN = IdeAction.find((String)"DatabaseNavigator.ImportConnections");
    public static final IdeAction ACTION_EXP_CONN = IdeAction.find((String)"DatabaseNavigator.ExportConnections");
    public static final IdeAction ACTION_CONNECT = IdeAction.find((int)OPEN_CMD_ID);
    public static final IdeAction ACTION_DISCONNECT = IdeAction.find((int)CLOSE_CMD_ID);
    public static final IdeAction ACTION_RECONNECT = IdeAction.find((int)REOPEN_CMD_ID);
    public static final IdeAction ACTION_NEWOBJECT = IdeAction.find((int)NEW_OJBECT_CMD_ID);
    public static final IdeAction ACTION_EDITOBJECT = IdeAction.find((int)EDIT_OBJECT_CMD_ID);
    protected static CreateActionProvider s_actionProvider;
    private static List<Integer> s_additionalConnectionActions;
    private static int[] s_newIDs;

    private static int[] getAdditionCreateConnectionActions() {
        if (s_newIDs == null) {
            s_newIDs = new int[]{NEW_CONN_CHILD_CMD_ID, NEW_CLOUD_CONN_CMD_ID};
        }
        return s_newIDs;
    }

    public static CreateActionProvider getCreateActionProvider() {
        if (s_actionProvider == null) {
            s_actionProvider = new DefaultCreateActionProvider();
        }
        return s_actionProvider;
    }

    public static void setCreateActionProvider(CreateActionProvider createActionProvider) {
        s_actionProvider = createActionProvider;
    }

    @Override
    protected BaseNavigatorController.ProviderAdapter getProviderListener(Database database, Context context) {
        return new BaseNavigatorController.ProviderAdapter(database, context){

            @Override
            protected void schemaObjectsAddedImpl(SchemaObject[] schemaObjectArray) {
                Context context = this.getContext();
                ObjectFolder objectFolder = (ObjectFolder)context.getElement();
                URL uRL = objectFolder.getURL();
                String string = DBURLFormatHelper.getBaseType(uRL);
                if (schemaObjectArray != null) {
                    ObjectFilter objectFilter;
                    Object object;
                    String[] stringArray = new String[schemaObjectArray.length];
                    int n = 0;
                    TNode tNode = schemaObjectArray;
                    int n2 = ((SchemaObject[])tNode).length;
                    for (int i = 0; i < n2; ++i) {
                        object = tNode[i];
                        if (!ModelUtil.areEqual((Object)object.getType(), (Object)string)) continue;
                        stringArray[n++] = object.getName();
                    }
                    if (n < stringArray.length) {
                        tNode = stringArray;
                        stringArray = new String[n];
                        System.arraycopy(tNode, 0, stringArray, 0, n);
                    }
                    if ((tNode = ExplorerContext.getFirstTNode((Context)context)) != null && (objectFilter = (ObjectFilter)tNode.findChildFilter()) != null) {
                        DBFolderInstance dBFolderInstance = (DBFolderInstance)objectFilter.getFolderInstance();
                        object = new ArrayList();
                        try {
                            for (DBObjectInstance dBObjectInstance : dBFolderInstance.getChildren(stringArray, true)) {
                                DatabaseNode databaseNode = DatabaseNavigatorElementFactory.createObjectNode(uRL, dBObjectInstance);
                                if (databaseNode == null) continue;
                                object.add(databaseNode);
                            }
                        }
                        catch (SQLException sQLException) {
                            ExceptionHandler.handleException((Throwable)sQLException);
                        }
                        catch (AbortException abortException) {
                            object.clear();
                        }
                        UpdateMessage.fireChildrenAdded((Subject)objectFolder, (Collection)object);
                    }
                }
            }
        };
    }

    public DatabaseNavigatorController(Controller controller) {
        super(controller);
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        Element element = context.getElement();
        int n = ideAction.getCommandId();
        if (n == NEW_DBCONN_CMD_ID || n == NEW_CONN_CHILD_CMD_ID) {
            DatabaseNavigatorController.createNewConnection(context);
            bl = true;
        } else if (n == IMP_CONN_CMD_ID) {
            ConnectionGrinder.invoke((Databases)element, "IMPORT");
            bl = true;
        } else if (n == EXP_CONN_CMD_ID) {
            ConnectionGrinder.invoke((Databases)element, "EXPORT");
            bl = true;
        } else if (n == OPEN_CMD_ID) {
            if (element instanceof DatabaseConnection) {
                DatabaseNavigatorController.connect((DatabaseConnection)element, context);
                bl = true;
            }
        } else if (n == REOPEN_CMD_ID) {
            if (element instanceof DatabaseConnection) {
                DatabaseNavigatorController.reopenConnection((DatabaseConnection)element);
                bl = true;
            }
        } else if (n == CLOSE_CMD_ID) {
            if (element instanceof DatabaseConnection) {
                if (DBStarterFactory.isDebugSessionActive(((DatabaseConnection)element).getQualifiedConnectionName())) {
                    MessageDialog.error(null, (Object)DatabaseNavigatorResources.getString("CONTROLLER_ACTIVE_DEBUGGER_MSG"), (String)DatabaseNavigatorResources.getString("CONTROLLER_CANNOT_DISCONNECT"), null);
                } else {
                    DatabaseNavigatorController.disconnect((DatabaseConnection)element, context);
                }
                bl = true;
            }
        } else if (n == 20) {
            for (Element element2 : context.getSelection()) {
                if (!(element2 instanceof DatabaseConnection)) continue;
                DatabaseNavigatorController.deleteConnection((DatabaseConnection)element2, context);
                bl = true;
            }
        } else if (n == 56) {
            if (element instanceof DatabaseConnection) {
                DatabaseConnection databaseConnection = (DatabaseConnection)element;
                DatabaseNavigatorController.editConnection(databaseConnection.getStoreName(), databaseConnection.getConnectionName());
                bl = true;
            }
        } else if (n == CLEAR_FILTER_CMD_ID) {
            TNode tNode = ExplorerContext.getFirstTNode((Context)context);
            if (tNode != null) {
                DBItemInstance dBItemInstance;
                boolean bl2 = false;
                ChildFilter childFilter = tNode.getChildFilter();
                if (childFilter instanceof ConnectionFilter) {
                    dBItemInstance = ((ConnectionFilter)childFilter).getItemInstance();
                    if (dBItemInstance instanceof DBSchemaInstance) {
                        ((DBSchemaInstance)dBItemInstance).clearFilter();
                        bl2 = true;
                    }
                } else if (childFilter instanceof AbstractDatabaseFilter) {
                    ((AbstractDatabaseFilter)childFilter).getFolderInstance().clearFilter();
                    bl2 = true;
                } else if (childFilter instanceof SchemaFilter) {
                    ((SchemaFilter)childFilter).getSchemaInstance().clearFilter();
                    bl2 = true;
                }
                if (bl2) {
                    DatabaseOverlayClient.updateOverlay(tNode.getData());
                    dBItemInstance = IdeAction.find((int)51);
                    if (dBItemInstance != null) {
                        this.handleEvent((IdeAction)dBItemInstance, context);
                    }
                }
            }
            bl = true;
        } else if (n == COLLAPSE_ALL_NODES_CMD_ID) {
            TreeExplorer treeExplorer = ((NavigatorWindow)context.getView()).getTreeExplorer();
            TNode tNode = treeExplorer.getRoot();
            DefaultTreeModel defaultTreeModel = treeExplorer.getTreeModel();
            if (defaultTreeModel.getChildCount(tNode) > 0) {
                Enumeration enumeration = tNode.getChildTNodes();
                while (enumeration.hasMoreElements()) {
                    TNode tNode2 = (TNode)enumeration.nextElement();
                    if (tNode2 == null) continue;
                    Enumeration enumeration2 = tNode2.getChildTNodes();
                    while (enumeration2.hasMoreElements()) {
                        TNode tNode3 = (TNode)enumeration2.nextElement();
                        if (tNode3 == null) continue;
                        treeExplorer.collapse(tNode3, false);
                    }
                }
            }
            bl = true;
        }
        return bl || CloudController.getInstance().handleEvent(ideAction, context) || super.handleEvent(ideAction, context);
    }

    private TNode findTNode(Context context) {
        Element element;
        Element[] elementArray;
        TNode tNode = null;
        View view = context.getView();
        if (view instanceof NavigatorWindow && (tNode = ExplorerContext.getSingleTNode((Context)context)) == null && (elementArray = context.getSelection()) != null && elementArray.length == 1 && (element = elementArray[0]) != null) {
            TreeExplorer treeExplorer = ((NavigatorWindow)view).getTreeExplorer();
            tNode = treeExplorer.searchTNodeBreadthFirst(element, treeExplorer.getRoot());
        }
        return tNode;
    }

    @Override
    public void refreshParent(Context context) {
        TNode tNode = this.findTNode(context);
        if (tNode != null) {
            TNode tNode2 = tNode.getAncestorTNode(ObjectFolder.class, false);
            if (tNode2 == null) {
                this.refreshNode(context);
            } else {
                Object object;
                PlSqlNode plSqlNode = null;
                if (tNode.getData() instanceof PlSqlNode && !(plSqlNode = (PlSqlNode)tNode.getData()).isDirty()) {
                    Context context2;
                    Object object22;
                    object = new LinkedList();
                    EditorManager editorManager = EditorManager.getEditorManager();
                    for (Object object22 : editorManager.getAllEditors()) {
                        context2 = ((Editor)object22).getContext();
                        Node node = context2 != null ? context2.getNode() : null;
                        if (node != plSqlNode) continue;
                        ((LinkedList)object).add((Editor)object22);
                        break;
                    }
                    editorManager.closeEditors((List)object);
                    Context context3 = Context.newIdeContext((Node)plSqlNode);
                    object22 = new OpenEditorOptions(context3);
                    object22.setFlags(1);
                    context2 = editorManager.openEditor(object22);
                    context2.activate();
                }
                this.cleanCache(tNode);
                object = ((NavigatorWindow)context.getView()).getTreeExplorer();
                object.refresh(tNode2);
                tNode2.getChildFilter();
            }
        }
    }

    private void cleanCache(TNode tNode) {
        try {
            Class<DatabaseSourceNode> clazz = Class.forName("oracle.dbtools.raptor.navigator.xmlschema.XmlSchemaNode");
            this.cleanCacheRecurse(tNode, clazz);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void cleanCacheRecurse(TNode tNode, Class<DatabaseSourceNode> clazz) {
        if (tNode != null) {
            URL uRL;
            Object object;
            Enumeration enumeration;
            if (tNode.isSet(TNodeConstants.IS_OPENED) && (enumeration = tNode.getChildTNodes()) != null) {
                while (enumeration.hasMoreElements()) {
                    object = (TNode)enumeration.nextElement();
                    if (object == null) continue;
                    this.cleanCacheRecurse((TNode)object, clazz);
                }
            }
            if ((enumeration = tNode.getData()) != null && clazz.isAssignableFrom(enumeration.getClass()) && (uRL = (object = (DatabaseSourceNode)tNode.getData()).getURL()) != null && NodeFactory.find((URL)uRL) != null) {
                NodeFactory.uncache((URL)uRL);
            }
        }
    }

    @Override
    public void refreshNode(Context context) {
        TNode tNode = ExplorerContext.getSingleTNode((Context)context);
        if (tNode != null) {
            View view = context.getView();
            if (tNode.getData() instanceof Databases) {
                ((Databases)tNode.getData()).refreshPingTimes();
            } else if (view instanceof NavigatorWindow) {
                TreeExplorer treeExplorer = ((NavigatorWindow)view).getTreeExplorer();
                treeExplorer.refresh(tNode);
            }
        }
    }

    @Override
    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        Element element = context.getElement();
        int n = ideAction.getCommandId();
        if (n == 47) {
            ideAction.setEnabled(false);
            bl = true;
        } else if (n == NEW_DBCONN_CMD_ID) {
            int[] nArray;
            if (ideAction.isLocalAction() && (nArray = DatabaseNavigatorController.getAdditionCreateConnectionActions()).length > 0) {
                View view = context.getView();
                IdeAction[] ideActionArray = new IdeAction[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    ideActionArray[i] = IdeAction.newLocalAction((int)nArray[i], (View)view);
                }
                ideAction.putValue("ActionMenuActions", (Object)ideActionArray);
            }
        } else if (n == 51) {
            View view = context.getView();
            TreeExplorer treeExplorer = ((NavigatorWindow)view).getTreeExplorer();
            TNode tNode = ExplorerContext.getSingleTNode((Context)context);
            if (tNode != null) {
                Element element2 = tNode.getData();
                boolean bl2 = false;
                bl2 = element2 instanceof DatabaseNode || element2 instanceof Databases ? true : treeExplorer.canRefresh(tNode, element2.getClass());
                if (element2 instanceof PlSqlNode && ((PlSqlNode)element2).isDirty()) {
                    bl2 = false;
                }
                ideAction.setEnabled(bl2);
                bl = true;
            }
        } else if (n == FILTER_CMD_ID) {
            Object object;
            DBObject dBObject = new DBObject(element);
            boolean bl3 = false;
            if ((dBObject.isOracle() || dBObject.isTimesTen()) && (object = ExplorerContext.getFirstTNode((Context)context)) != null) {
                ChildFilter childFilter = object.getChildFilter();
                bl3 = childFilter instanceof ConnectionFilter ? ((ConnectionFilter)childFilter).getItemInstance() instanceof DBSchemaInstance : childFilter instanceof AbstractDatabaseFilter && ((AbstractDatabaseFilter)childFilter).getFolderInstance().canHaveFilter() || childFilter instanceof SchemaFilter;
            }
            object = DBDevExtensionResource.getString("NAVIGATOR_FILTER_LABEL");
            ideAction.putValueDirectly("Name", (Object)StringUtils.stripMnemonic((String)object));
            ideAction.setEnabled(bl3);
            bl = true;
        } else if (n == CLEAR_FILTER_CMD_ID) {
            boolean bl4 = false;
            TNode tNode = ExplorerContext.getFirstTNode((Context)context);
            if (tNode != null) {
                ChildFilter childFilter = tNode.getChildFilter();
                if (childFilter instanceof ConnectionFilter) {
                    DBItemInstance dBItemInstance = ((ConnectionFilter)childFilter).getItemInstance();
                    bl4 = dBItemInstance instanceof DBSchemaInstance && ((DBSchemaInstance)dBItemInstance).isSchemaFiltered();
                } else if (childFilter instanceof AbstractDatabaseFilter) {
                    bl4 = ((AbstractDatabaseFilter)childFilter).getFolderInstance().isFiltered();
                } else if (childFilter instanceof SchemaFilter) {
                    bl4 = ((SchemaFilter)childFilter).getSchemaInstance().isSchemaFiltered();
                }
                ideAction.setEnabled(bl4);
            }
            ideAction.putValueDirectly("Name", (Object)DBDevExtensionResource.getString("NAVIGATOR_CLEAR_FILTER_LABEL"));
            bl = true;
        } else if (n == OPEN_CMD_ID) {
            ideAction.setEnabled(element instanceof DatabaseConnection && !((DatabaseConnection)element).isConnectionOpen());
            bl = true;
        } else if (n == REOPEN_CMD_ID) {
            boolean bl5 = false;
            if (element instanceof DatabaseConnection) {
                DatabaseConnection databaseConnection = (DatabaseConnection)element;
                Database database = null;
                try {
                    database = Connections.getInstance().getDatabase(databaseConnection.getQualifiedConnectionName(), false);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (databaseConnection.isConnectionOpen()) {
                    if (database != null) {
                        databaseConnection.refreshPingTime();
                    }
                    bl5 = database == null || database != null && databaseConnection.getPingTime() > TNSPing.DOWN && !database.isConnectionAlive();
                }
            }
            ideAction.setEnabled(bl5);
            bl = true;
        } else if (n == CLOSE_CMD_ID) {
            boolean bl6 = false;
            if (element instanceof DatabaseConnection) {
                DatabaseConnection databaseConnection = (DatabaseConnection)element;
                bl6 = databaseConnection.isConnectionOpen() && !DBStarterFactory.isDebugSessionActive(databaseConnection.getQualifiedConnectionName());
            }
            ideAction.setEnabled(bl6);
            bl = true;
        } else if (n == 20) {
            if (element instanceof DatabaseConnection) {
                ideAction.setEnabled(true);
                bl = true;
            }
        } else if (n == 56) {
            if (element instanceof DatabaseConnection) {
                ideAction.setEnabled(true);
                bl = true;
            }
        } else if (n == NEW_OJBECT_CMD_ID) {
            boolean bl7 = false;
            if (element instanceof ObjectFolder && PermissionRegistry.canCreate(new DBObject(element))) {
                String string = (String)ideAction.getValue("DBObjectType");
                Database database = (Database)ideAction.getValue("Database");
                DBEditorFactory dBEditorFactory = (DBEditorFactory)ideAction.getValue("DBEditorFactory");
                DBObject dBObject = (DBObject)ideAction.getValue("ObjectAction.DBOBJECT");
                if (dBObject == null) {
                    ideAction.putValueDirectly("ObjectAction.DBOBJECT", context.getProperty("ObjectAction.DBOBJECT"));
                }
                bl7 = dBEditorFactory != null && dBEditorFactory.canCreateDBObject(null, (DBObjectProvider)database, string);
            }
            ideAction.setEnabled(bl7);
            bl = true;
        } else if (n == EXP_CONN_CMD_ID) {
            boolean bl8 = false;
            if (element instanceof Databases) {
                Databases databases = (Databases)element;
                if (Connections.getInstance().getConnNames(databases.getStoreId()).length > 0) {
                    bl8 = true;
                }
            }
            ideAction.setEnabled(bl8);
        }
        return bl || CloudController.getInstance().update(ideAction, context) || super.update(ideAction, context);
    }

    private static void connect(DatabaseConnection databaseConnection, Context context) {
        block8: {
            try {
                databaseConnection.getConnection();
                TNode[] tNodeArray = ExplorerContext.getTNodes((Context)context);
                if (tNodeArray.length == 1) {
                    TNode tNode = tNodeArray[0];
                    TreeExplorer treeExplorer = tNode.getOwner();
                    treeExplorer.expand(tNode, false);
                }
            }
            catch (IOException iOException) {
                Throwable throwable = iOException;
                if (iOException instanceof WrappedException) {
                    throwable = iOException.getCause();
                }
                Throwable throwable2 = throwable;
                while (throwable instanceof DBException) {
                    if ((throwable = throwable.getCause()) == null) continue;
                    throwable2 = throwable;
                }
                if (throwable2 instanceof ConnectionCanceledException) break block8;
                TypeContainerFilter.ExceptionDialogRunnable exceptionDialogRunnable = new TypeContainerFilter.ExceptionDialogRunnable(DatabaseNavigatorResources.getString("ERROR_OPENING"), throwable2);
                if (SwingUtilities.isEventDispatchThread()) {
                    exceptionDialogRunnable.run();
                }
                try {
                    SwingUtilities.invokeAndWait(exceptionDialogRunnable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void reopenConnection(DatabaseConnection databaseConnection) {
        block10: {
            Database database = null;
            try {
                database = Connections.getInstance().getDatabase(databaseConnection.getQualifiedConnectionName(), false);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (databaseConnection.isConnectionOpen() && database != null) {
                databaseConnection.refreshPingTime();
                if (databaseConnection.getPingTime() > TNSPing.DOWN && !database.isConnectionAlive()) {
                    try {
                        Connection connection = Connections.getInstance().reopenConnection(databaseConnection.getQualifiedConnectionName());
                        databaseConnection.reopenConnection(connection);
                    }
                    catch (DBException dBException) {
                        Throwable throwable;
                        Throwable throwable2 = throwable = dBException;
                        while (throwable instanceof DBException) {
                            if ((throwable = throwable.getCause()) == null) continue;
                            throwable2 = throwable;
                        }
                        if (throwable2 instanceof ConnectionCanceledException) break block10;
                        TypeContainerFilter.ExceptionDialogRunnable exceptionDialogRunnable = new TypeContainerFilter.ExceptionDialogRunnable(DatabaseNavigatorResources.getString("ERROR_OPENING"), throwable2);
                        if (SwingUtilities.isEventDispatchThread()) {
                            exceptionDialogRunnable.run();
                        }
                        try {
                            SwingUtilities.invokeAndWait(exceptionDialogRunnable);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public static boolean disconnect(DatabaseConnection databaseConnection, Context context) {
        assert (databaseConnection != null);
        String string = databaseConnection.getQualifiedConnectionName();
        return Connections.getInstance().closeConnection(string);
    }

    private static void deleteConnection(DatabaseConnection databaseConnection, Context context) {
        assert (databaseConnection != null);
        String string = databaseConnection.getQualifiedConnectionName();
        String string2 = DatabaseNavigatorResources.format("MGR_CONFIRM_DEL", Connections.getDisplayName(string));
        if (MessageDialog.confirm(null, (Object)string2, (String)DatabaseNavigatorResources.getString("MGR_CONFIRM_TITLE"), null, (boolean)true)) {
            DatabaseNavigatorController.closeAndDeleteConnection(databaseConnection, context);
        }
    }

    public static boolean deleteConnectionSilent(DatabaseConnection databaseConnection, Context context) {
        assert (databaseConnection != null);
        try {
            DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore(databaseConnection.getStoreName());
            return databaseConnections.removeConnection(databaseConnection.getConnectionName());
        }
        catch (ConnectionException connectionException) {
            return false;
        }
    }

    public static boolean closeAndDeleteConnection(DatabaseConnection databaseConnection, Context context) {
        if (DatabaseNavigatorController.disconnect(databaseConnection, context)) {
            DatabaseNavigatorController.deleteConnectionSilent(databaseConnection, context);
        }
        return false;
    }

    public static boolean closeAndDeleteConnection(Connection connection, Context context) {
        DatabaseConnection databaseConnection;
        String string = Connections.getInstance().getConnectionName(connection);
        if (string != null && (databaseConnection = Databases.getConnectionNode(string, false)) != null) {
            return DatabaseNavigatorController.closeAndDeleteConnection(databaseConnection, context);
        }
        return false;
    }

    static void createNewConnection(Context context) {
        DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getCurrentStore(context);
        String string = databaseConnections != null ? databaseConnections.getStoreName() : "IdeConnections";
        DatabaseConnectionEditor.editConnection((String)string, null);
    }

    static void editConnection(String string, String string2) {
        DatabaseConnectionEditor.editConnection((String)string, (String)string2);
    }

    static {
        Connections.getInstance().addConnectionListener(new ConnectionAdapter());
    }

    private static class ConnectionAdapter
    implements ConnectionListener {
        private ConnectionAdapter() {
        }

        @Override
        public void connectionAdded(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRemoved(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRenamed(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionModified(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionOpened(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getConnectionName();
            DatabaseConnection databaseConnection = Databases.getConnectionNode(string, false);
            if (databaseConnection != null && databaseConnection.openConnection()) {
                this.updateOverlays(databaseConnection);
                UpdateMessage.fireObjectOpened((Subject)databaseConnection);
            }
        }

        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            DatabaseConnection databaseConnection;
            String string = connectionEvent.getConnectionName();
            Database database = BaseNavigatorController.s_databases.remove(string);
            if (database != null) {
                database.close();
            }
            if ((databaseConnection = Databases.getConnectionNode(string, false)) != null && databaseConnection.isConnectionOpen()) {
                databaseConnection.closeConnection(false);
                this.updateOverlays(databaseConnection);
                UpdateMessage.fireObjectClosed((Subject)databaseConnection);
            }
        }

        private void updateOverlays(DatabaseConnection databaseConnection) {
            IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
            if (iconOverlayTracker != null) {
                iconOverlayTracker.validateOverlay((Element)databaseConnection);
                iconOverlayTracker.repaintOverlays();
            }
        }
    }
}

