/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.ObjectFactoryRegistry;
import oracle.dbtools.raptor.navigator.TypeContainerFilter;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBException;

public class ConnectionFilter
extends TypeContainerFilter {
    private String m_tooltip;
    private DBItemInstance m_instance;

    public String getShortLabel() {
        String string = super.getShortLabel();
        boolean bl = this.m_instance instanceof DBSchemaInstance && ((DBSchemaInstance)this.m_instance).isSchemaFiltered();
        return bl ? DatabaseNavigatorResources.format("FILTER_FORMAT", string) : string;
    }

    public String getToolTipText() {
        if (this.m_tooltip == null) {
            AbstractConnectionNode abstractConnectionNode = this.getConnectionNode();
            this.m_tooltip = abstractConnectionNode != null ? abstractConnectionNode.getShortLabel() : null;
        }
        return this.m_tooltip;
    }

    private AbstractConnectionNode getConnectionNode() {
        TNode tNode = this.getOwner();
        return tNode != null ? (AbstractConnectionNode)tNode.getData() : null;
    }

    public DBItemInstance getItemInstance() {
        return this.m_instance;
    }

    @Override
    protected Object getKey(Object object) {
        if (object == DummyElement.INSTANCE) {
            return object;
        }
        if (object instanceof Locatable) {
            return ((Locatable)object).getURL();
        }
        return null;
    }

    @Override
    protected boolean loadInThread() {
        return true;
    }

    protected ObjectFactory getFactory() throws IOException {
        ObjectFactory objectFactory = null;
        AbstractConnectionNode abstractConnectionNode = this.getConnectionNode();
        if (abstractConnectionNode != null) {
            Connection connection = abstractConnectionNode.getConnection();
            objectFactory = ObjectFactoryRegistry.getDatabaseNavigatorRegistry().getFactory(abstractConnectionNode.getQualifiedConnectionName(), connection);
        }
        return objectFactory;
    }

    @Override
    protected List<Element> loadChildrenImpl() throws IOException {
        final AbstractConnectionNode abstractConnectionNode = this.getConnectionNode();
        final String string = abstractConnectionNode != null ? abstractConnectionNode.getQualifiedConnectionName() : null;
        final DatabaseQueryTask<List<Element>> databaseQueryTask = new DatabaseQueryTask<List<Element>>(DatabaseNavigatorResources.getString("CONNECTION_FILTER_OPEN"), IRaptorTaskRunMode.IDE_STATUSBAR, false, true, true){

            private void checkStatus(String string2) throws AbortException {
                try {
                    this.checkCanProceed();
                }
                catch (ExecutionException executionException) {
                    throw new AbortException(string2);
                }
            }

            protected List<Element> doWork() throws TaskException {
                ArrayList<Element> arrayList;
                block14: {
                    arrayList = new ArrayList<Element>();
                    try {
                        String string5;
                        if (abstractConnectionNode == null) break block14;
                        this.checkStatus("getFactory");
                        ObjectFactory objectFactory = ConnectionFilter.this.getFactory();
                        ConnectionFilter.this.m_tooltip = abstractConnectionNode.getShortLabel() + DatabaseNavigatorResources.getString("CONNECTION_FILTER_CONNECTED_MSG");
                        if (objectFactory == null || (string5 = ConnectionFilter.this.getURLProtocol()) == null) break block14;
                        if (objectFactory.isSupportsCatalog()) {
                            DBCatalogsInstance dBCatalogsInstance = objectFactory.getCatalogsInstance();
                            try {
                                ConnectionFilter.this.fillInInitialProperties(dBCatalogsInstance);
                                for (DBChildInstance dBChildInstance : dBCatalogsInstance.listChildren()) {
                                    this.checkStatus("create catalogs");
                                    DBCatalogInstance dBCatalogInstance = (DBCatalogInstance)dBChildInstance;
                                    CatalogFolder catalogFolder = new CatalogFolder(DBURLFormatHelper.getURL(string5, abstractConnectionNode.getQualifiedConnectionName(), (String)dBCatalogInstance.getProperty("CATALOG"), null, null), dBCatalogInstance);
                                    arrayList.add(catalogFolder);
                                }
                            }
                            catch (SQLException sQLException) {
                                ExceptionHandler.handleException((Throwable)sQLException);
                            }
                            ConnectionFilter.this.m_instance = dBCatalogsInstance;
                            break block14;
                        }
                        String string2 = abstractConnectionNode.getQualifiedConnectionName();
                        if (objectFactory.isShowAllSchemasAtTopLevel()) {
                            DBSchemasInstance dBSchemasInstance = objectFactory.getSchemasInstance(null);
                            String string3 = (String)dBSchemasInstance.getProperty("ConnectionType");
                            try {
                                ConnectionFilter.this.fillInInitialProperties(dBSchemasInstance);
                                for (DBChildInstance dBChildInstance : dBSchemasInstance.listChildren()) {
                                    this.checkStatus("create schemas");
                                    DBSchemaInstance uRL = (DBSchemaInstance)dBChildInstance;
                                    SchemaFolder schemaFolder = new SchemaFolder(DBURLFormatHelper.getURL(string5, string2, null, (String)uRL.getProperty("SCHEMA"), null), uRL, string3);
                                    schemaFolder.setProperty("ConnectionType", string3);
                                    arrayList.add(schemaFolder);
                                }
                            }
                            catch (SQLException sQLException) {
                                ExceptionHandler.handleException((Throwable)sQLException);
                            }
                            ConnectionFilter.this.m_instance = dBSchemasInstance;
                            break block14;
                        }
                        String string4 = objectFactory.getSchema();
                        DBSchemaInstance dBSchemaInstance = objectFactory.createSchemaInstance(string4);
                        ConnectionFilter.this.fillInInitialProperties(dBSchemaInstance);
                        arrayList.addAll(ConnectionFilter.this.loadTypeFolders(dBSchemaInstance, string2, null, string4));
                        for (CategoryInstance object : dBSchemaInstance.listCategories()) {
                            URL uRL = DBURLFormatHelper.getURL(string5, string2, null, string4, object.getDescriptor().getType());
                            arrayList.add(new CategoryFolder(uRL, object));
                        }
                        if (objectFactory.isShowOtherSchemas()) {
                            DBSchemasInstance dBSchemasInstance = objectFactory.getSchemasInstance(null);
                            URL uRL = DBURLFormatHelper.getURL(string5, string2, null, null, "Schemas");
                            arrayList.add((Element)new OtherSchemasFolder(uRL, dBSchemasInstance));
                        }
                        ConnectionFilter.this.m_instance = dBSchemaInstance;
                    }
                    catch (IOException iOException) {
                        Throwable throwable = iOException;
                        if (iOException instanceof WrappedException) {
                            throwable = iOException.getCause();
                        }
                        throw new TaskException(throwable);
                    }
                    catch (AbortException abortException) {
                        throw new TaskException((Throwable)abortException);
                    }
                }
                return arrayList;
            }

            public boolean cancel() {
                return true;
            }

            @Override
            public String getConnectionName() {
                return string;
            }

            @Override
            public String getQuery() {
                return "";
            }
        };
        databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                ConnectionFilter.this.cleanupOnError(abstractConnectionNode);
            }

            private boolean isCancel(Throwable throwable) {
                return throwable instanceof ConnectionCanceledException || throwable instanceof CancellationException;
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable;
                Throwable throwable2 = throwable = raptorTaskEvent.getThrowable();
                while (throwable instanceof DBException) {
                    if ((throwable = throwable.getCause()) == null) continue;
                    throwable2 = throwable;
                }
                if (!this.isCancel(throwable2)) {
                    TypeContainerFilter.ExceptionDialogRunnable exceptionDialogRunnable = new TypeContainerFilter.ExceptionDialogRunnable(DatabaseNavigatorResources.getString("CONNECTION_FILTER_CONNECT_ERROR"), throwable);
                    if (SwingUtilities.isEventDispatchThread()) {
                        exceptionDialogRunnable.run();
                    } else {
                        try {
                            SwingUtilities.invokeLater(exceptionDialogRunnable);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ConnectionFilter.this.cleanupOnError(abstractConnectionNode);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                UpdateMessage.fireChildRemoved((Subject)abstractConnectionNode, (Element)DummyElement.INSTANCE);
                try {
                    List list = (List)databaseQueryTask.getResult();
                    UpdateMessage.fireChildrenAdded((Subject)abstractConnectionNode, (Collection)list);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
        return Collections.singletonList(DummyElement.INSTANCE);
    }

    protected void fillInInitialProperties(DBItemInstance dBItemInstance) {
    }
}

