/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.TypeContainerFilter;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class CategoryFilter
extends TypeContainerFilter {
    @Override
    protected List<Element> loadChildrenImpl() throws IOException {
        List<Element> list = null;
        TNode tNode = this.getOwner();
        final CategoryFolder categoryFolder = (CategoryFolder)tNode.getData();
        final CategoryInstance categoryInstance = categoryFolder.getCategoryInstance();
        try {
            URL uRL = categoryFolder.getURL();
            final String string = this.getURLProtocol();
            final String string2 = DBURLFormatHelper.getConnectionName(uRL);
            ObjectFactory objectFactory = categoryInstance.getObjectFactory();
            if (objectFactory != null) {
                String string3;
                String string4 = (String)categoryInstance.getProperty("CATALOG");
                if (string4 == null) {
                    string4 = DBURLFormatHelper.getCatalog(uRL);
                }
                if ((string3 = (String)categoryInstance.getProperty("SCHEMA")) == null) {
                    string3 = DBURLFormatHelper.getSchema(uRL);
                }
                final String string5 = string4;
                final String string6 = string3;
                RaptorTask<List<Element>> raptorTask = new RaptorTask<List<Element>>(DatabaseNavigatorResources.getString("CONNECTION_FILTER_OPEN"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

                    protected List<Element> doWork() throws TaskException {
                        ArrayList<Element> arrayList = new ArrayList<Element>();
                        arrayList.addAll(CategoryFilter.this.loadTypeFolders(categoryInstance, string2, string5, string6));
                        for (CategoryInstance categoryInstance2 : categoryInstance.listCategories()) {
                            URL uRL = DBURLFormatHelper.getURL(string, string2, null, null, categoryInstance2.getDescriptor().getType());
                            arrayList.add(new CategoryFolder(uRL, categoryInstance2));
                        }
                        return arrayList;
                    }

                    protected boolean isCancellable() {
                        return false;
                    }
                };
                raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)raptorTask){
                    final /* synthetic */ RaptorTask val$task;
                    {
                        this.val$task = raptorTask;
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                UpdateMessage.fireChildRemoved((Subject)categoryFolder, (Element)DummyElement.INSTANCE);
                                try {
                                    List list = (List)val$task.getResult();
                                    UpdateMessage.fireChildrenAdded((Subject)categoryFolder, (Collection)list);
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (ExecutionException executionException) {
                                    // empty catch block
                                }
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }

                    public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    }

                    public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                list = Collections.singletonList(DummyElement.INSTANCE);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    protected Object getKey(Object object) {
        return null;
    }
}

