/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DeferUIOperationTask;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.objectpriv.PermissionRegistry;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectListener;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderAdapter;
import oracle.javatools.db.DBObjectProviderListener;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

public abstract class BaseNavigatorController
implements Controller {
    protected static final String DATABASE_KEY = "Database";
    public static final String DB_EDITOR_FACTORY_KEY = "DBEditorFactory";
    public static final String EDIT_OBJECT_CMD = "DatabaseNavigator.EditObject";
    public static final int EDIT_OBJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.EditObject");
    public static final Set<String> EDITABLE_TYPES;
    public static final String FILTER_CMD = "DatabaseNavigator.FILTER";
    public static final int FILTER_CMD_ID;
    public static final String NEW_OBJECT_CMD = "DatabaseNavigator.NewObject";
    public static final int NEW_OJBECT_CMD_ID;
    protected static final String OBJECT_TYPE_KEY = "DBObjectType";
    protected static Map<String, Database> s_databases;
    private Controller m_parent;

    public static void addEditableType(String string) {
        EDITABLE_TYPES.add(string);
    }

    protected static boolean canEditObject(DatabaseNode databaseNode) {
        SchemaObject schemaObject;
        Database database;
        DBObject dBObject;
        String string = (String)databaseNode.getProperty("TYPE");
        if (EDITABLE_TYPES.contains(string) && PermissionRegistry.canAlter(dBObject = new DBObject(databaseNode)) && (database = BaseNavigatorController.getDatabase((String)databaseNode.getProperty("ConnectionName"))) != null && (schemaObject = dBObject.getSchemaObject()) != null) {
            return DBEditorFactoryRegistry.getEditFactory((SchemaObject)schemaObject, (DBObjectProvider)database) != null;
        }
        return false;
    }

    protected static Database getDatabase(String string) {
        Database database = s_databases.get(string);
        if (database == null) {
            try {
                database = Connections.getInstance().getDatabase(string);
                s_databases.put(string, database);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return database;
    }

    private static SchemaObject getSchemaObject(Database database, DatabaseNode databaseNode) throws DBException {
        String string = (String)databaseNode.getProperty("API_NAME");
        if (string == null) {
            string = (String)databaseNode.getProperty("NAME");
        }
        return database.getObject((String)databaseNode.getProperty("TYPE"), database.getSchema((String)databaseNode.getProperty("SCHEMA")), string);
    }

    protected static void updateAction(IdeAction ideAction, DBObject dBObject, Database database, String string, DBEditorFactory dBEditorFactory) {
        String string2 = dBEditorFactory.getCreateLabel(string);
        ideAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)string2));
        ideAction.putValue("MnemonicKey", (Object)StringUtils.getMnemonicKeyCode((String)string2));
        ideAction.putValue("SmallIcon", (Object)DBTypeDisplayRegistry.getNodeIcon((String)string));
        ideAction.putValueDirectly(OBJECT_TYPE_KEY, (Object)string);
        ideAction.putValueDirectly(DATABASE_KEY, (Object)database);
        ideAction.putValueDirectly(DB_EDITOR_FACTORY_KEY, (Object)dBEditorFactory);
        ideAction.putValueDirectly("ObjectAction.DBOBJECT", (Object)dBObject);
    }

    protected BaseNavigatorController(Controller controller) {
        this.m_parent = controller;
    }

    protected abstract ProviderAdapter getProviderListener(Database var1, Context var2);

    protected boolean createObject(IdeAction ideAction, Context context) {
        boolean bl = false;
        String string = (String)ideAction.getValue(OBJECT_TYPE_KEY);
        final String string2 = string.startsWith("PUBLIC") ? string.substring(7) : string;
        final Database database = (Database)ideAction.getValue(DATABASE_KEY);
        final DBEditorFactory dBEditorFactory = (DBEditorFactory)ideAction.getValue(DB_EDITOR_FACTORY_KEY);
        final ProviderAdapter providerAdapter = this.getProviderListener(database, context);
        final String string3 = database.getQualifiedName();
        final DBObject dBObject = (DBObject)ideAction.getValue("ObjectAction.DBOBJECT");
        if (dBEditorFactory != null) {
            DeferUIOperationTask deferUIOperationTask = new DeferUIOperationTask(DatabaseNavigatorResources.getString("CREATE_DATABASE_OBJECT")){

                @Override
                public String getConnectionName() {
                    return string3;
                }

                @Override
                protected void invokeLater() {
                    String string;
                    database.addProviderListener((DBObjectProviderListener)providerAdapter);
                    String string22 = string = dBObject != null ? dBObject.getSchemaName() : null;
                    if (dBEditorFactory.createDBObject(new Schema(string), (DBObjectProvider)database, string2) == null) {
                        database.removeProviderListener((DBObjectProviderListener)providerAdapter);
                    }
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)deferUIOperationTask);
        }
        return bl;
    }

    protected boolean editObject(IdeAction ideAction, final Context context) {
        DatabaseNode databaseNode;
        boolean bl = false;
        Node node = context.getNode();
        if (node instanceof TextNode) {
            BaseNavigatorController.openCodeEditorForNode(node);
            bl = true;
        } else if (node instanceof DatabaseNode && BaseNavigatorController.canEditObject(databaseNode = (DatabaseNode)node)) {
            Database database = (Database)ideAction.getValue(DATABASE_KEY);
            try {
                SchemaObject schemaObject = BaseNavigatorController.getSchemaObject(database, databaseNode);
                if (schemaObject == null) {
                    throw new DBException(null, "Cannot load object");
                }
                DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getEditFactory((SchemaObject)schemaObject, (DBObjectProvider)database);
                final Node node2 = node;
                DBObjectListener dBObjectListener = new DBObjectListener(){

                    public void objectUpdated(DBObjectChange dBObjectChange) {
                        Subject subject = (Subject)context.getElement();
                        UpdateMessage.fireStructureChanged((Subject)subject);
                        PropertyChangeEvent propertyChangeEvent = dBObjectChange.getPropertyChange("name");
                        if (propertyChangeEvent != null) {
                            BaseNavigatorController.closeEditors(node2);
                        }
                    }
                };
                schemaObject.addObjectListener(dBObjectListener);
                bl = dBEditorFactory.editDBObject(schemaObject, (DBObjectProvider)database);
                if (bl) {
                    this.refreshParent(context);
                }
            }
            catch (DBException dBException) {
                ExceptionHandler.handleException((Throwable)dBException);
            }
        }
        return bl;
    }

    public static void closeEditors(Node node) {
        List list = EditorManager.getEditorManager().getAllEditors();
        Editor editor = null;
        Node node2 = null;
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        for (int i = 0; i < list.size(); ++i) {
            editor = (Editor)list.get(i);
            node2 = editor.getContext().getNode();
            if (node2 instanceof IViewerNode) {
                node2 = ((IViewerNode)node2).getBaseNode();
            }
            if (node2 != node) continue;
            arrayList.add(editor);
        }
        EditorManager.getEditorManager().closeEditors(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openCodeEditorForNode(Node node) {
        Context context;
        EditorManager editorManager = EditorManager.getEditorManager();
        Context context2 = null;
        for (Object object : editorManager.getAllEditors()) {
            context = ((Editor)object).getContext();
            Node node2 = context != null ? context.getNode() : null;
            if (node2 != node) continue;
            context2 = context;
        }
        WaitCursor waitCursor = null;
        if (context2 == null) {
            waitCursor = Ide.getWaitCursor();
            context2 = Context.newIdeContext((Node)node);
        }
        if (waitCursor != null) {
            waitCursor.show();
        }
        try {
            Object object;
            object = new OpenEditorOptions(context2, CodeEditor.class);
            context = (CodeEditor)editorManager.openEditor(object);
            context.setCaretPosition(0);
        }
        finally {
            if (waitCursor != null) {
                waitCursor.hide();
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == 51) {
            bl = true;
            this.refreshParent(context);
        } else if (n == EDIT_OBJECT_CMD_ID) {
            bl = this.editObject(ideAction, context);
        } else if (n == NEW_OJBECT_CMD_ID && (bl = this.createObject(ideAction, context))) {
            this.refreshParent(context);
        }
        return bl || this.m_parent.handleEvent(ideAction, context);
    }

    public abstract void refreshNode(Context var1);

    public abstract void refreshParent(Context var1);

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        Element element = context.getElement();
        int n = ideAction.getCommandId();
        if (n == EDIT_OBJECT_CMD_ID) {
            if (element instanceof TextNode) {
                ideAction.setEnabled(true);
            } else if (element instanceof DatabaseNode) {
                ideAction.setEnabled(BaseNavigatorController.canEditObject((DatabaseNode)element));
            }
            bl = true;
        }
        return bl || this.m_parent.update(ideAction, context);
    }

    static {
        FILTER_CMD_ID = Ide.findOrCreateCmdID((String)FILTER_CMD);
        NEW_OJBECT_CMD_ID = Ide.findOrCreateCmdID((String)NEW_OBJECT_CMD);
        s_databases = new HashMap<String, Database>();
        EDITABLE_TYPES = new HashSet<String>();
        EDITABLE_TYPES.add("TABLE");
        EDITABLE_TYPES.add("VIEW");
        EDITABLE_TYPES.add("INDEX");
        EDITABLE_TYPES.add("SEQUENCE");
        EDITABLE_TYPES.add("MATERIALIZED VIEW");
        EDITABLE_TYPES.add("MATERIALIZED VIEW LOG");
        EDITABLE_TYPES.add("DATABASE LINK");
    }

    protected abstract class ProviderAdapter
    extends DBObjectProviderAdapter {
        private final Database m_db;
        private final Context m_ctx;

        protected ProviderAdapter(Database database, Context context) {
            this.m_db = database;
            this.m_ctx = context;
        }

        protected Context getContext() {
            return this.m_ctx;
        }

        protected Database getDatabase() {
            return this.m_db;
        }

        public final void schemaObjectsAdded(DBObjectProvider dBObjectProvider, Schema schema, SchemaObject[] schemaObjectArray) {
            this.schemaObjectsAddedImpl(schemaObjectArray);
            this.m_db.removeProviderListener((DBObjectProviderListener)this);
        }

        protected abstract void schemaObjectsAddedImpl(SchemaObject[] var1);
    }
}

