/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public abstract class AbstractConnectionNode
extends DefaultElement
implements ViewableElement,
Subject {
    private URL m_url;
    private IdeSubject m_subject = new IdeSubject();
    private Connection m_conn;
    private Object __LOCK__ = new Object();

    protected AbstractConnectionNode() {
    }

    protected Object getLock() {
        return this.__LOCK__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_conn == null) {
                this.m_conn = this.openConnectionImpl();
            }
        }
        return this.m_conn;
    }

    protected final boolean openConnection() {
        boolean bl = this.isConnectionOpen();
        if (!bl) {
            try {
                this.getConnection();
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reopenConnection(Connection connection) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_conn != null) {
                this.m_conn = connection;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeConnection(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_conn != null) {
                if (bl) {
                    this.closeConnectionImpl();
                }
                this.m_conn = null;
            }
        }
    }

    protected final void closeConnection() {
        this.closeConnection(true);
    }

    protected abstract Connection openConnectionImpl() throws IOException;

    protected abstract boolean closeConnectionImpl();

    public final boolean isConnectionOpen() {
        return this.m_conn != null;
    }

    public abstract String getQualifiedConnectionName();

    public boolean mayHaveChildren() {
        return true;
    }

    protected boolean isConnected() {
        return this.m_conn != null;
    }

    public final URL getURL() {
        return this.m_url;
    }

    public void setURL(URL uRL) {
        this.m_url = uRL;
    }

    public final void attach(Observer observer) {
        this.m_subject.attach(observer);
    }

    public final void detach(Observer observer) {
        this.m_subject.detach(observer);
    }

    public final void notifyObservers(Object object, UpdateMessage updateMessage) {
        this.m_subject.notifyObservers(object, updateMessage);
    }
}

