/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.HarvestDoc;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SqlHistory;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.insight.DBListInsightData;
import oracle.dbtools.raptor.insight.InsightableOracleDatabase;
import oracle.dbtools.raptor.insight.SynonymsCache;
import oracle.dbtools.raptor.insight.UsersCache;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.templates.CodeTemplateUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.Insight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;
import oracle.javatools.util.Pair;

public final class CompletionInsight
extends AbstractInsight
implements InsightProvider {
    public static boolean trace = RaptorExtensionConstants.isStandAlone();
    public static boolean timing = RaptorExtensionConstants.isStandAlone();
    private ListInsightView _view = new ListInsightView(){

        public void selectDefault() {
            if (!CompletionInsight.this.wasAutoInvoked) {
                super.selectDefault();
            }
        }

        public boolean complete(Insight insight) {
            int n = this.getSelectedIndex();
            ListModel listModel = this.getModel();
            if (n < 0 || n >= listModel.getSize()) {
                return false;
            }
            return super.complete(insight);
        }
    };
    DBListInsightData _lastLookup;
    private Node node;
    private String connName = null;
    int startCaretPosition;
    BackgroundParser parser = null;
    boolean raiselimit = false;
    boolean raiseHlimit = false;
    boolean raiseSlimit = false;
    boolean raiseTlimit = false;
    List<Member> members = new LinkedList<Member>();
    LexerToken prior = null;
    boolean isWorksheet = false;
    static List<CompletionInsight> instances = new LinkedList<CompletionInsight>();
    private char typedChar = '\u0000';
    private boolean wasAutoInvoked;
    private String identifierPrefix = "";
    private String alias = "";
    private InsightThread worker = null;
    private static boolean firstInvocation = true;
    public static final int minTSuggestions = 3;
    public static final int maxTSuggestions = 20;
    public static int tSuggestions = 3;

    private String getConnName() {
        if (this.connName != null) {
            return this.connName;
        }
        if (this.node instanceof PlSqlNode && ((PlSqlNode)this.node).getConnectionName() != null) {
            PlSqlNode plSqlNode = (PlSqlNode)this.node;
            this.connName = plSqlNode.getConnectionName();
        } else if (this.node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)this.node;
            this.connName = DBURLFormatHelper.getConnectionName(this.node.getURL());
        }
        return this.connName;
    }

    public CompletionInsight(Context context, BackgroundParser backgroundParser) {
        this.parser = backgroundParser;
        instances.add(this);
        this.node = context.getNode();
        if (this.node instanceof PlSqlNode) {
            this.parser = ((PlSqlNode)this.node).getParser();
            this.initMembers((PlSqlNode)this.node);
        } else if (context.getView() instanceof IDBEditor) {
            this.connName = ((IDBEditor)context.getView()).getConnectionName();
        }
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig.getBoolean("ENABLECOMPLETIONPLSQLEDITOR").booleanValue()) {
            new Thread(){

                @Override
                public void run() {
                    UsersCache.fillIn(CompletionInsight.this.getConnName());
                    SynonymsCache.fillIn(CompletionInsight.this.getConnName());
                }
            }.start();
        }
        this.setCellRenderer();
    }

    public CompletionInsight(String string, BackgroundParser backgroundParser) {
        DBConfig dBConfig;
        this.parser = backgroundParser;
        instances.add(this);
        this.isWorksheet = true;
        this.connName = string;
        if (!string.startsWith("jdbc:oracle:thin:@") && (dBConfig = DBConfig.getInstance()).getBoolean("ENABLECOMPLETIONWORKSHEET").booleanValue()) {
            new Thread(){

                @Override
                public void run() {
                    UsersCache.fillIn(CompletionInsight.this.getConnName());
                    SynonymsCache.fillIn(CompletionInsight.this.getConnName());
                }
            }.start();
        }
        this.setCellRenderer();
    }

    public void setCellRenderer() {
        ListDataItemCellRenderer listDataItemCellRenderer = new ListDataItemCellRenderer(){
            boolean printOnce = true;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object instanceof SuggestedItem) {
                    JLabel jLabel = (JLabel)component;
                    SuggestedItem suggestedItem = (SuggestedItem)object;
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    Font font = editorProperties.getFontHelper().getFont(0);
                    jLabel.setFont(font);
                    jLabel.setToolTipText(suggestedItem.getName());
                    if ("KEYWORD".equals(suggestedItem.getType())) {
                        jLabel.setForeground(Color.BLUE);
                    }
                    if (suggestedItem.isDocSnippet()) {
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BoxLayout(jPanel, 0));
                        JButton jButton = new JButton(OracleIcons.getIcon((String)"library.png"));
                        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
                        jButton.setSize(new Dimension(suggestedItem.getIcon().getIconWidth(), suggestedItem.getIcon().getIconHeight()));
                        jButton.setEnabled(true);
                        jPanel.setToolTipText(suggestedItem.getName());
                        jPanel.add(jButton);
                        jLabel.setIcon(null);
                        jPanel.add(jLabel);
                        return jPanel;
                    }
                }
                return component;
            }

            public Dimension getPreferredSize() {
                int n;
                Dimension dimension = super.getPreferredSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                if (trace && this.printOnce) {
                    System.out.println("dim.width=" + dimension2.width);
                    this.printOnce = false;
                }
                if ((n = dimension2.width / 4) < 250) {
                    n = 250;
                }
                return new Dimension(n, dimension.height);
            }
        };
        this._view.setCellRenderer((ListCellRenderer)listDataItemCellRenderer);
        int n = Toolkit.getDefaultToolkit().getScreenSize().height / (RaptorImagesArb.getIcon("FUNCTION").getIconHeight() + 4);
        n = Math.max(n, 15);
        n = Math.min(n, 45);
        this._view.setVisibleRowCount(n);
        this._view.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                Object object = mouseEvent.getSource();
                if (object instanceof ListInsightView) {
                    SuggestedItem suggestedItem;
                    ListInsightView listInsightView = (ListInsightView)object;
                    if (mouseEvent.getX() <= listInsightView.getX() + 16 && (suggestedItem = (SuggestedItem)listInsightView.getSelectedValue()).isDocSnippet()) {
                        try {
                            Desktop.getDesktop().browse(new URI(suggestedItem.doc.getPublicURL()));
                        }
                        catch (Exception exception) {
                            Log.error((String)("Failed to go to URL, " + exception.getMessage()));
                        }
                    }
                }
            }
        });
    }

    private void initMembers(PlSqlNode plSqlNode) {
        plSqlNode.addMembersTo(this.members);
        if (plSqlNode.isBody()) {
            URL uRL = plSqlNode.getURL();
            String string = DBURLFormatHelper.getBaseType(uRL);
            URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), string.substring(0, string.indexOf(32))), DBURLFormatHelper.getName(uRL));
            PlSqlNode plSqlNode2 = (PlSqlNode)DatabaseNavigatorElementFactory.getObjectNode(uRL2);
            plSqlNode2.addMembersTo(this.members);
        }
    }

    protected InsightProvider createInsightProvider() {
        return this;
    }

    public void characterTyped(BasicEditorPane basicEditorPane, int n, char c) {
        DBConfig dBConfig = DBConfig.getInstance();
        if (RaptorExtensionConstants.isStandAlone()) {
            if (!this.isWorksheet) {
                basicEditorPane.putIntegerProperty("completion-popup-delay", dBConfig.getInt("DELAYCOMPLETIONPLSQLEDITOR"));
                basicEditorPane.putBooleanProperty("completion-enable-autopopup", dBConfig.getBoolean("ENABLECOMPLETIONPLSQLEDITOR").booleanValue());
            } else {
                basicEditorPane.putIntegerProperty("completion-popup-delay", dBConfig.getInt("DELAYCOMPLETIONWORKSHEET"));
                basicEditorPane.putBooleanProperty("completion-enable-autopopup", dBConfig.getBoolean("ENABLECOMPLETIONWORKSHEET").booleanValue());
            }
        }
        super.characterTyped(basicEditorPane, n, c);
    }

    public boolean isInsightTriggerChar(char c) {
        this.typedChar = c;
        return c != ';';
    }

    public void showInsight(boolean bl) {
        this.wasAutoInvoked = bl;
        super.showInsight(bl);
    }

    protected boolean isAutomaticPartialComplete(InsightData insightData) {
        return false;
    }

    String getAliacedPrefix() {
        if (this.alias.length() == 0) {
            return this.identifierPrefix;
        }
        return this.alias + "." + this.identifierPrefix;
    }

    public InsightData getInsightData(BasicEditorPane basicEditorPane) {
        long l;
        if (Connections.getInstance().isTimesTen(this.getConnName())) {
            return null;
        }
        this._lastLookup = null;
        if (this.worker != null && this.worker.isAlive()) {
            return null;
        }
        this.worker = new InsightThread("InsightThread");
        this.worker.start();
        long l2 = System.currentTimeMillis();
        long l3 = l = this.typedChar == '\u0000' ? 5000L : 750L;
        if (firstInvocation && l < 2000L) {
            l = 2000L;
            firstInvocation = false;
        }
        if (this.raiselimit) {
            l = 15000L;
        }
        while (this.worker.isAlive()) {
            if (l < System.currentTimeMillis() - l2) {
                DBUtil.cancelExecution((Thread)this.worker);
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.typedChar = '\u0000';
        return this._lastLookup;
    }

    /*
     * WARNING - void declaration
     */
    void complete(String string, List<LexerToken> list, LazyNode lazyNode, int n, int n2, boolean bl) {
        boolean bl2;
        Set<SuggestedItem> set;
        Object object;
        long l;
        block76: {
            String string2;
            l = System.currentTimeMillis();
            ArrayList<Object> arrayList = new ArrayList<LexerToken>();
            List list2 = LexerToken.parse((String)string, (boolean)true);
            int n3 = CompletionInsight.filterOutComments(n, list2, arrayList);
            if (n3 == -1) {
                this._lastLookup = null;
                return;
            }
            if (n3 == -2) {
                string2 = string.substring(0, n) + '\"' + string.substring(n);
                arrayList = new ArrayList();
                n3 = CompletionInsight.filterOutComments(n, LexerToken.parse((String)string2, (boolean)true), arrayList);
            }
            if (arrayList.size() == 0) {
                this._lastLookup = null;
                return;
            }
            this.identifierPrefix = "";
            this.alias = "";
            string2 = n3 < arrayList.size() ? arrayList.get(n3) : null;
            this.prior = n3 > 0 ? arrayList.get(n3 - 1) : null;
            if (n3 > 1 && this.prior != null && ".".equals(this.prior.content)) {
                this.alias = ((LexerToken)arrayList.get((int)(n3 - 2))).content;
            }
            if (string2 != null && (((LexerToken)string2).type == Token.IDENTIFIER || ((LexerToken)string2).type == Token.DQUOTED_STRING) && ((LexerToken)string2).begin < n && n < ((LexerToken)string2).end) {
                this.identifierPrefix = ((LexerToken)string2).content.substring(0, n - ((LexerToken)string2).begin);
                this.startCaretPosition -= this.identifierPrefix.length();
            } else if (string2 != null && (((LexerToken)string2).type == Token.IDENTIFIER || ((LexerToken)string2).type == Token.DQUOTED_STRING) && n == ((LexerToken)string2).end) {
                this.identifierPrefix = ((LexerToken)string2).content.substring(0, n - ((LexerToken)string2).begin);
                this.startCaretPosition -= this.identifierPrefix.length();
            }
            if (!this.identifierPrefix.startsWith("\"")) {
                this.identifierPrefix = this.identifierPrefix.toUpperCase();
            }
            SqlEarley sqlEarley = SqlEarley.getInstance();
            Matrix matrix = new Matrix((Parser)sqlEarley);
            sqlEarley.fifteenPctLAImpr = false;
            sqlEarley.parse(arrayList, matrix);
            sqlEarley.fifteenPctLAImpr = true;
            Set<String> set2 = CompletionInsight.predict(n3, sqlEarley, matrix);
            Cell cell = (Cell)matrix.get((Object)Service.lPair((int)0, (int)arrayList.size()));
            ParseNode parseNode = null;
            if (this.isLegitimate(cell)) {
                parseNode = sqlEarley.forest(arrayList, matrix);
            } else {
                if (this.identifierPrefix.length() > 0) {
                    if (trace) {
                        System.out.println("deleted an identifier");
                    }
                    arrayList.remove(n3);
                    matrix = new Matrix((Parser)sqlEarley);
                    sqlEarley.parse(arrayList, matrix);
                    cell = (Cell)matrix.get((Object)Service.lPair((int)0, (int)arrayList.size()));
                }
                if (!this.isLegitimate(cell)) {
                    int n4 = arrayList.size();
                    this.fixCode(arrayList, n3, set2);
                    matrix = new Matrix((Parser)sqlEarley);
                    sqlEarley.parse(arrayList, matrix);
                    cell = (Cell)matrix.get((Object)Service.lPair((int)0, (int)arrayList.size()));
                    if (!this.isLegitimate(cell)) {
                        object = CompletionInsight.predict(n3 + (arrayList.size() - n4), sqlEarley, matrix);
                        this.fixCode(arrayList, n3 + (arrayList.size() - n4), (Set<String>)object);
                        matrix = new Matrix((Parser)sqlEarley);
                        sqlEarley.parse(arrayList, matrix);
                    }
                }
                parseNode = sqlEarley.forest(arrayList, matrix);
            }
            set = this.suggestedKeywords(set2, this.identifierPrefix);
            object = new InsightableOracleDatabase(this.getConnName(), !set2.contains("values_clause[12,24)"));
            ((InsightableOracleDatabase)object).limit = this.raiselimit ? 1000 : ((InsightableOracleDatabase)object).minLimit;
            HarvestDoc.suggestions = this.raiseSlimit ? 20 : 3;
            SqlHistory.suggestions = this.raiseHlimit ? 20 : 3;
            tSuggestions = this.raiseTlimit ? 20 : 3;
            if (!(this.identifierPrefix.length() <= 0 || n3 != 0 && this.prior.content.toLowerCase().startsWith("desc"))) {
                set.addAll(this.suggestedSnippets(set2, this.identifierPrefix, this.prior, matrix, n3));
            }
            bl2 = false;
            if (n3 > 0 && this.prior.content.toLowerCase().startsWith("desc")) {
                ((InsightableOracleDatabase)object).prepareAllTables(null, this.identifierPrefix);
                ((InsightableOracleDatabase)object).prepareAllProcedures(null, this.identifierPrefix);
            } else {
                Object object22;
                Object object3;
                Object object4;
                Object object7;
                int n5;
                boolean bl3;
                boolean bl4 = bl3 = set2.contains("table_reference") || set2.contains("dml_table_expression_clause") || set2.contains("function_call") || set2.contains("function");
                if (bl3 && this.identifierPrefix.length() > 0) {
                    ((InsightableOracleDatabase)object).prepareAllSchemas(this.identifierPrefix);
                }
                if (set2.contains("arg")) {
                    block2: for (n5 = n3 - 1; 0 <= n5; --n5) {
                        object7 = (Cell)matrix.get((Object)Service.lPair((int)n5, (int)n3));
                        if (object7 == null) continue;
                        for (int i = 0; i < object7.size(); ++i) {
                            int n6 = object7.getRule(i);
                            String object22 = sqlEarley.allSymbols[sqlEarley.rules[n6].head];
                            if (!"function_call".equals(object22) || !"name".equals(object4 = sqlEarley.allSymbols[sqlEarley.rules[n6].rhs[0]])) continue;
                            object3 = ((LexerToken)arrayList.get((int)n5)).content.toUpperCase();
                            String string3 = ((LexerToken)arrayList.get((int)(n5 + 1))).content;
                            object22 = null;
                            if (".".equals(string3)) {
                                object22 = object3;
                                object3 = ((LexerToken)arrayList.get((int)(n5 + 2))).content;
                            }
                            ((InsightableOracleDatabase)object).prepareArgumentsProc((String)object22, (String)object3);
                            break block2;
                        }
                    }
                }
                int n4 = n5 = set2.contains("column") || set2.contains("assignment_stmt") || set2.contains("expr") ? 1 : 0;
                if (set2.contains("table_reference") || set2.contains("dml_table_expression_clause")) {
                    if (this.identifierPrefix.length() == 0) {
                        ((InsightableOracleDatabase)object).prepareUserTables();
                    } else {
                        ((InsightableOracleDatabase)object).prepareAllTables(null, this.identifierPrefix);
                    }
                } else if (n5 != 0) {
                    if (set2.contains("condition")) {
                        bl2 = true;
                    }
                    object7 = IdentifiersDb.getIdentifierDefs(n3, n3 + 1, parseNode);
                    if (trace) {
                        Iterator iterator = object7.iterator();
                        while (iterator.hasNext()) {
                            ParseNode parseNode2 = (ParseNode)iterator.next();
                            System.out.println(parseNode2);
                        }
                    }
                    TreeMap<ParseNode, ParseNode> treeMap = new TreeMap<ParseNode, ParseNode>();
                    Iterator iterator = object7.iterator();
                    while (iterator.hasNext()) {
                        ParseNode parseNode2 = (ParseNode)iterator.next();
                        object4 = CompletionInsight.findTableAlias(parseNode2);
                        if (object4 != null) {
                            treeMap.put((ParseNode)((Pair)object4).first, (ParseNode)((Pair)object4).second);
                            continue;
                        }
                        if (set == null || parseNode2.contains(IdentifiersDb.instance.table_reference) || (object3 = this.createDatabaseDataItem(arrayList, parseNode, parseNode2)) == null) continue;
                        set.add((SuggestedItem)object3);
                    }
                    if (list != null && lazyNode != null && 0 <= n2) {
                        iterator = IdentifiersDb.getIdentifierDefs(n2, n2 + 1, (ParseNode)lazyNode);
                        Iterator iterator2 = iterator.iterator();
                        while (iterator2.hasNext()) {
                            SuggestedItem suggestedItem;
                            object4 = (ParseNode)iterator2.next();
                            object3 = list.get(((ParseNode)object4).from);
                            if (!((LexerToken)object3).content.toUpperCase().startsWith(this.identifierPrefix) || set == null || (suggestedItem = this.createDatabaseDataItem(list, (ParseNode)lazyNode, (ParseNode)object4)) == null) continue;
                            set.add(suggestedItem);
                        }
                    }
                    for (Member member : this.members) {
                        set.add(new SuggestedItem(member.type, null, member.name));
                    }
                    if (!((InsightableOracleDatabase)object).prepareColumnsCalled) {
                        for (ParseNode parseNode3 : treeMap.keySet()) {
                            object4 = ((ParseNode)treeMap.get(parseNode3)).content(arrayList);
                            if (((String)object4).startsWith("(")) continue;
                            object3 = this.identifierPrefix;
                            String string4 = parseNode3.content(arrayList);
                            if (string4.equalsIgnoreCase(this.identifierPrefix)) {
                                object3 = "";
                            }
                            if (0 < this.identifierPrefix.indexOf(46)) {
                                object3 = this.identifierPrefix.substring(this.identifierPrefix.indexOf(46) + 1);
                            }
                            ((InsightableOracleDatabase)object).prepareColumns((String)object4, (String)object3);
                        }
                    }
                    ((InsightableOracleDatabase)object).prepareColumnsCalled = true;
                    ((InsightableOracleDatabase)object).setTableAliases(this.mapString2String(arrayList, treeMap));
                    if (this.identifierPrefix.length() > 0) {
                        ((InsightableOracleDatabase)object).prepareAllProcedures(null, this.identifierPrefix);
                    }
                }
                if (set2.contains("identifier")) {
                    Map<String, String> map;
                    object7 = parseNode.parent(n3, n3 + 1);
                    if (object7 != null && object7.contains(IdentifiersDb.instance.table_reference)) {
                        if (((ParseNode)object7).from + 3 == ((ParseNode)object7).to) {
                            String string3 = ((LexerToken)arrayList.get((int)((ParseNode)object7).from)).content.toUpperCase();
                            String string4 = this.identifierPrefix.length() > 0 ? this.identifierPrefix : null;
                            ((InsightableOracleDatabase)object).prepareAllTables(string3, string4);
                        }
                    } else if (object7 != null && (object7.contains(IdentifiersDb.instance.column) || object7.contains(IdentifiersDb.instance.select_term))) {
                        void var26_58;
                        StringBuffer stringBuffer = new StringBuffer();
                        for (ParseNode parseNode4 : object7.children()) {
                            if (parseNode4.from == n3) continue;
                            for (int i = parseNode4.from; i < parseNode4.to - 1; ++i) {
                                stringBuffer.append(((LexerToken)arrayList.get((int)i)).content);
                            }
                        }
                        List<ParseNode> list3 = IdentifiersDb.getIdentifierDefs(n3, n3 + 1, parseNode);
                        Object var26_57 = null;
                        object4 = new StringBuffer();
                        object3 = list3.iterator();
                        while (object3.hasNext()) {
                            int n6;
                            ParseNode parseNode5 = (ParseNode)object3.next();
                            Pair<ParseNode, ParseNode> pair = CompletionInsight.findTableAlias(parseNode5);
                            if (pair == null) continue;
                            object22 = (LexerToken)arrayList.get(((ParseNode)pair.first).from);
                            if (!object22.content.toUpperCase().startsWith(stringBuffer.toString().toUpperCase())) continue;
                            map = new StringBuffer();
                            for (n6 = ((ParseNode)pair.first).from; n6 < ((ParseNode)pair.first).to; ++n6) {
                                ((StringBuffer)((Object)map)).append(((LexerToken)arrayList.get((int)n6)).content);
                            }
                            if (stringBuffer.length() > 0 && !((StringBuffer)((Object)map)).toString().equalsIgnoreCase(stringBuffer.toString())) {
                                Object var26_60 = null;
                                object4 = new StringBuffer();
                                continue;
                            }
                            for (n6 = ((ParseNode)pair.second).from; n6 < ((ParseNode)pair.second).to; ++n6) {
                                ((StringBuffer)object4).append(((LexerToken)arrayList.get((int)n6)).content);
                            }
                        }
                        object3 = new HashMap();
                        if (var26_58 != null) {
                            TreeMap<ParseNode, ParseNode> treeMap = new TreeMap<ParseNode, ParseNode>();
                            treeMap.put((ParseNode)var26_58.first, (ParseNode)var26_58.second);
                            object3 = this.mapString2String(arrayList, treeMap);
                        } else if (2 <= n3) {
                            String string5 = ((LexerToken)arrayList.get((int)(n3 - 2))).content.toUpperCase();
                            object3.put(string5, string5);
                            object4 = new StringBuffer(string5);
                        }
                        ((InsightableOracleDatabase)object).setTableAliases((Map<String, String>)object3, true);
                        ((InsightableOracleDatabase)object).prepareColumns(((StringBuffer)object4).toString(), this.identifierPrefix);
                        if (object7 != null && (object7.contains(IdentifiersDb.instance.procedure_call) || object7.contains(IdentifiersDb.instance.function) || object7.contains(IdentifiersDb.instance.simple_expression))) {
                            for (Object object22 : object7.descendants()) {
                                if (!object22.contains(IdentifiersDb.instance.name) && !object22.contains(IdentifiersDb.instance.identifier)) continue;
                                map = ((LexerToken)arrayList.get((int)object22.from)).content.toUpperCase();
                                String string6 = this.identifierPrefix.length() > 0 ? this.identifierPrefix : null;
                                ((InsightableOracleDatabase)object).prepareAllProcedures((String)((Object)map), string6);
                                ((InsightableOracleDatabase)object).prepareAllPkgProc(null, (String)((Object)map), string6);
                                break;
                            }
                        }
                    } else if (n3 > 1 && ".".equals(this.prior.content) && ((LexerToken)arrayList.get((int)(n3 - 2))).type == Token.IDENTIFIER) {
                        String string6 = ((LexerToken)arrayList.get((int)(n3 - 2))).content.toUpperCase();
                        ((InsightableOracleDatabase)object).prepareAllPkgProc(null, string6, this.identifierPrefix);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put(string6, string6);
                        ((InsightableOracleDatabase)object).setTableAliases(hashMap, true);
                        ((InsightableOracleDatabase)object).prepareColumns(string6, this.identifierPrefix);
                        ((InsightableOracleDatabase)object).prepareAllTables(string6, this.identifierPrefix);
                        ((InsightableOracleDatabase)object).prepareAllProcedures(string6, this.identifierPrefix);
                        if (this.members != null) {
                            String string7 = ((LexerToken)arrayList.get((int)(n3 - 2))).content.toUpperCase();
                            object4 = null;
                            block15: for (Member member : this.members) {
                                if (object4 != null) break;
                                if (member.name.toUpperCase().equals(string7)) {
                                    object4 = member.type;
                                    break;
                                }
                                if (!"TYPE".equalsIgnoreCase(member.type)) continue;
                                object22 = member.tooltip.toUpperCase();
                                map = this.parseRecord((String)object22);
                                for (String string8 : map.keySet()) {
                                    if (!string8.equals(string7)) continue;
                                    object4 = map.get(string8);
                                    continue block15;
                                }
                            }
                            if (object4 != null) {
                                for (Member member : this.members) {
                                    if (!"TYPE".equalsIgnoreCase(member.type) || !member.name.toUpperCase().equals(object4)) continue;
                                    object22 = member.tooltip.toUpperCase();
                                    map = this.parseRecord((String)object22);
                                    for (String string8 : map.keySet()) {
                                        set.add(new SuggestedItem(map.get(string8), null, this.alias + "." + string8));
                                    }
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            if (((InsightableOracleDatabase)object).isPrepared()) {
                try {
                    Set<SuggestedItem> set3 = ((InsightableOracleDatabase)object).fetch();
                    if (!((InsightableOracleDatabase)object).colNameOrdering) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int n9 = -1;
                        for (SuggestedItem suggestedItem : set3) {
                            String string9 = "[" + suggestedItem.getName() + "]";
                            stringBuilder.append(++n9 == 0 ? string9 : "," + string9);
                        }
                        set.add(new SuggestedItem("COLUMN", null, stringBuilder.toString()));
                    } else {
                        set.addAll(set3);
                    }
                }
                catch (Exception exception) {
                    if (!trace) break block76;
                    System.err.println(exception.getMessage());
                }
            }
        }
        this.raiselimit = false;
        this.raiseHlimit = false;
        this.raiseSlimit = false;
        this.raiseTlimit = false;
        if (set.size() == 1) {
            this.refreshSuggestedItemsList(set);
            for (SuggestedItem suggestedItem : set) {
                if (!this.identifierPrefix.equalsIgnoreCase(suggestedItem.getName())) continue;
                this._lastLookup = null;
                return;
            }
        }
        if (bl2) {
            set.addAll(this.joinConditions(set, (InsightableOracleDatabase)object));
        }
        this.refreshSuggestedItemsList(set);
        long l2 = System.currentTimeMillis();
        if (timing) {
            System.out.println("Code completion time = " + (l2 - l));
        }
    }

    private Map<String, String> parseRecord(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string.indexOf("RECORD") < 0) {
            return hashMap;
        }
        int n = string.indexOf(40);
        if (n < 0) {
            return hashMap;
        }
        int n2 = string.lastIndexOf(41);
        if (n2 < 0) {
            return hashMap;
        }
        string = string.substring(n + 1, n2 - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n3 = string2.indexOf(32);
            if (n3 < 0) continue;
            String string3 = string2.substring(0, n3);
            String string4 = string2.substring(n3 + 1).toUpperCase().trim();
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private boolean isLegitimate(Cell cell) {
        if (cell == null) {
            return false;
        }
        for (int i = 0; i < cell.size(); ++i) {
            int n = cell.getRule(i);
            int n2 = cell.getPosition(i);
            if (n2 != SqlEarley.getInstance().rules[n].rhs.length) continue;
            return true;
        }
        return false;
    }

    public static Set<String> predict(int n, SqlEarley sqlEarley, Matrix matrix) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i <= n; ++i) {
            Cell cell = (Cell)matrix.get((Object)Service.lPair((int)i, (int)n));
            if (cell == null) continue;
            for (int j = 0; j < cell.size(); ++j) {
                String string;
                int n2 = cell.getRule(j);
                int n3 = cell.getPosition(j);
                if (n3 >= sqlEarley.rules[n2].rhs.length || (string = sqlEarley.allSymbols[sqlEarley.rules[n2].rhs[n3]]).startsWith("xml")) continue;
                treeSet.add(string);
            }
        }
        return treeSet;
    }

    private void fixCode(ArrayList<LexerToken> arrayList, int n, Set<String> set) {
        LexerToken lexerToken = new LexerToken((CharSequence)"du$mY", -2, -1, Token.IDENTIFIER);
        LexerToken lexerToken2 = new LexerToken((CharSequence)"=", -2, -1, Token.OPERATION);
        LexerToken lexerToken3 = new LexerToken((CharSequence)")", -2, -1, Token.OPERATION);
        LexerToken lexerToken4 = new LexerToken((CharSequence)";", -2, -1, Token.OPERATION);
        if (set.contains("';'")) {
            this.insertTokens(arrayList, n, new LexerToken[]{lexerToken4});
            return;
        }
        if (this.prior != null && "(".equals(this.prior.content) && set.contains("')'")) {
            this.insertTokens(arrayList, n, new LexerToken[]{lexerToken3});
            return;
        }
        for (String string : set) {
            if (string.equals("condition") || string.startsWith("update_set_clause")) {
                this.insertTokens(arrayList, n, new LexerToken[]{lexerToken, lexerToken2, lexerToken});
                return;
            }
            if (!string.equals("'='")) continue;
            this.insertTokens(arrayList, n, new LexerToken[]{lexerToken2, lexerToken});
            return;
        }
        this.insertTokens(arrayList, n, new LexerToken[]{lexerToken});
    }

    private void insertTokens(ArrayList<LexerToken> arrayList, int n, LexerToken[] lexerTokenArray) {
        for (LexerToken lexerToken : lexerTokenArray) {
            arrayList.add(n++, lexerToken);
            if (!trace) continue;
            System.out.println("inserted " + lexerToken.content);
        }
    }

    private void refreshSuggestedItemsList(Set<SuggestedItem> set) {
        SuggestedItem[] suggestedItemArray = new SuggestedItem[set.size()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (SuggestedItem suggestedItem : set) {
            boolean bl = false;
            String string = suggestedItem.getName();
            if (string.indexOf("\"") == -1) {
                string = bl ? string.toUpperCase() : string.toLowerCase();
            }
            suggestedItemArray[n] = new SuggestedItem(suggestedItem.getType(), suggestedItem.getOwner(), string);
            suggestedItemArray[n++].doc = suggestedItem.doc;
            if ("COLUMN".equalsIgnoreCase(suggestedItem.getType())) {
                ++n2;
                continue;
            }
            if (!"TABLE".equalsIgnoreCase(suggestedItem.getType()) && !"VIEW".equalsIgnoreCase(suggestedItem.getType())) continue;
            ++n3;
        }
        this._lastLookup = new DBListInsightData(this);
        this._lastLookup.setData(suggestedItemArray);
        if (n2 > 1 || n3 > 1) {
            this._view.setSelectionMode(2);
        } else {
            this._view.setSelectionMode(0);
        }
        this._view.setData((InsightData)this._lastLookup);
        this._view.revalidate();
    }

    private void addSelectFrom(Collection<SuggestedItem> collection, String string) {
        if (!"SELECT * FROM".startsWith(string.toUpperCase())) {
            return;
        }
        SuggestedItem suggestedItem = new SuggestedItem("KEYWORD", "", "SELECT * FROM");
        if (!collection.contains(suggestedItem)) {
            collection.add(suggestedItem);
        }
    }

    private Map<String, String> mapString2String(List<LexerToken> list, Map<ParseNode, ParseNode> map) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (ParseNode parseNode : map.keySet()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = parseNode.from; i < parseNode.to; ++i) {
                stringBuffer.append(list.get((int)i).content);
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            ParseNode parseNode2 = map.get(parseNode);
            for (int i = parseNode2.from; i < parseNode2.to; ++i) {
                stringBuffer2.append(list.get((int)i).content);
            }
            treeMap.put(stringBuffer.toString(), stringBuffer2.toString());
        }
        return treeMap;
    }

    private Set<SuggestedItem> suggestedKeywords(Set<String> set, String string) {
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        String string2 = "'" + string;
        for (String string3 : set) {
            SuggestedItem suggestedItem;
            if (!string3.startsWith(string2) || string3.startsWith("xml") || treeSet.contains(suggestedItem = new SuggestedItem("KEYWORD", null, string3.substring(1, string3.length() - 1)))) continue;
            treeSet.add(suggestedItem);
        }
        SuggestedItem suggestedItem = new SuggestedItem("KEYWORD", null, "SQL");
        treeSet.remove(suggestedItem);
        if (treeSet.size() > 3) {
            treeSet.clear();
        }
        return treeSet;
    }

    private Set<SuggestedItem> suggestedSnippets(Set<String> set, String string, LexerToken lexerToken, Matrix matrix, int n) {
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        if (string.length() == 0) {
            return treeSet;
        }
        treeSet.addAll(HarvestDoc.addTemplates(set, string, lexerToken, matrix, n - 1));
        treeSet.addAll(SqlHistory.addTemplates(set, string, lexerToken, matrix, n - 1));
        treeSet.addAll(this.legacyTemplates(string));
        if (set.contains("table_reference") || set.contains("subquery")) {
            this.addSelectFrom(treeSet, string);
        }
        return treeSet;
    }

    private List<SuggestedItem> legacyTemplates(String string) {
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        try {
            Map map = CodeTemplateUtil.getModel();
            for (String string2 : map.keySet()) {
                String string3;
                if (tSuggestions <= linkedList.size() || "ssf".equals(string2) || (string3 = (String)map.get(string2)) == null || string3.length() == 0 || !string2.toUpperCase().startsWith(string.toUpperCase()) && !string3.toUpperCase().startsWith(string.toUpperCase())) continue;
                linkedList.add(new SuggestedItem("TEMPLATE", null, string3));
            }
            if (linkedList.size() == 3 && tSuggestions == 3) {
                linkedList.add(new SuggestedItem("TEMPLATE", null, "..."));
            }
        }
        catch (Error error) {
            // empty catch block
        }
        return linkedList;
    }

    static int filterOutComments(int n, List<LexerToken> list, List<LexerToken> list2) {
        int n2 = 0;
        int n3 = -1;
        for (LexerToken lexerToken : list) {
            if (!(lexerToken.begin > n || n >= lexerToken.end && lexerToken.end >= 0 || lexerToken.type != Token.COMMENT && lexerToken.type != Token.LINE_COMMENT && lexerToken.type != Token.QUOTED_STRING)) {
                return -1;
            }
            if (n == lexerToken.end && lexerToken.type == Token.LINE_COMMENT) {
                return -1;
            }
            if ((lexerToken.type == Token.IDENTIFIER && lexerToken.begin < n && n <= lexerToken.end || lexerToken.begin <= n && n < lexerToken.end) && n3 == -1) {
                n3 = n2;
            }
            if (lexerToken.type == Token.DQUOTED_STRING && lexerToken.begin < n && n <= lexerToken.end) {
                if (lexerToken.content.toUpperCase().contains("FROM") || lexerToken.content.toUpperCase().contains("WHERE")) {
                    return -2;
                }
                if (n3 == -1) {
                    n3 = n2;
                }
            }
            if (lexerToken.type == Token.WS || lexerToken.type == Token.COMMENT || lexerToken.type == Token.LINE_COMMENT) continue;
            list2.add(lexerToken);
            ++n2;
        }
        if (n3 == -1) {
            n3 = list2.size();
        }
        return n3;
    }

    public static Pair<ParseNode, ParseNode> findTableAlias(ParseNode parseNode) {
        if (!(parseNode.contains(IdentifiersDb.instance.table_reference) || parseNode.contains(IdentifiersDb.instance.cartesian_product) || parseNode.contains(IdentifiersDb.instance.aliased_dml_table_expression_clause))) {
            return null;
        }
        Pair pair = null;
        if (parseNode.children().size() == 0 || parseNode.children().size() == 3) {
            pair = new Pair((Object)parseNode, (Object)parseNode);
        } else if (parseNode.children().size() == 2) {
            ParseNode parseNode2 = null;
            ParseNode parseNode3 = null;
            for (ParseNode parseNode4 : parseNode.children()) {
                if (parseNode4.contains(IdentifiersDb.instance.query_table_expression) || parseNode4.contains(IdentifiersDb.instance.dml_table_expression_clause)) {
                    parseNode3 = parseNode4;
                    continue;
                }
                parseNode2 = parseNode4;
            }
            if (parseNode2 != null && parseNode3 != null) {
                pair = new Pair(parseNode2, parseNode3);
            }
        }
        return pair;
    }

    private SuggestedItem createDatabaseDataItem(List<LexerToken> list, ParseNode parseNode, ParseNode parseNode2) {
        LexerToken lexerToken = list.get(parseNode2.from);
        if (lexerToken.begin > 0) {
            ParseNode parseNode3 = parseNode.parent(parseNode2.from, parseNode2.to);
            if (parseNode3 != null) {
                if (parseNode3.contains(IdentifiersDb.instance.prm_spec) || parseNode3.contains(IdentifiersDb.instance.object_d)) {
                    for (ParseNode parseNode4 : parseNode3.children()) {
                        if (!parseNode4.contains(IdentifiersDb.instance.object_d_rhs) && !parseNode4.contains(IdentifiersDb.instance.unconstrained_type) && !parseNode4.contains(IdentifiersDb.instance.unconstrained_type_wo_datetime)) continue;
                        String string = list.get((int)parseNode4.from).content.toUpperCase();
                        if (!(string.indexOf("CHAR") >= 0 || "INTEGER".equals(string) || "NUMBER".equals(string) || "DATE".equals(string) || "TIMESTAMP".equals(string) || "BOOLEAN".equals(string))) {
                            string = "USER DEFINED";
                        }
                        return new SuggestedItem(string, null, lexerToken.content);
                    }
                }
                if (parseNode3.contains(IdentifiersDb.instance.subprg_spec)) {
                    LexerToken lexerToken2 = list.get(parseNode2.from - 1);
                    if ("function".equalsIgnoreCase(lexerToken2.content)) {
                        return new SuggestedItem("FUNCTION", null, lexerToken.content);
                    }
                    if ("procedure".equalsIgnoreCase(lexerToken2.content)) {
                        return new SuggestedItem("PROCEDURE", null, lexerToken.content);
                    }
                }
            } else {
                return new SuggestedItem("USER DEFINED", null, lexerToken.content);
            }
        }
        return null;
    }

    public InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
        return null;
    }

    public ListInsightView getInsightView() {
        return this._view;
    }

    protected boolean handleCompleteCommand(BasicEditorPane basicEditorPane) {
        boolean bl = this._view.complete((Insight)this);
        basicEditorPane.requestFocus();
        return bl;
    }

    private List<SuggestedItem> joinConditions(Set<SuggestedItem> set, InsightableOracleDatabase insightableOracleDatabase) {
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        int n = 0;
        block0: for (SuggestedItem suggestedItem : set) {
            String string = suggestedItem.getName();
            int n2 = string.indexOf(46);
            if (n2 <= 0 || !"COLUMN".equals(suggestedItem.getType()) || "DATE".equals(suggestedItem.columnType)) continue;
            for (SuggestedItem suggestedItem2 : set) {
                String string2 = suggestedItem2.getName();
                int n3 = string2.indexOf(46);
                if (n3 <= 0 || suggestedItem.compareTo(suggestedItem2) <= 0 || !"COLUMN".equals(suggestedItem.getType()) || !suggestedItem2.columnType.equals(suggestedItem.columnType) || !this.colNamesMatch(string, string2, insightableOracleDatabase)) continue;
                linkedList.add(new SuggestedItem("EQUIJOIN CONDITION", null, string + " = " + string2));
                if (++n <= 50) continue;
                break block0;
            }
        }
        return linkedList;
    }

    private boolean colNamesMatch(String string, String string2, InsightableOracleDatabase insightableOracleDatabase) {
        int n = string.indexOf(46);
        int n2 = string2.indexOf(46);
        String string3 = string.substring(n + 1).toUpperCase();
        String string4 = string2.substring(n2 + 1).toUpperCase();
        if (string3 == null) {
            return false;
        }
        if (string3.equals(string4)) {
            return true;
        }
        String string5 = insightableOracleDatabase.getTable(string.substring(0, n)).toUpperCase();
        String string6 = insightableOracleDatabase.getTable(string2.substring(0, n2)).toUpperCase();
        return string3.startsWith(string5) && string4.equals(string3 + "_ID") || string3.startsWith(string5) && string4.equals(string3 + "_NAME") || string4.startsWith(string6) && string3.equals(string4 + "_ID") || string4.startsWith(string6) && string3.equals(string4 + "_NAME") || this.tabColNamesMatch(string3, string5) && string3.endsWith("_ID") && this.tabColNamesMatch(string4, string6) && string4.endsWith("_ID") || this.tabColNamesMatch(string3, string5) && string3.endsWith("_NAME") && this.tabColNamesMatch(string4, string6) && string4.endsWith("_NAME");
    }

    private boolean tabColNamesMatch(String string, String string2) {
        if (string2.length() < 5 || string.length() < 5) {
            return false;
        }
        for (int i = 0; i < string2.length() - 5; ++i) {
            String string3 = string2.substring(i, i + 5);
            if (!string.contains(string3)) continue;
            return true;
        }
        return false;
    }

    class InsightThread
    extends Thread {
        public InsightThread(String string) {
            super(string);
        }

        @Override
        public void run() {
            Object object2;
            int n;
            int n2;
            TextBuffer textBuffer = CompletionInsight.this.getTextBuffer();
            CompletionInsight.this.startCaretPosition = CompletionInsight.this.getCaretPosition();
            int n3 = CompletionInsight.this.startCaretPosition - 5000;
            int n4 = CompletionInsight.this.startCaretPosition + 5000;
            if (CompletionInsight.this.startCaretPosition < 5000) {
                n3 = 0;
            }
            if ((n2 = textBuffer.getLength()) < n4) {
                n4 = n2;
            }
            LazyNode lazyNode = null;
            int n5 = CompletionInsight.this.startCaretPosition;
            List<LexerToken> list = null;
            if (CompletionInsight.this.parser != null && CompletionInsight.this.parser.src != null && CompletionInsight.this.parser.output != null) {
                lazyNode = CompletionInsight.this.parser.output;
                list = CompletionInsight.this.parser.src;
                n5 = CompletionInsight.this.parser.recalculatePosition(n5);
                for (n = 0; n < list.size() && n5 >= list.get((int)n).end; ++n) {
                }
            }
            if (list != null && lazyNode != null) {
                for (Object object2 : lazyNode.shallowChildren()) {
                    if (!"package".equalsIgnoreCase(object2.startToken)) continue;
                    block4: for (LazyNode lazyNode2 : object2.shallowChildren()) {
                        if (!lazyNode2.isAs()) continue;
                        for (LazyNode lazyNode3 : lazyNode2.shallowChildren()) {
                            if (!lazyNode3.isProcedure()) continue;
                            int n6 = list.get((int)lazyNode3.to).begin;
                            if (n6 < n5) {
                                if (n3 >= n6) continue;
                                n3 = n6;
                                continue;
                            }
                            int n7 = list.get((int)lazyNode3.from).begin;
                            if (n7 <= n5 && n5 < n6) {
                                if (n3 < n7) {
                                    n3 = n7;
                                }
                                if (n6 >= n4) continue block4;
                                n4 = n6;
                                continue block4;
                            }
                            if (n5 >= n7 || n7 >= n4) continue;
                            n4 = n7;
                        }
                    }
                }
                for (Object object2 : lazyNode.shallowDescendants()) {
                    LazyNode lazyNode4 = object2;
                    if (list.size() == 0) continue;
                    int n8 = list.get((int)lazyNode4.from).begin;
                    int n9 = list.get((int)(lazyNode4.to - 1)).end + 1;
                    if (n8 > n5 || n5 >= n9 || !lazyNode4.isDML() && !lazyNode4.isStmt(lazyNode)) continue;
                    if (n3 < n8) {
                        n3 = n8;
                    }
                    if (n9 >= n4) continue;
                    n4 = n9;
                }
            }
            int n10 = CompletionInsight.this.startCaretPosition - n3;
            object2 = null;
            try {
                object2 = textBuffer.getString(n3, n4 - n3);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Log.error((String)("textBuffer.getString(" + n3 + ", " + (n4 - n3) + ")"));
                return;
            }
            CompletionInsight.this.complete((String)object2, list, lazyNode, n10, n, true);
        }
    }
}

