/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.ddl.DDLRegistry;
import oracle.dbtools.raptor.dialogs.actions.TableExportAction;
import oracle.dbtools.raptor.export.Messages;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.MenuConstants;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;

public class ExportContextMenuListener
implements ContextMenuListener {
    private static final String RESULTS_TABLE = "RESULTS_TABLE";
    private JMenu _menu;
    private TableExportAction _action = new TableExportAction();
    private static ExportContextMenuListener _instance;
    private static final Object LOCK;

    private ExportContextMenuListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExportContextMenuListener getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new ExportContextMenuListener();
            }
        }
        return _instance;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        if (!TableExportAction.isExportInProgress()) {
            this._action.clearData();
            Context context = contextMenu.getContext();
            ExtractListModel extractListModel = null;
            boolean bl = true;
            View view = context.getView();
            if (!(view instanceof NavigatorWindow) || ((NavigatorWindow)view).getManager().getClass().equals(DatabaseNavigatorManager.class)) {
                if (view instanceof NavigatorWindow && ((NavigatorWindow)view).getManager().getClass().equals(DatabaseNavigatorManager.class)) {
                    Element[] elementArray = context.getSelection();
                    if (elementArray.length == 0) {
                        bl = false;
                    }
                    DBObject[] dBObjectArray = new DBObject[elementArray.length];
                    for (int i = 0; i < elementArray.length; ++i) {
                        if (!(elementArray[i] instanceof Node)) continue;
                        dBObjectArray[i] = this.getDBObject((Node)elementArray[i]);
                    }
                    extractListModel = this.getlistModel(dBObjectArray);
                    bl = extractListModel != null;
                } else if (contextMenu.getContext().getEvent() != null && contextMenu.getContext().getEvent().getSource() instanceof ResultSetTable) {
                    JTable jTable = (JTable)contextMenu.getContext().getEvent().getSource();
                    String string = ((IResultSetTableModel)((Object)jTable.getModel())).getConnectionName();
                    extractListModel = new ExtractListModel(jTable, string);
                } else if (contextMenu.getContext().getProperty(RESULTS_TABLE) != null && contextMenu.getContext().getProperty(RESULTS_TABLE) instanceof ResultSetTable) {
                    JTable jTable = (JTable)contextMenu.getContext().getProperty(RESULTS_TABLE);
                    String string = ((IResultSetTableModel)((Object)jTable.getModel())).getConnectionName();
                    extractListModel = new ExtractListModel(jTable, string);
                } else {
                    Node node = contextMenu.getContext().getNode();
                    if (node instanceof IViewerNode) {
                        node = ((IViewerNode)node).getBaseNode();
                    }
                    if (node instanceof DatabaseNode) {
                        DBObject dBObject = this.getDBObject(node);
                        DBObject[] dBObjectArray = new DBObject[]{dBObject};
                        extractListModel = this.getlistModel(dBObjectArray);
                        bl = extractListModel != null;
                    } else {
                        bl = false;
                    }
                }
                if (bl) {
                    this._action.setListModel(extractListModel);
                    contextMenu.add((Component)this.getMenuItem(bl), MenuConstants.SECTION_FILE_IMPORT_EXPORT);
                }
                contextMenu.sortContainer(contextMenu.getGUI(true));
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public JMenuItem getMenuItem(boolean bl) {
        String string = Messages.getString("ExportContextMenuListener.1");
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportContextMenuListener.this._action.setArgs(actionEvent.getActionCommand());
                if (ExportContextMenuListener.this._action.getListModel() != null) {
                    if (ExportContextMenuListener.this._action.getListModel().isSourceConnOracle()) {
                        ExportContextMenuListener.this._action.launchForDataAndDDL();
                    } else {
                        ExportContextMenuListener.this._action.launchForData();
                    }
                } else {
                    ExportContextMenuListener.this._action.launchDlg();
                }
            }
        });
        return jMenuItem;
    }

    public JMenu getMenu(boolean bl) {
        Object object;
        if (this._menu == null) {
            this._menu = new JMenu(Messages.getString("ExportContextMenuListener.1"));
            object = Messages.getString("ExportContextMenuListener.2");
            JMenuItem jMenuItem = new JMenuItem((String)object);
            jMenuItem.setActionCommand((String)object);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExportContextMenuListener.this._action.setArgs(actionEvent.getActionCommand());
                    if (ExportContextMenuListener.this._action.getDBObject() != null) {
                        ExportContextMenuListener.this._action.launchForDDL();
                    } else {
                        ExportContextMenuListener.this._action.launchDlg();
                    }
                }
            });
            this._menu.add(jMenuItem);
            if (bl) {
                object = Messages.getString("ExportContextMenuListener.0");
                jMenuItem = new JMenuItem((String)object);
                jMenuItem.setActionCommand((String)object);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ExportContextMenuListener.this._action.setArgs(actionEvent.getActionCommand());
                        if (ExportContextMenuListener.this._action.getDBObject() != null) {
                            ExportContextMenuListener.this._action.launchForData();
                        } else {
                            ExportContextMenuListener.this._action.launchDlg();
                        }
                    }
                });
                this._menu.add(jMenuItem);
                object = Messages.getString("ExportContextMenuListener.3");
                jMenuItem = new JMenuItem((String)object);
                jMenuItem.setActionCommand((String)object);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ExportContextMenuListener.this._action.setArgs(actionEvent.getActionCommand());
                        if (ExportContextMenuListener.this._action.getDBObject() != null) {
                            ExportContextMenuListener.this._action.launchForDataAndDDL();
                        } else {
                            ExportContextMenuListener.this._action.launchDlg();
                        }
                    }
                });
                this._menu.add(jMenuItem);
            }
        }
        object = new MnemonicSolver(this._menu);
        object.solve();
        return this._menu;
    }

    private DBObject getDBObject(Node node) {
        if (node instanceof ObjectNode && ((ObjectNode)node).getObjectType().equals("MATERIALIZED VIEW LOG")) {
            ObjectNode objectNode = (ObjectNode)node;
            URL uRL = DBURLFormatHelper.getURL("sqldev.nav", objectNode.getConnectionName(), null, objectNode.getSchemaName(), objectNode.getObjectType());
            URL uRL2 = DBURLFormatHelper.getURL(uRL, objectNode.getShortLabel());
            return new DBObject(uRL2);
        }
        DBObject dBObject = new DBObject((Element)node);
        return dBObject.isValid() ? dBObject : null;
    }

    private ExtractListModel getlistModel(DBObject[] dBObjectArray) {
        ExtractListModel extractListModel = null;
        boolean bl = true;
        if (dBObjectArray.length == 0) {
            bl = false;
            return null;
        }
        for (DBObject dBObject : dBObjectArray) {
            if (dBObject == null) {
                bl = false;
                break;
            }
            if (dBObject.isTimesTen() || !dBObject.isOracle()) {
                if (!(dBObject.getNode() instanceof CloudObject)) break;
                bl = false;
                break;
            }
            if (DDLRegistry.isSupported(dBObject.getKey()) && !dBObject.getObjectType().equals("APEX")) continue;
            bl = false;
            break;
        }
        if (bl) {
            extractListModel = new ExtractListModel(dBObjectArray);
            bl = extractListModel.isSourceConnOracle() ? extractListModel.isPreSelected() : extractListModel.isPreSelectedDataExtractable();
        }
        return bl ? extractListModel : null;
    }

    static {
        LOCK = new Object();
    }
}

