/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.listtable.ListTableModel;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.ui.panels.ColumnPanel;
import oracle.dbtools.raptor.extract.ui.panels.PredicatePanel;
import oracle.dbtools.raptor.format.IExportFormatOptions;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.icons.OracleIcons;

public class FilterListTableModel
extends ListTableModel<ExtractObject> {
    private static final long serialVersionUID = 1L;
    private static final int URL = 0;
    private static final int COLUMNS = 1;
    private static final int WHERE = 2;
    private static final String[] COL_NAMES = new String[]{ExtractResources.getString("EO_URL"), ExtractResources.getString("EO_COLUMNS"), ExtractResources.getString("EO_WHERE")};
    private static final String[] COL_TIPS = new String[]{ExtractResources.getString("EO_URL_TIP"), ExtractResources.getString("EO_COLUMNS_TIP"), ExtractResources.getString("EO_WHERE_TIP")};

    public FilterListTableModel() {
        super(COL_NAMES, COL_TIPS);
    }

    @Override
    public void setTable(JTable jTable) {
        super.setTable(jTable);
        jTable.setDefaultRenderer(URL.class, new URLCellRenderer());
        jTable.setDefaultEditor(String.class, new CustomCellEditor());
        jTable.setSurrendersFocusOnKeystroke(true);
        jTable.setSelectionMode(0);
        jTable.setCellSelectionEnabled(true);
    }

    @Override
    protected Object getValueAt(ExtractObject extractObject, int n) {
        switch (n) {
            case 0: {
                return extractObject.getUrl();
            }
            case 1: {
                return extractObject.getColumns();
            }
            case 2: {
                return extractObject.getWhere();
            }
        }
        return null;
    }

    @Override
    protected boolean isCellEditable(ExtractObject extractObject, int n) {
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                IExportFormatOptions iExportFormatOptions = (IExportFormatOptions)extractObject.getListModel().getDataFormat().getOptions();
                return iExportFormatOptions != null && iExportFormatOptions.isColumnListFilterable();
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setValueAt(Object object, ExtractObject extractObject, int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                extractObject.setColumns((String)object);
                break;
            }
            case 2: {
                extractObject.setWhere((String)object);
                break;
            }
        }
    }

    class CustomCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        JTable _table;
        ExtractObject _dataObject;
        Object _value;
        int _rowIndex;
        int _vColIndex;
        ColumnPanel _columnEditor;
        PredicatePanel _whereEditor;
        JButton _editButton;

        CustomCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this._table = jTable;
            this._value = object;
            this._rowIndex = n;
            this._vColIndex = n2;
            this._dataObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            this._editButton = new JButton(OracleIcons.getIcon((String)"edit.png"));
            this._editButton.setMargin(new Insets(2, 2, 2, 2));
            this._editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomCellEditor.this.handleEdit();
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout()){
                private static final long serialVersionUID = 1L;

                @Override
                public void requestFocus() {
                    CustomCellEditor.this._editButton.requestFocus();
                }
            };
            jPanel.setName("CustomCellEditor.Panel" + n2);
            JLabel jLabel = new JLabel((String)object);
            jPanel.add("Center", jLabel);
            jPanel.add("East", this._editButton);
            this._editButton.setName("CustomCellEditor.EditButton" + n2);
            return jPanel;
        }

        private void handleEdit() {
            if (this.isColumnEdit()) {
                this._columnEditor = new ColumnPanel(this._dataObject, (String)this._table.getModel().getValueAt(this._rowIndex, this._vColIndex));
                Dimension dimension = this._columnEditor.getPreferredSize();
                int n = (int)dimension.getHeight();
                int n2 = (int)dimension.getWidth() + 200;
                dimension.setSize(n2, n);
                this._columnEditor.setSize(dimension);
                this._columnEditor.setPreferredSize(dimension);
                HelpSystem.getHelpSystem().registerTopic((JComponent)this._columnEditor, "f1_idedexporttabledata_html");
                if (WizardLauncher.runDialog((JDialog)this.getDialog(this._columnEditor, ExtractResources.getString("EO_TITLE_COLUMNS")))) {
                    if (this._whereEditor != null) {
                        this._whereEditor.setDirty();
                    }
                    this._value = this._columnEditor.toString();
                    this.stopCellEditing();
                } else {
                    this.cancelCellEditing();
                }
            } else {
                this._whereEditor = new PredicatePanel(this._dataObject, (String)this._table.getModel().getValueAt(this._rowIndex, this._vColIndex));
                HelpSystem.getHelpSystem().registerTopic((JComponent)this._whereEditor, "f1_idedexporttabledata_html");
                this._whereEditor.setVerticalDisplay(false);
                if (WizardLauncher.runDialog((JDialog)this.getDialog(this._whereEditor, ExtractResources.getString("EO_TITLE_WHERE")))) {
                    this._dataObject.setTable((JTable)((Object)this._whereEditor.getTable()));
                    this._value = this._whereEditor.toString();
                    this.stopCellEditing();
                } else {
                    this.cancelCellEditing();
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CustomCellEditor.this._table.isVisible()) {
                        CustomCellEditor.this._table.requestFocusInWindow();
                    }
                }
            });
        }

        private JEWTDialog getDialog(Component component, String string) {
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)component, null, (String)string, (int)5);
            jEWTDialog.setResizable(true);
            jEWTDialog.setOKButtonEnabled(true);
            return jEWTDialog;
        }

        @Override
        public Object getCellEditorValue() {
            return this._value == null ? "" : this._value;
        }

        private boolean isColumnEdit() {
            return this._vColIndex == 1;
        }
    }

    class URLCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        URLCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            String string = null == object ? null : object.toString();
            URL uRL = null;
            if (object != null && object instanceof URL) {
                uRL = (URL)object;
                object2 = DBURLFormatHelper.getConnectionName(uRL);
                String string2 = object2 == null ? null : Connections.getInstance().getConnectionInfo((String)object2).getProperty("user");
                String string3 = DBURLFormatHelper.getSchema(uRL);
                string = string2 != null && string3 != null && string3.length() > 0 && !string2.equals(string3) ? string3 + "." + DBURLFormatHelper.getName(uRL) : DBURLFormatHelper.getName(uRL);
            }
            object2 = (JLabel)super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            ((JComponent)object2).putClientProperty("URL", uRL);
            ((JLabel)object2).setIcon(DBURLFormatHelper.getIcon(uRL));
            return object2;
        }
    }
}

