/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class ExtractReconciler {
    ExtractListModel _listModel;
    private static final Logger LOGGER = Logger.getLogger(ExtractReconciler.class.getName());

    public ExtractReconciler(ExtractListModel extractListModel) {
        this._listModel = extractListModel;
    }

    /*
     * Could not resolve type clashes
     */
    public void reconcileTypesAndObjects(int n) {
        DDLTypes dDLTypes = this._listModel.getDDLTypes();
        DDLFormat dDLFormat = this._listModel.getDDLFormat();
        boolean bl = false;
        LinkedHashMap<String, String> linkedHashMap = dDLTypes.getTypes(this._listModel.isDataEnabled());
        ArrayList arrayList = (ArrayList)this._listModel.getListURLs(0, new int[]{108});
        ArrayList arrayList2 = (ArrayList)this._listModel.getListURLs(0, new int[]{109});
        ArrayList arrayList3 = (ArrayList)this._listModel.getURLListForType(arrayList, "TABLE");
        String string = null;
        Connection connection = null;
        String string2 = null;
        if (n == 103) {
            string = this._listModel.getSourceConnName();
            connection = this._listModel.getSourceConn();
            string2 = this._listModel.getSourceConnUser();
        } else if (n == 104 && this._listModel.getDestConn() != null) {
            string = this._listModel.getDestConnName();
            connection = this._listModel.getDestConn();
            string2 = this._listModel.getDestConnUser();
        } else {
            return;
        }
        String[] stringArray = new String[]{""};
        if (this._listModel.getSchemas().length > 0 || this._listModel.getTablespaces() != null && this._listModel.getTablespaces().length > 0) {
            stringArray = this._listModel.getSchemas();
        } else {
            stringArray[0] = string2;
        }
        block0: for (String string3 : stringArray) {
            for (String string4 : linkedHashMap.keySet()) {
                List<Object> list;
                Object object;
                List<DBObject> list2;
                if (bl) continue block0;
                String string5 = (String)linkedHashMap.get(string4);
                if (string4.equals("DATA")) {
                    list2 = string4;
                    object = new String[DDLTypes.DATA_OBJECT_TYPES.length];
                    int n2 = 0;
                    if (dDLTypes.getTable()) {
                        object[n2++] = "TABLE";
                    }
                    if (dDLTypes.getView() && this.isExportViews(arrayList2, "VIEW")) {
                        object[n2++] = "VIEW";
                    }
                    if (dDLTypes.getMatView() && this.isExportViews(arrayList2, "MATERIALIZED VIEW")) {
                        object[n2++] = "MATERIALIZED VIEW";
                    }
                    for (n2 = 0; n2 < ((String[])object).length && object[n2] != null; ++n2) {
                        list2 = "TABLE";
                        string5 = (String)linkedHashMap.get("TABLE");
                        if (((String)object[n2]).equals("VIEW")) {
                            list2 = "VIEW";
                            string5 = (String)linkedHashMap.get("VIEW");
                        } else if (((String)object[n2]).equals("MATERIALIZED VIEW")) {
                            list2 = "MATERIALIZED VIEW";
                            string5 = (String)linkedHashMap.get("MATERIALIZED VIEW");
                        }
                        if (this._listModel.isExistsForType(arrayList2, (String)object[n2])) {
                            list = this._listModel.getURLListForType(arrayList2, (String)object[n2]);
                            for (Object object2 : list) {
                                DBObject dBObject = this.getDBObject((URL)object2);
                                this._listModel.getOrAddExtractObject(dBObject, new int[]{101, n});
                            }
                            continue;
                        }
                        list = DDLGenerator.getInstance().getSchemaObjects(connection, string3, (String)((Object)list2), string5);
                        if (list == null) continue;
                        for (Object object2 : list) {
                            this._listModel.getOrAddExtractObject((DBObject)object2, new int[]{101, n});
                        }
                    }
                    continue;
                }
                if (dDLFormat.isExtractEnabled() && (string4.equals("CONSTRAINT") || string4.equals("REFCONSTRAINT")) && arrayList3.size() > 0) {
                    list2 = arrayList3.iterator();
                    while (list2.hasNext()) {
                        Object object2;
                        object = (URL)list2.next();
                        DBObject dBObject = this.getDBObject((URL)object);
                        list = DBURLFormatHelper.getURL("sqldev.nav", string, null, dBObject.getSchemaName(), string4);
                        Iterator<Object> iterator = DBURLFormatHelper.getURL((URL)((Object)list), dBObject.getObjectName());
                        object2 = new DBObject((URL)((Object)iterator));
                        this._listModel.getOrAddExtractObject((DBObject)object2, new int[]{100, n});
                    }
                    continue;
                }
                if (dDLFormat.isExtractEnabled() && string4.equals("TRIGGER") && arrayList3.size() > 0) {
                    list2 = arrayList3.iterator();
                    while (list2.hasNext()) {
                        object = (URL)list2.next();
                        DBObject dBObject = this.getDBObject((URL)object);
                        list = this.getTriggerFilter(connection, dBObject.getSchemaName(), dBObject.getObjectName());
                        for (Object object2 : list) {
                            this._listModel.getOrAddExtractObject((DBObject)object2, new int[]{100, n});
                            this.addDependents((DBObject)object2, n);
                        }
                    }
                    continue;
                }
                if (dDLFormat.isExtractEnabled() && string4.equals("INDEX") && arrayList3.size() > 0) {
                    list2 = arrayList3.iterator();
                    while (list2.hasNext()) {
                        object = (URL)list2.next();
                        DBObject dBObject = this.getDBObject((URL)object);
                        list = this.getIndexFilter(connection, dBObject.getSchemaName(), dBObject.getObjectName());
                        for (Object object2 : list) {
                            this._listModel.getOrAddExtractObject((DBObject)object2, new int[]{100, n});
                            this.addDependents((DBObject)object2, n);
                        }
                    }
                    continue;
                }
                if (this._listModel.isExistsForType(arrayList, string4) && dDLFormat.isExtractEnabled()) {
                    list2 = this._listModel.getURLListForType(arrayList, string4);
                    for (URL uRL : list2) {
                        list = this.getDBObject(uRL);
                        this._listModel.getOrAddExtractObject((DBObject)((Object)list), new int[]{100, n});
                        this.addDependents((DBObject)((Object)list), n);
                    }
                    continue;
                }
                if (!dDLFormat.isExtractEnabled() || (list2 = this._listModel.getTablespaces() == null ? DDLGenerator.getInstance().getSchemaObjects(connection, string3, string4, string5) : this.getTablespaceScemaObjects(connection, string3, string4)) == null) continue;
                for (DBObject dBObject : list2) {
                    this._listModel.getOrAddExtractObject(dBObject, new int[]{100, n});
                    this.addDependents(dBObject, n);
                }
            }
        }
    }

    public void reconcileObjects(int n) {
        DDLTypes dDLTypes = this._listModel.getDDLTypes();
        DDLFormat dDLFormat = this._listModel.getDDLFormat();
        boolean bl = false;
        LinkedHashMap<String, String> linkedHashMap = dDLTypes.getTypes(this._listModel.isDataEnabled());
        ArrayList arrayList = (ArrayList)this._listModel.getListForType(this._listModel.getList(0, new int[]{100}), "TABLE");
        String string = null;
        Connection connection = null;
        for (String string2 : linkedHashMap.keySet()) {
            List<DBObject> list;
            DBObject dBObject;
            if (bl) break;
            if (dDLFormat.isExtractEnabled() && (string2.equals("CONSTRAINT") || string2.equals("REFCONSTRAINT")) && arrayList.size() > 0) {
                for (ExtractObject extractObject : arrayList) {
                    string = extractObject.getSourceConnName();
                    dBObject = this.getDBObject(extractObject.getUrl());
                    list = DBURLFormatHelper.getURL("sqldev.nav", string, null, dBObject.getSchemaName(), string2);
                    Iterator<DBObject> iterator = DBURLFormatHelper.getURL((URL)((Object)list), dBObject.getObjectName());
                    DBObject dBObject2 = new DBObject((URL)((Object)iterator));
                    this._listModel.getOrAddExtractObject(dBObject2, new int[]{100, n});
                }
                continue;
            }
            if (dDLFormat.isExtractEnabled() && dDLFormat.getTrigger() && string2.equals("TRIGGER") && arrayList.size() > 0) {
                for (ExtractObject extractObject : arrayList) {
                    connection = extractObject.getSourceConn();
                    dBObject = this.getDBObject(extractObject.getUrl());
                    list = this.getTriggerFilter(connection, dBObject.getSchemaName(), dBObject.getObjectName());
                    for (DBObject dBObject2 : list) {
                        this._listModel.getOrAddExtractObject(dBObject2, new int[]{100, n});
                    }
                }
                continue;
            }
            if (!dDLFormat.isExtractEnabled() || !string2.equals("INDEX") || arrayList.size() <= 0) continue;
            for (ExtractObject extractObject : arrayList) {
                connection = extractObject.getSourceConn();
                dBObject = this.getDBObject(extractObject.getUrl());
                list = this.getIndexFilter(connection, dBObject.getSchemaName(), dBObject.getObjectName());
                for (DBObject dBObject2 : list) {
                    this._listModel.getOrAddExtractObject(dBObject2, new int[]{100, n});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBObject> getTablespaceScemaObjects(Connection connection, String string, String string2) {
        String[] stringArray;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        String string3 = "select o.owner,o.object_name,o.object_type from dba_segments s, dba_objects o where s.segment_type = o.object_type and s.segment_name = o.object_name and s.tablespace_name = :TABLESPACE and o.owner = :OWNER and o.object_type = :TYPE ";
        for (String string4 : stringArray = this._listModel.getTablespaces()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            URL uRL = null;
            ResultSetWrapper resultSetWrapper = null;
            hashMap.put("OWNER", string);
            hashMap.put("TABLESPACE", string4);
            hashMap.put("TYPE", string2);
            if (!Connections.getInstance().lock(connection)) continue;
            try {
                resultSetWrapper = DBUtil.getInstance((Connection)connection).executeQuery(string3, hashMap);
                String string5 = Connections.getInstance().getConnectionName(connection);
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string5, null, resultSet.getString(1), resultSet.getString(3));
                    uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(2));
                    arrayList.add(new DBObject(uRL));
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    public void reconcileDestFromSource() {
        if (this._listModel.getDestConn() == null) {
            return;
        }
        ArrayList<ExtractObject> arrayList = this._listModel.getList(0);
        for (ExtractObject extractObject : arrayList) {
            DBObject dBObject = extractObject.getDBObject();
            boolean bl = this.isConnDba(this._listModel.getDestConn());
            if (this._listModel.getSchemas() != null && this._listModel.getDDLFormat() != null && this._listModel.getDDLFormat().getSchema()) {
                extractObject.isExistsDest(this.isExistsObject(this._listModel.getDestConn(), bl, extractObject.getDBObject().getSchemaName(), dBObject.getObjectName(), dBObject.getObjectType()));
                continue;
            }
            if (this._listModel.getDDLFormat().getIgnoreSchema()) {
                extractObject.isExistsDest(this.isExistsObject(this._listModel.getDestConn(), bl, this._listModel.getDestConnUser(), dBObject.getObjectName(), dBObject.getObjectType()));
                continue;
            }
            extractObject.isExistsDest(this.isExistsObject(this._listModel.getDestConn(), bl, dBObject.getSchemaName(), dBObject.getObjectName(), dBObject.getObjectType()));
        }
    }

    private DBObject getDBObject(URL uRL) {
        DBObject dBObject = this._listModel.getDBObject(uRL);
        return dBObject != null ? dBObject : new DBObject(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnDba(Connection connection) {
        String string = "select 1 from DBA_OBJECTS where 1=2";
        Statement statement = null;
        boolean bl = false;
        try {
            if (connection != null) {
                statement = connection.createStatement();
                statement.execute(string);
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 942) {
                LOGGER.severe(sQLException.getMessage());
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExistsObject(Connection connection, boolean bl, String string, String string2, String string3) {
        String string4 = " select 1 from " + (bl ? "dba_objects" : "all_objects") + " where owner = :OWNER " + " and object_type = :TYPE " + " and object_name = :NAME " + " union all " + " select 1 from all_db_links where owner = :OWNER " + " and :TYPE = 'DATABASE LINK' " + " and db_link = :NAME" + " union all " + " select 1 from all_snapshot_logs where log_owner = :OWNER " + " and master = :NAME";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSetWrapper resultSetWrapper = null;
        hashMap.put("OWNER", string);
        hashMap.put("NAME", string2);
        hashMap.put("TYPE", string3);
        if (Connections.getInstance().lock(connection)) {
            try {
                resultSetWrapper = DBUtil.getInstance((Connection)connection).executeQuery(string4, hashMap);
                ResultSet resultSet = resultSetWrapper.getResultSet();
                if (resultSet.next()) {
                    boolean bl2 = true;
                    return bl2;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBObject> getObjectDeps(Connection connection, String string, String string2, String string3) {
        String string4 = "\tselect referenced_owner, referenced_name, referenced_type from ALL_DEPENDENCIES where owner = :OWNER and name = :NAME and type = decode(:TYPE,'QUEUE','UNDEFINED',:TYPE) and referenced_owner != 'SYS'  union  select b.owner, b.table_name,'TABLE' type from ALL_CONSTRAINTS a, all_constraints b  where a.owner = :OWNER  and a.table_name = :NAME  and a.constraint_type = 'R'  and a.r_constraint_name = b.constraint_name  and a.owner = b.owner  and :TYPE='TABLE'  union  select log_owner,master,'TABLE' from all_snapshot_logs where master = :NAME and :TYPE='MATERIALIZED VIEW LOG'  union  select table_owner owner,table_name name,  case (select count(*) from all_objects where object_name = table_name and owner = :OWNER \t) when 1 then 'TABLE'  when 2 then 'MATERIALIZED VIEW'  else 'UNKNOWN'  end as type  from all_indexes where index_name = :NAME and owner = :OWNER and :TYPE = 'INDEX' ";
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL uRL = null;
        ResultSetWrapper resultSetWrapper = null;
        hashMap.put("OWNER", string);
        hashMap.put("NAME", string2);
        hashMap.put("TYPE", string3);
        if (Connections.getInstance().lock(connection)) {
            try {
                resultSetWrapper = DBUtil.getInstance((Connection)connection).executeQuery(string4, hashMap);
                String string5 = Connections.getInstance().getConnectionName(connection);
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string5, null, resultSet.getString(1), resultSet.getString(3));
                    uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(2));
                    arrayList.add(new DBObject(uRL));
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBObject> getTriggerFilter(Connection connection, String string, String string2) {
        String string3 = "Select trigger_name from all_triggers where table_owner = :OWNER and table_name = :NAME";
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL uRL = null;
        ResultSetWrapper resultSetWrapper = null;
        hashMap.put("OWNER", string);
        hashMap.put("NAME", string2);
        if (Connections.getInstance().lock(connection)) {
            resultSetWrapper = DBUtil.getInstance((Connection)connection).executeQuery(string3, hashMap);
            String string4 = Connections.getInstance().getConnectionName(connection);
            try {
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string4, null, string, "TRIGGER");
                    uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(1));
                    arrayList.add(new DBObject(uRL));
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBObject> getIndexFilter(Connection connection, String string, String string2) {
        String string3 = "Select index_name from all_indexes where table_owner = :OWNER and table_name = :NAME";
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL uRL = null;
        ResultSetWrapper resultSetWrapper = null;
        hashMap.put("OWNER", string);
        hashMap.put("NAME", string2);
        if (Connections.getInstance().lock(connection)) {
            resultSetWrapper = DBUtil.getInstance((Connection)connection).executeQuery(string3, hashMap);
            String string4 = Connections.getInstance().getConnectionName(connection);
            try {
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string4, null, string, "INDEX");
                    uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(1));
                    arrayList.add(new DBObject(uRL));
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    private void addDependents(DBObject dBObject, int n) {
        if (this._listModel.getDDLFormat() == null || !this._listModel.getDDLFormat().getDep()) {
            return;
        }
        if (!this._listModel.isSelectedData() && !this._listModel.isSelectedMetaData()) {
            return;
        }
        List<DBObject> list = this.getObjectDeps(this._listModel.getSourceConn(), dBObject.getSchemaName(), dBObject.getObjectName(), dBObject.getObjectType());
        for (DBObject dBObject2 : list) {
            this._listModel.getOrAddExtractObject(dBObject2, new int[]{100, n});
        }
    }

    private boolean isExportViews(ArrayList<URL> arrayList, String string) {
        if (this._listModel.getDataFormat().isLoader()) {
            return false;
        }
        if (!this._listModel.getDataFormat().isInsert()) {
            return true;
        }
        return this._listModel.isExistsForType(arrayList, string);
    }
}

