/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IExportFormatOptions;
import oracle.ide.panels.TraversableContext;

public class ExtractDataFormat
extends BaseDataFormat {
    public static final String KEY_DATAFORMAT = "DATAFORMAT";
    public static String LDR_DEFAULT_DELIMITER = "|";
    private boolean _exportEnabled;
    private String _tableName;
    private boolean _isTableNameVisible;
    private boolean _saveQuery;
    private String _queryName;
    private String _dataName;
    private boolean _isTruncate = false;
    private boolean _isDisableConstraints = false;
    private boolean _separateDataFile;
    private boolean _ldrLogFile = true;
    private String _ldrLogDir;
    private boolean _ldrBadFile = false;
    private String _ldrBadDir;
    private String _title;
    private String _subject;
    private String _keywords;
    private boolean _useConfigOptions = true;
    private int _variableLengthMax = -1;

    public ExtractDataFormat(int n, String string) {
        super(n, string);
    }

    public ExtractDataFormat(int n) {
        super(n);
    }

    public boolean isExportEnabled() {
        return this._exportEnabled;
    }

    public void isExportEnabled(boolean bl) {
        this._exportEnabled = bl;
    }

    @Override
    public String[] getFormats() {
        List list = FormatRegistry.getTypes();
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (String string : list) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public boolean getHeader() {
        return this._options != null && this._options.isHeaderOptionSupported() ? this._header : false;
    }

    public void setHeader(boolean bl) {
        if (this._options == null) {
            return;
        }
        this._header = bl;
    }

    public boolean isSeparateDataFile() {
        return this._options != null && ((IExportFormatOptions)this._options).isSeparateDataFileSupported() ? this._separateDataFile : false;
    }

    public void isSeparateDataFile(boolean bl) {
        if (this._options == null) {
            return;
        }
        this._separateDataFile = bl;
    }

    public boolean isTableNameVisible() {
        return this._isTableNameVisible;
    }

    public void isTableNameVisible(boolean bl) {
        this._isTableNameVisible = bl;
    }

    public String getTableName() {
        return this._options != null && ((IExportFormatOptions)this._options).isTableNameSupported() ? this._tableName : "";
    }

    public void setTableName(String string) {
        if (this._options == null) {
            return;
        }
        this._tableName = string;
    }

    public boolean isQuerySaved() {
        return this._saveQuery;
    }

    public void isQuerySaved(boolean bl) {
        this._saveQuery = bl;
    }

    public String getQueryName() {
        return this._queryName != null ? this._queryName : "";
    }

    public void setQueryName(String string) {
        this._queryName = string;
    }

    public String getDataName() {
        return this._dataName != null ? this._dataName : "";
    }

    public void setDataName(String string) {
        this._dataName = string;
    }

    public int getVariableLengthMax() {
        return this._variableLengthMax;
    }

    public void setVariableLengthMax(int n) {
        this._variableLengthMax = n;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public String getTitle() {
        return this._title;
    }

    public void setSubject(String string) {
        this._subject = string;
    }

    public String getSubject() {
        return this._subject;
    }

    public void setKeywords(String string) {
        this._keywords = string;
    }

    public String getKeywords() {
        return this._keywords;
    }

    @Override
    public void setFormat(String string) {
        super.setFormat(string);
        this.initConfigFormatOptions();
    }

    public String getFileExtension() {
        if (this._exportEnabled && this._formatter != null) {
            return this._formatter.getExt();
        }
        return "sql";
    }

    public boolean isTextEditorReadable() {
        if (this._exportEnabled && this._formatter != null) {
            return this._formatter.isTextEditorReadable();
        }
        return false;
    }

    public boolean isStandardEncodings() {
        if (this._exportEnabled && this._formatter != null) {
            return this._formatter.isStandardEncodings();
        }
        return false;
    }

    public String[] getEncodings() {
        if (this._exportEnabled && this._formatter != null) {
            return this._formatter.getEncodings();
        }
        return null;
    }

    public boolean isTruncate() {
        return this._isTruncate;
    }

    public void isTruncate(boolean bl) {
        this._isTruncate = bl;
    }

    public boolean isDisableConstraints() {
        return this._isDisableConstraints;
    }

    public void isDisableConstraints(boolean bl) {
        this._isDisableConstraints = bl;
    }

    public DefaultMutableTreeNode getSummaryNode(ExtractListModel extractListModel) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString("DATA_OPTIONS"));
        if (extractListModel.getGlobalWhere() != "") {
            defaultMutableTreeNode.add(extractListModel.getSummaryGlobalWhere());
        }
        if (this._formatter != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("FORMAT") + ": " + this._formatter.getType()));
            if (this._formatter.isHeaderOptionSupported()) {
                defaultMutableTreeNode.add(ExtractListModel.getSummaryBooleanItem(ExtractResources.getString("HEADER"), this._header));
            }
            if (this._formatter.isDelimiterSupported()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("DELIMITER") + ": " + this._delimiter));
            }
            if (this._formatter.isEnclosuresSupported()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("ENCLOSURE_LEFT") + ": " + this._enclosureLeft));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("ENCLOSURE_RIGHT") + ": " + this._enclosureRight));
            }
            if (this._formatter.isLineTerminatorSupported()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("RECORD_TERMINATOR") + ": " + this._recTerm));
            }
            if (this._formatter.isDataNameSupported()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("WORKSHEET_NAME") + ": " + this._dataName));
            }
            if (this._formatter.isQuerySupported()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("QUERY_NAME") + ": " + this._queryName));
                defaultMutableTreeNode.add(ExtractListModel.getSummaryBooleanItem(ExtractResources.getString("SAVE_QUERY"), this._saveQuery));
            }
        }
        return defaultMutableTreeNode;
    }

    @Override
    protected void initFormat() {
        DBConfig dBConfig = DBConfig.getInstance();
        if (this._usage == EXPORT_WIZARD || this._format == null || this._format.length() == 0) {
            super.setFormat(dBConfig.getString("EXPORT_DATA_FORMAT"));
        }
        this.initExportConfigOptions();
    }

    protected void initExportConfigOptions() {
        DBConfig dBConfig = DBConfig.getInstance();
        Boolean bl = dBConfig.getBoolean("EXPORT_DATA_ENABLED");
        if (bl != null) {
            this._exportEnabled = bl;
        }
        this.initConfigFormatOptions();
    }

    protected void initConfigFormatOptions() {
        Boolean bl;
        DBConfig dBConfig = DBConfig.getInstance();
        super.initConfigOptions();
        IExportFormatOptions iExportFormatOptions = (IExportFormatOptions)this._options;
        if (iExportFormatOptions.isDataNameSupported()) {
            this._dataName = dBConfig.getString(iExportFormatOptions.getDataNameConfigKey());
        }
        if (iExportFormatOptions.isQuerySupported()) {
            bl = dBConfig.getBoolean(iExportFormatOptions.getQueryConfigKey());
            if (bl != null) {
                this._saveQuery = bl;
            }
            this._queryName = dBConfig.getString(iExportFormatOptions.getQueryNameConfigKey());
        }
        if (iExportFormatOptions.isSeparateDataFileSupported() && (bl = dBConfig.getBoolean(iExportFormatOptions.getSeparateDataFileConfigKey())) != null) {
            this._separateDataFile = bl;
        }
        if ((bl = dBConfig.getBoolean("EXPORT_LDR_LOG_FILE")) != null) {
            this._ldrLogFile = bl;
        }
        this._ldrLogDir = dBConfig.getString("EXPORT_LDR_LOG_DIR");
        bl = dBConfig.getBoolean("EXPORT_LDR_BAD_FILE");
        if (bl != null) {
            this._ldrBadFile = bl;
        }
        this._ldrBadDir = dBConfig.getString("EXPORT_LDR_BAD_DIR");
        if (this.isPDF() && this._useConfigOptions) {
            this.setTitle(dBConfig.getString("PDF_TITLE"));
            this.setSubject(dBConfig.getString("PDF_SUBJECT"));
            this.setKeywords(dBConfig.getString("PDF_KEYWORDS"));
        }
    }

    @Override
    public void saveBasicPreferences(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("EXPORT_DATA_ENABLED", this.isExportEnabled());
        dBConfig.putString("EXPORT_DATA_FORMAT", this._format);
    }

    @Override
    public void saveFormatPreferences(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        super.saveFormatPreferences(traversableContext);
        IExportFormatOptions iExportFormatOptions = (IExportFormatOptions)this._options;
        if (iExportFormatOptions.isDataNameSupported()) {
            dBConfig.putString(iExportFormatOptions.getDataNameConfigKey(), this._dataName);
        }
        if (iExportFormatOptions.isQuerySupported()) {
            dBConfig.putBoolean(iExportFormatOptions.getQueryConfigKey(), this._saveQuery);
            dBConfig.putString(iExportFormatOptions.getQueryNameConfigKey(), this._queryName);
        }
        if (iExportFormatOptions.isSeparateDataFileSupported()) {
            dBConfig.putBoolean(iExportFormatOptions.getSeparateDataFileConfigKey(), this._separateDataFile);
        }
    }

    public void setUseConfigOptions(boolean bl) {
        this._useConfigOptions = bl;
    }

    public boolean useConfigOptions() {
        return this._useConfigOptions;
    }
}

