/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.bali.ewt.border.TitledPane;
import oracle.dbtools.raptor.export.wizard.ExportFormatOptionsPanel;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.export.wizard.TargetOptionsPanel;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.ui.panels.DdlOptionsPanel;
import oracle.ide.util.ResourceUtils;

public class DataOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel _dataOptionsPanel;
    private JPanel _optionsPanel;
    private JPanel _formatPanel;
    private JCheckBox _exportData;
    private JComboBox _format;
    private ExtractDataFormat _dataFormat;
    private ExportFormatOptionsPanel _formatOptions;
    private TargetOptionsPanel _targetOptions;
    private DdlOptionsPanel _ddlOptions;
    private ItemListener _exportListener;
    private boolean _exportListenerAdded = false;
    private int _usage;
    ItemListener _formatListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                DataOptionsPanel.this._dataFormat.setFormat((String)DataOptionsPanel.this._format.getSelectedItem());
                DataOptionsPanel.this._format.removeItemListener(DataOptionsPanel.this._formatListener);
                DataOptionsPanel.this._formatPanel.removeAll();
                DataOptionsPanel.this._formatOptions.removeAll();
                DataOptionsPanel.this._formatOptions.setOptions(DataOptionsPanel.this._dataFormat.getOptions());
                DataOptionsPanel.this._formatPanel = DataOptionsPanel.this._formatOptions.getFormatPanel();
                DataOptionsPanel.this._format = DataOptionsPanel.this._formatOptions.getFormatComponent();
                String string = "sql";
                if (DataOptionsPanel.this._ddlOptions == null || DataOptionsPanel.this._ddlOptions != null && !DataOptionsPanel.this._ddlOptions.getFormat().isExtractEnabled()) {
                    string = DataOptionsPanel.this._dataFormat.getFileExtension();
                }
                DataOptionsPanel.this._targetOptions.adjustSaveAs(string, DataOptionsPanel.this._dataFormat);
                DataOptionsPanel.this._targetOptions.setEncodings(DataOptionsPanel.this._dataFormat);
                DataOptionsPanel.this._format.addItemListener(DataOptionsPanel.this._formatListener);
                DataOptionsPanel.this._formatOptions.revalidate();
                DataOptionsPanel.this._formatOptions.repaint();
                DataOptionsPanel.this._dataOptionsPanel.revalidate();
                DataOptionsPanel.this._dataOptionsPanel.repaint();
            }
        }
    };
    ItemListener _formatPreferencesListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                DataOptionsPanel.this._dataFormat.setFormat((String)DataOptionsPanel.this._format.getSelectedItem());
                DataOptionsPanel.this._targetOptions.setEncodings(DataOptionsPanel.this._dataFormat);
            }
        }
    };

    public DataOptionsPanel(int n) {
        this._usage = n;
        this._dataFormat = new ExtractDataFormat(n);
        this._formatOptions = new ExportFormatOptionsPanel(this._dataFormat);
    }

    public DataOptionsPanel(String string, ExtractDataFormat extractDataFormat) {
        this._usage = ExtractDataFormat.EXPORT_WIZARD;
        this._dataFormat = extractDataFormat;
        if (string.equals("5")) {
            this._dataFormat.isTableNameVisible(true);
        }
        this._formatOptions = new ExportFormatOptionsPanel(this._dataFormat);
    }

    public JCheckBox getExportDataComponent() {
        return this._exportData;
    }

    public Component getFormatComponent() {
        return this._formatOptions != null ? this._formatOptions.getFormatComponent() : null;
    }

    public void setTargetOptions(TargetOptionsPanel targetOptionsPanel) {
        this._targetOptions = targetOptionsPanel;
    }

    public void setDDLOptions(DdlOptionsPanel ddlOptionsPanel) {
        this._ddlOptions = ddlOptionsPanel;
    }

    public ExtractDataFormat getFormat() {
        if (this._exportData != null) {
            this._dataFormat.isExportEnabled(this._exportData.isSelected());
            String string = (String)this._format.getSelectedItem();
            this._dataFormat.setFormat(string);
            if (string != null) {
                this.getFormatProperties();
            }
        }
        return this._dataFormat;
    }

    public ExtractDataFormat getFormatForPrefs() {
        this._dataFormat.isExportEnabled(this._exportData.isSelected());
        String string = (String)this._format.getSelectedItem();
        this._dataFormat.setFormat(string);
        return this._dataFormat;
    }

    public ExtractDataFormat getFormatProperties() {
        this._formatOptions.getFormatProperties();
        return this._dataFormat;
    }

    public void allowDisable(boolean bl) {
        this._exportData.setSelected(!bl);
        this._exportData.setEnabled(bl);
        if (bl) {
            this.addExportListener();
        } else {
            this.removeExportListener();
        }
    }

    public boolean isExportEnabled() {
        return this._dataFormat.isExportEnabled();
    }

    public void isExportEnabled(boolean bl) {
        this._dataFormat.isExportEnabled(bl);
    }

    public JPanel getPanel() {
        this._optionsPanel = new JPanel(new GridBagLayout());
        this._dataOptionsPanel = new JPanel(new BorderLayout());
        int n = 0;
        this._exportData = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._exportData, (String)ExportWizArb.getString("OPT_TITLE_DATA"));
        this._exportData.setSelected(this._dataFormat.isExportEnabled());
        if (this._usage != ExtractDataFormat.EXPORT_PREFERENCES) {
            this.addExportListener();
            this._formatPanel = this._formatOptions.getFormatPanel();
            this._format = this._formatOptions.getFormatComponent();
            this._optionsPanel.add((Component)this._formatPanel, new GridBagConstraints(0, ++n, 5, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
            this._format.setSelectedItem(this._dataFormat.getFormat());
            this._format.addItemListener(this._formatListener);
        } else {
            this._formatPanel = this._formatOptions.getLimitedFormatPanel();
            this._format = this._formatOptions.getFormatComponent();
            this._optionsPanel.add((Component)this._formatPanel, new GridBagConstraints(0, ++n, 5, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
            this._format.setSelectedItem(this._dataFormat.getFormat());
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._optionsPanel, new GridBagConstraints(0, 0, 1, 1, 0.7, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 0, 1, 0.5, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        TitledPane titledPane = new TitledPane((Component)this._exportData, (Component)jPanel);
        this._dataOptionsPanel.add((Component)titledPane, "Center");
        return this._dataOptionsPanel;
    }

    public JPanel getFormatPanel() {
        this._formatOptions.getFormatPanel();
        return this._formatPanel;
    }

    void addExportListener() {
        if (!this._exportListenerAdded) {
            this._exportListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    DataOptionsPanel.this.enableOptions(DataOptionsPanel.this._exportData.isSelected());
                }
            };
            this._exportData.addItemListener(this._exportListener);
            this._exportListenerAdded = true;
        }
    }

    void removeExportListener() {
        if (this._exportListenerAdded) {
            this._exportData.removeItemListener(this._exportListener);
        }
        this._exportListenerAdded = false;
    }

    void enableOptions(boolean bl) {
        if (this._format != null) {
            this._format.setEnabled(bl);
        }
        this._formatOptions.enableOptions(bl);
    }
}

