/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.data;

import java.io.OutputStreamWriter;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.schemacopy.CopyPanelArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.util.IdeUtil;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdeveloper.db.ConnectionException;
import oracle.sql.BFILE;
import oracle.sql.DATE;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMP;
import oracle.xdb.XMLType;

public class DataMover
extends CommandListener {
    private Connection _fromConn;
    private Connection _toConn;
    private OutputStreamWriter _out;
    private String _EOL = null;
    private boolean m_isBlobColumnExists = false;

    public DataMover() {
    }

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    public DataMover(String string, String string2, List<DBObject> list) throws ConnectionException {
        this._fromConn = Connections.getInstance().getUniqueConnection(string);
        this._toConn = Connections.getInstance().getUniqueConnection(string2);
    }

    public DataMover(Connection connection, Connection connection2, ArrayList<DBObject> arrayList) throws ConnectionException {
        this._fromConn = Connections.getInstance().cloneConnection(connection);
        this._toConn = Connections.getInstance().cloneConnection(connection2);
        for (DBObject dBObject : arrayList) {
            this.move(dBObject, true);
        }
    }

    public DataMover(Connection connection, Connection connection2) {
        this._fromConn = connection;
        this._toConn = connection2;
    }

    private synchronized void feedback(String string) {
        String string2 = IdeUtil.getIdeEncoding();
        if (string == null) {
            return;
        }
        if (this._out != null) {
            try {
                this._out.write(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setLogFile(OutputStreamWriter outputStreamWriter) {
        this._out = outputStreamWriter;
    }

    public void close() {
        try {
            if (!this._fromConn.isClosed()) {
                this._fromConn.close();
            }
            if (!this._toConn.isClosed()) {
                this._toConn.close();
            }
        }
        catch (SQLException sQLException) {
            this.feedback(sQLException.getMessage() + this.getTerm());
        }
    }

    public void move(DBObject dBObject, boolean bl) {
        String string = "";
        int n = 0;
        this.move(dBObject, string, n, bl);
    }

    public void move(DBObject dBObject, String string, boolean bl) {
        int n = 0;
        this.move(dBObject, string, n, bl);
    }

    public void move(DBObject dBObject, String string, int n, boolean bl) {
        this.move(dBObject, "*", string, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(DBObject dBObject, String string, String string2, int n, boolean bl) {
        String string3 = null;
        String string4 = null;
        long l = System.currentTimeMillis();
        switch (n) {
            case 0: {
                string3 = "select " + string + " from " + DBUtil.addDoubleQuote((String)dBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName()) + " " + string2;
                string4 = "insert into " + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                break;
            }
            case 1: {
                String string5 = DBUtil.addDoubleQuote((String)dBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                string3 = "select " + string + " from " + string5 + " " + string2;
                string4 = "insert into " + string5;
                break;
            }
            case 2: {
                String string5 = DBUtil.addDoubleQuote((String)dBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                string3 = "select " + string + " from " + string5 + " " + string2;
                string4 = "insert into " + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
            }
        }
        ResultSet resultSet = null;
        OracleCallableStatement oracleCallableStatement = null;
        PreparedStatement preparedStatement = null;
        int[] nArray = null;
        try {
            preparedStatement = this._fromConn.prepareStatement(string3);
            resultSet = preparedStatement.executeQuery();
            resultSet.setFetchSize(100);
            int n2 = resultSet.getMetaData().getColumnCount();
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = 1; i <= n2; ++i) {
                if (i != 1) {
                    stringBuilder.append(",");
                    stringBuilder2.append(",");
                }
                stringBuilder.append(DBUtil.addDoubleQuote((String)resultSet.getMetaData().getColumnName(i)));
                stringBuilder2.append(":");
                stringBuilder2.append(resultSet.getMetaData().getColumnName(i).replaceAll(" ", "_"));
            }
            string4 = string4 + "(" + stringBuilder.toString() + ")" + " values (" + stringBuilder2.toString() + ")";
            oracleCallableStatement = (OracleCallableStatement)this._toConn.prepareCall(string4);
            int n3 = 0;
            long l2 = 0L;
            while (resultSet.next()) {
                if (Thread.interrupted()) {
                    return;
                }
                this.m_isBlobColumnExists = false;
                block30: for (int i = 1; i <= n2; ++i) {
                    int n4 = resultSet.getMetaData().getColumnType(i);
                    switch (n4) {
                        case 2004: {
                            this.m_isBlobColumnExists = true;
                            Blob blob = resultSet.getBlob(i);
                            if (blob != null) {
                                oracleCallableStatement.setBlob(i, blob.getBinaryStream());
                                continue block30;
                            }
                            oracleCallableStatement.setBlob(i, blob);
                            continue block30;
                        }
                        case 2005: {
                            Clob clob = resultSet.getClob(i);
                            if (clob != null) {
                                oracleCallableStatement.setClob(i, clob.getCharacterStream());
                                continue block30;
                            }
                            oracleCallableStatement.setClob(i, clob);
                            continue block30;
                        }
                        case 2007: {
                            DATE dATE;
                            if (resultSet.getMetaData().getColumnTypeName(i).compareTo("SYS.XMLTYPE") != 0) continue block30;
                            BFILE bFILE = ((OracleResultSet)resultSet).getOPAQUE(i);
                            if (bFILE != null) {
                                dATE = XMLType.createXML((OPAQUE)bFILE);
                                oracleCallableStatement.setObject(i, (Object)(dATE != null ? dATE.getStringVal() : null));
                                continue block30;
                            }
                            oracleCallableStatement.setObject(i, (Object)bFILE);
                            continue block30;
                        }
                        case -13: {
                            BFILE bFILE = ((OracleResultSet)resultSet).getBFILE(i);
                            oracleCallableStatement.setBfile(i, bFILE);
                            continue block30;
                        }
                        case 91: {
                            DATE dATE = ((OracleResultSet)resultSet).getDATE(i);
                            oracleCallableStatement.setDATE(i, dATE);
                            continue block30;
                        }
                        case -1: {
                            if (!this.m_isBlobColumnExists) {
                                oracleCallableStatement.setString(i, resultSet.getString(i));
                                continue block30;
                            }
                            oracleCallableStatement.setString(i, null);
                            continue block30;
                        }
                        case 92: 
                        case 93: {
                            TIMESTAMP tIMESTAMP = ((OracleResultSet)resultSet).getTIMESTAMP(i);
                            TIMESTAMP tIMESTAMP2 = tIMESTAMP != null ? new TIMESTAMP(tIMESTAMP.timestampValue()) : null;
                            oracleCallableStatement.setTIMESTAMP(i, tIMESTAMP2);
                            continue block30;
                        }
                        default: {
                            oracleCallableStatement.setObject(i, resultSet.getObject(i));
                        }
                    }
                }
                oracleCallableStatement.addBatch();
                if (++n3 < 500) continue;
                nArray = oracleCallableStatement.executeBatch();
                l2 += (long)n3;
                n3 = 0;
            }
            if (n3 > 0) {
                l2 += (long)n3;
                nArray = oracleCallableStatement.executeBatch();
            }
            if (bl) {
                this.feedback(MessageFormat.format(this.getTerm() + CopyPanelArb.getString("INSERTED_ROWS_INTO") + this.getTerm(), l2, dBObject.getObjectName(), System.currentTimeMillis() - l));
            }
            this._toConn.commit();
        }
        catch (SQLException sQLException) {
            if (bl) {
                this.feedback(CopyPanelArb.getString("DATA_INSERT_ERROR") + this.getTerm() + dBObject.getObjectName() + "  " + sQLException.getMessage() + this.getTerm());
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (Exception exception) {
                this.feedback(exception.getMessage() + this.getTerm());
            }
        }
    }

    private OraDATEFormat getDateFormat() {
        try {
            return ((OracleNLSProvider)NLSProvider.getProvider((Connection)this._toConn)).getOraDATEFormat();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(OutputStreamWriter outputStreamWriter, Connection connection, Connection connection2, HashMap<String, String> hashMap) throws Exception {
        ResultSetWrapper resultSetWrapper;
        this._out = outputStreamWriter;
        DDLFormat dDLFormat = DDLGenerator.getInstance().getFormating();
        DDLFormat dDLFormat2 = new DDLFormat();
        dDLFormat2.setDrop(true);
        dDLFormat2.setSchema(false);
        dDLFormat2.setSegments(false);
        dDLFormat2.setTerminiator(true);
        DDLGenerator.getInstance().setFormating(dDLFormat2);
        StringBuilder stringBuilder = new StringBuilder("select user ,object_name,object_type from user_objects ");
        boolean bl = false;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (hashMap.get("FILTER") != null) {
            if (bl) {
                stringBuilder.append(" and object_name like :FILTER");
            } else {
                stringBuilder.append(" where object_name like :FILTER");
                bl = true;
            }
        }
        if (hashMap.get("TYPES") != null) {
            if (bl) {
                stringBuilder.append(" and instr(:TYPES,upper(object_name)) > 0");
            } else {
                stringBuilder.append(" where instr(:TYPES,upper(object_name)) > 0");
                bl = true;
            }
        }
        if ((resultSetWrapper = DBUtil.getInstance((Connection)connection).executeQuery(stringBuilder.toString(), hashMap)) != null) {
            try {
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    arrayList.add(new DBObject(DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", Connections.getInstance().getConnectionName(connection), null, resultSet.getString(1), resultSet.getString(3)), resultSet.getString(2))));
                }
            }
            finally {
                resultSetWrapper.close();
            }
        }
        this._fromConn = connection;
        this._toConn = connection2;
        for (DBObject dBObject : arrayList) {
            this.move(dBObject, true);
        }
        DDLGenerator.getInstance().setFormating(dDLFormat);
    }

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (iSQLCommand.getSql().trim().toLowerCase().startsWith("copyschema")) {
                String[] stringArray = iSQLCommand.getSql().split("\\W");
                Connection connection2 = Connections.getInstance().getConnection(stringArray[3]);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int i = 3; i < stringArray.length; i += 2) {
                    hashMap.put(stringArray[i].toUpperCase(), stringArray[i + 1]);
                }
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return false;
    }
}

